@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cas.kotlin.inputs

import com.pulumi.alicloud.cas.inputs.GetServiceCertificatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServiceCertificates.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Certificate IDs.
 * @property lang The lang.
 * @property nameRegex A regex string to filter results by Certificate name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetServiceCertificatesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cas.inputs.GetServiceCertificatesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cas.inputs.GetServiceCertificatesPlainArgs =
        com.pulumi.alicloud.cas.inputs.GetServiceCertificatesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceCertificatesPlainArgs].
 */
@PulumiTagMarker
public class GetServiceCertificatesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var lang: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("heugrdonxeeaoqnk")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Certificate IDs.
     */
    @JvmName("qxhayffxdbbyyxmm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Certificate IDs.
     */
    @JvmName("wnlvktuiukyjntdc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The lang.
     */
    @JvmName("ohxsgqbadtsdqpsv")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value A regex string to filter results by Certificate name.
     */
    @JvmName("ylqpbdpsdiactgup")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xkpypbgsrccetsib")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetServiceCertificatesPlainArgs = GetServiceCertificatesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        lang = lang,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
