@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cas.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCertificates.
 * @property certificates A list of apis. Each element contains the following attributes:
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of cert IDs.
 * @property lang
 * @property nameRegex
 * @property names A list of cert names.
 * @property outputFile
 */
public data class GetCertificatesResult(
    public val certificates: List<GetCertificatesCertificate>,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val lang: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cas.outputs.GetCertificatesResult): GetCertificatesResult = GetCertificatesResult(
            certificates = javaType.certificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cas.kotlin.outputs.GetCertificatesCertificate.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
