@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cas.kotlin.outputs

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property buyInAliyun The cert is buy from aliyun or not.
 * @property cert The cert's Cert.
 * @property certId The cert's id.
 * @property certificateName The cert's name.
 * @property city The cert's city.
 * @property common The cert's common name.
 * @property country The cert's country.
 * @property endDate The cert's not valid after time.
 * @property expired The cert is expired or not.
 * @property fingerprint The cert's finger.
 * @property id The cert's id.
 * @property issuer The cert's Issuer.
 * @property key The cert's Keye.
 * @property name
 * @property orgName The cert's organization.
 * @property province The cert's province.
 * @property sans The cert's subject alternative name.
 * @property startDate The cert's not valid before time.
 */
public data class GetServiceCertificatesCertificate(
    public val buyInAliyun: Boolean,
    public val cert: String,
    public val certId: String,
    public val certificateName: String,
    public val city: String,
    public val common: String,
    public val country: String,
    public val endDate: String,
    public val expired: Boolean,
    public val fingerprint: String,
    public val id: String,
    public val issuer: String,
    public val key: String,
    @Deprecated(
        message = """
  Field 'name' has been deprecated from provider version 1.129.0 and it will be removed in the
      future version. Please use the new attribute 'certificate_name' instead.
  """,
    )
    public val name: String,
    public val orgName: String,
    public val province: String,
    public val sans: String,
    public val startDate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cas.outputs.GetServiceCertificatesCertificate): GetServiceCertificatesCertificate = GetServiceCertificatesCertificate(
            buyInAliyun = javaType.buyInAliyun(),
            cert = javaType.cert(),
            certId = javaType.certId(),
            certificateName = javaType.certificateName(),
            city = javaType.city(),
            common = javaType.common(),
            country = javaType.country(),
            endDate = javaType.endDate(),
            expired = javaType.expired(),
            fingerprint = javaType.fingerprint(),
            id = javaType.id(),
            issuer = javaType.issuer(),
            key = javaType.key(),
            name = javaType.name(),
            orgName = javaType.orgName(),
            province = javaType.province(),
            sans = javaType.sans(),
            startDate = javaType.startDate(),
        )
    }
}
