@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BackupPlan].
 */
@PulumiTagMarker
public class BackupPlanResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPlanArgs = BackupPlanArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPlanArgsBuilder.() -> Unit) {
        val builder = BackupPlanArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BackupPlan {
        val builtJavaResource = com.pulumi.alicloud.cassandra.BackupPlan(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackupPlan(builtJavaResource)
    }
}

/**
 * Provides a Cassandra Backup Plan resource.
 * For information about Cassandra Backup Plan and how to use it, see [What is Backup Plan](https://www.alibabacloud.com/help/doc-detail/157522.htm).
 * > **NOTE:** Available in v1.128.0+.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
 * ## Import
 * Cassandra Backup Plan can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cassandra/backupPlan:BackupPlan example <cluster_id>:<data_center_id>
 * ```
 */
public class BackupPlan internal constructor(
    override val javaResource: com.pulumi.alicloud.cassandra.BackupPlan,
) : KotlinCustomResource(javaResource, BackupPlanMapper) {
    /**
     * Specifies whether to activate the backup plan. Valid values: `True`, `False`. Default value: `True`.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * The backup cycle. Valid values: `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday`, `Wednesday`.
     */
    public val backupPeriod: Output<String>
        get() = javaResource.backupPeriod().applyValue({ args0 -> args0 })

    /**
     * The start time of the backup task each day. The time is displayed in UTC and denoted by Z.
     */
    public val backupTime: Output<String>
        get() = javaResource.backupTime().applyValue({ args0 -> args0 })

    /**
     * The ID of the cluster for the backup.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The ID of the data center for the backup in the cluster.
     */
    public val dataCenterId: Output<String>
        get() = javaResource.dataCenterId().applyValue({ args0 -> args0 })

    /**
     * The duration for which you want to retain the backup. Valid values: 1 to 30. Unit: days. Default value: `30`.
     */
    public val retentionPeriod: Output<Int>
        get() = javaResource.retentionPeriod().applyValue({ args0 -> args0 })
}

public object BackupPlanMapper : ResourceMapper<BackupPlan> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cassandra.BackupPlan::class == javaResource::class

    override fun map(javaResource: Resource): BackupPlan = BackupPlan(
        javaResource as
            com.pulumi.alicloud.cassandra.BackupPlan,
    )
}

/**
 * @see [BackupPlan].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPlan].
 */
public suspend fun backupPlan(name: String, block: suspend BackupPlanResourceBuilder.() -> Unit): BackupPlan {
    val builder = BackupPlanResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPlan].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPlan(name: String): BackupPlan {
    val builder = BackupPlanResourceBuilder()
    builder.name(name)
    return builder.build()
}
