@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin

import com.pulumi.alicloud.cassandra.BackupPlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cassandra Backup Plan resource.
 * For information about Cassandra Backup Plan and how to use it, see [What is Backup Plan](https://www.alibabacloud.com/help/doc-detail/157522.htm).
 * > **NOTE:** Available in v1.128.0+.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
 * ## Import
 * Cassandra Backup Plan can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cassandra/backupPlan:BackupPlan example <cluster_id>:<data_center_id>
 * ```
 * @property active Specifies whether to activate the backup plan. Valid values: `True`, `False`. Default value: `True`.
 * @property backupPeriod The backup cycle. Valid values: `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday`, `Wednesday`.
 * @property backupTime The start time of the backup task each day. The time is displayed in UTC and denoted by Z.
 * @property clusterId The ID of the cluster for the backup.
 * @property dataCenterId The ID of the data center for the backup in the cluster.
 * @property retentionPeriod The duration for which you want to retain the backup. Valid values: 1 to 30. Unit: days. Default value: `30`.
 */
public data class BackupPlanArgs(
    public val active: Output<Boolean>? = null,
    public val backupPeriod: Output<String>? = null,
    public val backupTime: Output<String>? = null,
    public val clusterId: Output<String>? = null,
    public val dataCenterId: Output<String>? = null,
    public val retentionPeriod: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cassandra.BackupPlanArgs> {
    override fun toJava(): com.pulumi.alicloud.cassandra.BackupPlanArgs =
        com.pulumi.alicloud.cassandra.BackupPlanArgs.builder()
            .active(active?.applyValue({ args0 -> args0 }))
            .backupPeriod(backupPeriod?.applyValue({ args0 -> args0 }))
            .backupTime(backupTime?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .dataCenterId(dataCenterId?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupPlanArgs].
 */
@PulumiTagMarker
public class BackupPlanArgsBuilder internal constructor() {
    private var active: Output<Boolean>? = null

    private var backupPeriod: Output<String>? = null

    private var backupTime: Output<String>? = null

    private var clusterId: Output<String>? = null

    private var dataCenterId: Output<String>? = null

    private var retentionPeriod: Output<Int>? = null

    /**
     * @param value Specifies whether to activate the backup plan. Valid values: `True`, `False`. Default value: `True`.
     */
    @JvmName("uqgmfwdyylrmqqac")
    public suspend fun active(`value`: Output<Boolean>) {
        this.active = value
    }

    /**
     * @param value The backup cycle. Valid values: `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday`, `Wednesday`.
     */
    @JvmName("naojapetcxgncvhc")
    public suspend fun backupPeriod(`value`: Output<String>) {
        this.backupPeriod = value
    }

    /**
     * @param value The start time of the backup task each day. The time is displayed in UTC and denoted by Z.
     */
    @JvmName("klrydgagljxmaxoj")
    public suspend fun backupTime(`value`: Output<String>) {
        this.backupTime = value
    }

    /**
     * @param value The ID of the cluster for the backup.
     */
    @JvmName("eueelbvyjhwhmtip")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value The ID of the data center for the backup in the cluster.
     */
    @JvmName("iwjghpiyulemlant")
    public suspend fun dataCenterId(`value`: Output<String>) {
        this.dataCenterId = value
    }

    /**
     * @param value The duration for which you want to retain the backup. Valid values: 1 to 30. Unit: days. Default value: `30`.
     */
    @JvmName("oofqimfnniijwvfp")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value Specifies whether to activate the backup plan. Valid values: `True`, `False`. Default value: `True`.
     */
    @JvmName("aviqorwgvxowkwin")
    public suspend fun active(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.active = mapped
    }

    /**
     * @param value The backup cycle. Valid values: `Friday`, `Monday`, `Saturday`, `Sunday`, `Thursday`, `Tuesday`, `Wednesday`.
     */
    @JvmName("qwjipjbnviiajbcf")
    public suspend fun backupPeriod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupPeriod = mapped
    }

    /**
     * @param value The start time of the backup task each day. The time is displayed in UTC and denoted by Z.
     */
    @JvmName("kkejbwdyisqkuunn")
    public suspend fun backupTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupTime = mapped
    }

    /**
     * @param value The ID of the cluster for the backup.
     */
    @JvmName("baivvwydvgdwwhec")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The ID of the data center for the backup in the cluster.
     */
    @JvmName("rhtxeaplworillru")
    public suspend fun dataCenterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCenterId = mapped
    }

    /**
     * @param value The duration for which you want to retain the backup. Valid values: 1 to 30. Unit: days. Default value: `30`.
     */
    @JvmName("hiyyivrcjtlogvnf")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    internal fun build(): BackupPlanArgs = BackupPlanArgs(
        active = active,
        backupPeriod = backupPeriod,
        backupTime = backupTime,
        clusterId = clusterId,
        dataCenterId = dataCenterId,
        retentionPeriod = retentionPeriod,
    )
}
