@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin

import com.pulumi.alicloud.cassandra.CassandraFunctions.getBackupPlansPlain
import com.pulumi.alicloud.cassandra.CassandraFunctions.getClustersPlain
import com.pulumi.alicloud.cassandra.CassandraFunctions.getDataCentersPlain
import com.pulumi.alicloud.cassandra.CassandraFunctions.getZonesPlain
import com.pulumi.alicloud.cassandra.kotlin.inputs.GetBackupPlansPlainArgs
import com.pulumi.alicloud.cassandra.kotlin.inputs.GetBackupPlansPlainArgsBuilder
import com.pulumi.alicloud.cassandra.kotlin.inputs.GetClustersPlainArgs
import com.pulumi.alicloud.cassandra.kotlin.inputs.GetClustersPlainArgsBuilder
import com.pulumi.alicloud.cassandra.kotlin.inputs.GetDataCentersPlainArgs
import com.pulumi.alicloud.cassandra.kotlin.inputs.GetDataCentersPlainArgsBuilder
import com.pulumi.alicloud.cassandra.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.cassandra.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.cassandra.kotlin.outputs.GetBackupPlansResult
import com.pulumi.alicloud.cassandra.kotlin.outputs.GetClustersResult
import com.pulumi.alicloud.cassandra.kotlin.outputs.GetDataCentersResult
import com.pulumi.alicloud.cassandra.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cassandra.kotlin.outputs.GetBackupPlansResult.Companion.toKotlin as getBackupPlansResultToKotlin
import com.pulumi.alicloud.cassandra.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.alicloud.cassandra.kotlin.outputs.GetDataCentersResult.Companion.toKotlin as getDataCentersResultToKotlin
import com.pulumi.alicloud.cassandra.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object CassandraFunctions {
    /**
     * This data source provides the Cassandra Backup Plans of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.128.0+.
     * > **DEPRECATED:**  This data source has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cassandra.getBackupPlans({
     *     clusterId: "example_value",
     * });
     * export const firstCassandraBackupPlanId = example.then(example => example.plans?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cassandra.get_backup_plans(cluster_id="example_value")
     * pulumi.export("firstCassandraBackupPlanId", example.plans[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cassandra.GetBackupPlans.Invoke(new()
     *     {
     *         ClusterId = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["firstCassandraBackupPlanId"] = example&#46;Apply(getBackupPlansResult => getBackupPlansResult&#46;Plans[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cassandra"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cassandra.GetBackupPlans(ctx, &cassandra.GetBackupPlansArgs{
     * 			ClusterId: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("firstCassandraBackupPlanId", example.Plans[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cassandra.CassandraFunctions;
     * import com.pulumi.alicloud.cassandra.inputs.GetBackupPlansArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CassandraFunctions.getBackupPlans(GetBackupPlansArgs.builder()
     *             .clusterId("example_value")
     *             .build());
     *         ctx.export("firstCassandraBackupPlanId", example.applyValue(getBackupPlansResult -> getBackupPlansResult.plans()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cassandra:getBackupPlans
     *       Arguments:
     *         clusterId: example_value
     * outputs:
     *   firstCassandraBackupPlanId: ${example.plans[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBackupPlans.
     * @return A collection of values returned by getBackupPlans.
     */
    public suspend fun getBackupPlans(argument: GetBackupPlansPlainArgs): GetBackupPlansResult =
        getBackupPlansResultToKotlin(getBackupPlansPlain(argument.toJava()).await())

    /**
     * @see [getBackupPlans].
     * @param clusterId The ID of the cluster for the backup.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getBackupPlans.
     */
    public suspend fun getBackupPlans(clusterId: String, outputFile: String? = null): GetBackupPlansResult {
        val argument = GetBackupPlansPlainArgs(
            clusterId = clusterId,
            outputFile = outputFile,
        )
        return getBackupPlansResultToKotlin(getBackupPlansPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupPlans].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cassandra&#46;kotlin&#46;inputs&#46;GetBackupPlansPlainArgs].
     * @return A collection of values returned by getBackupPlans.
     */
    public suspend fun getBackupPlans(argument: suspend GetBackupPlansPlainArgsBuilder.() -> Unit): GetBackupPlansResult {
        val builder = GetBackupPlansPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupPlansResultToKotlin(getBackupPlansPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.cassandra.getClusters` data source provides a collection of Cassandra clusters available in Alicloud account.
     * Filters support regular expression for the cluster name, ids or tags.
     * > **NOTE:**  Available in 1.88.0+.
     * > **DEPRECATED:**  This data source has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const cassandra = alicloud.cassandra.getClusters({
     *     nameRegex: "tf_testAccCassandra",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * cassandra = alicloud.cassandra.get_clusters(name_regex="tf_testAccCassandra")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var cassandra = AliCloud.Cassandra.GetClusters.Invoke(new()
     *     {
     *         NameRegex = "tf_testAccCassandra",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cassandra"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cassandra.GetClusters(ctx, &cassandra.GetClustersArgs{
     * 			NameRegex: pulumi.StringRef("tf_testAccCassandra"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cassandra.CassandraFunctions;
     * import com.pulumi.alicloud.cassandra.inputs.GetClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var cassandra = CassandraFunctions.getClusters(GetClustersArgs.builder()
     *             .nameRegex("tf_testAccCassandra")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   cassandra:
     *     fn::invoke:
     *       Function: alicloud:cassandra:getClusters
     *       Arguments:
     *         nameRegex: tf_testAccCassandra
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusters.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: GetClustersPlainArgs): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())

    /**
     * @see [getClusters].
     * @param ids The list of Cassandra cluster ids.
     * @param nameRegex A regex string to apply to the cluster name.
     * @param outputFile The name of file that can save the collection of clusters after running `pulumi preview`.
     * @param tags A mapping of tags to assign to the resource.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        tags: Map<String, String>? = null,
    ): GetClustersResult {
        val argument = GetClustersPlainArgs(
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            tags = tags,
        )
        return getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cassandra&#46;kotlin&#46;inputs&#46;GetClustersPlainArgs].
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: suspend GetClustersPlainArgsBuilder.() -> Unit): GetClustersResult {
        val builder = GetClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClustersResultToKotlin(getClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * The `alicloud.cassandra.getDataCenters` data source provides a collection of Cassandra Data Centers available in Alicloud account.
     * Filters support regular expression for the cluster name or ids.
     * > **NOTE:**  Available in 1.88.0+.
     * > **DEPRECATED:**  This data source has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const cassandra = alicloud.cassandra.getDataCenters({
     *     nameRegex: "tf_testAccCassandra_dc",
     *     clusterId: "cds-xxxxx",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * cassandra = alicloud.cassandra.get_data_centers(name_regex="tf_testAccCassandra_dc",
     *     cluster_id="cds-xxxxx")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var cassandra = AliCloud.Cassandra.GetDataCenters.Invoke(new()
     *     {
     *         NameRegex = "tf_testAccCassandra_dc",
     *         ClusterId = "cds-xxxxx",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cassandra"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cassandra.GetDataCenters(ctx, &cassandra.GetDataCentersArgs{
     * 			NameRegex: pulumi.StringRef("tf_testAccCassandra_dc"),
     * 			ClusterId: "cds-xxxxx",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cassandra.CassandraFunctions;
     * import com.pulumi.alicloud.cassandra.inputs.GetDataCentersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var cassandra = CassandraFunctions.getDataCenters(GetDataCentersArgs.builder()
     *             .nameRegex("tf_testAccCassandra_dc")
     *             .clusterId("cds-xxxxx")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   cassandra:
     *     fn::invoke:
     *       Function: alicloud:cassandra:getDataCenters
     *       Arguments:
     *         nameRegex: tf_testAccCassandra_dc
     *         clusterId: cds-xxxxx
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDataCenters.
     * @return A collection of values returned by getDataCenters.
     */
    public suspend fun getDataCenters(argument: GetDataCentersPlainArgs): GetDataCentersResult =
        getDataCentersResultToKotlin(getDataCentersPlain(argument.toJava()).await())

    /**
     * @see [getDataCenters].
     * @param clusterId The cluster id of dataCenters belongs to.
     * @param ids The list of Cassandra data center ids.
     * @param nameRegex A regex string to apply to the cluster name.
     * @param outputFile The name of file that can save the collection of data centers after running `pulumi preview`.
     * @return A collection of values returned by getDataCenters.
     */
    public suspend fun getDataCenters(
        clusterId: String,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetDataCentersResult {
        val argument = GetDataCentersPlainArgs(
            clusterId = clusterId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getDataCentersResultToKotlin(getDataCentersPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataCenters].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cassandra&#46;kotlin&#46;inputs&#46;GetDataCentersPlainArgs].
     * @return A collection of values returned by getDataCenters.
     */
    public suspend fun getDataCenters(argument: suspend GetDataCentersPlainArgsBuilder.() -> Unit): GetDataCentersResult {
        val builder = GetDataCentersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataCentersResultToKotlin(getDataCentersPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides availability zones for Cassandra that can be accessed by an Alibaba Cloud account within the region configured in the provider.
     * > **NOTE:** Available in v1.88.0+.
     * > **DEPRECATED:**  This data source has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * // Declare the data source
     * const zonesIds = alicloud.cassandra.getZones({});
     * // Create an Cassandra cluster with the first matched zone
     * const cassandra = new alicloud.cassandra.Cluster("cassandra", {zoneId: zonesIds.then(zonesIds => zonesIds.zones?.[0]?.id)});
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * # Declare the data source
     * zones_ids = alicloud.cassandra.get_zones()
     * # Create an Cassandra cluster with the first matched zone
     * cassandra = alicloud.cassandra.Cluster("cassandra", zone_id=zones_ids.zones[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     // Declare the data source
     *     var zonesIds = AliCloud.Cassandra.GetZones.Invoke();
     *     // Create an Cassandra cluster with the first matched zone
     *     var cassandra = new AliCloud.Cassandra.Cluster("cassandra", new()
     *     {
     *         ZoneId = zonesIds.Apply(getZonesResult => getZonesResult.Zones[0]?.Id),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cassandra"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// Declare the data source
     * 		zonesIds, err := cassandra.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Create an Cassandra cluster with the first matched zone
     * 		_, err = cassandra.NewCluster(ctx, "cassandra", &cassandra.ClusterArgs{
     * 			ZoneId: pulumi.String(zonesIds.Zones[0].Id),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cassandra.CassandraFunctions;
     * import com.pulumi.alicloud.cassandra.inputs.GetZonesArgs;
     * import com.pulumi.alicloud.cassandra.Cluster;
     * import com.pulumi.alicloud.cassandra.ClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // Declare the data source
     *         final var zonesIds = CassandraFunctions.getZones();
     *         // Create an Cassandra cluster with the first matched zone
     *         var cassandra = new Cluster("cassandra", ClusterArgs.builder()
     *             .zoneId(zonesIds.applyValue(getZonesResult -> getZonesResult.zones()[0].id()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # Create an Cassandra cluster with the first matched zone
     *   cassandra:
     *     type: alicloud:cassandra:Cluster
     *     properties:
     *       zoneId: ${zonesIds.zones[0].id}
     * variables:
     *   # Declare the data source
     *   zonesIds:
     *     fn::invoke:
     *       Function: alicloud:cassandra:getZones
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param multi Indicate whether the zones can be used in a multi AZ configuration. Default to `false`. Multi AZ is usually used to launch Cassandra clusters.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(multi: Boolean? = null, outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            multi = multi,
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cassandra&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
