@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.alicloud.cassandra.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * Provides a Cassandra cluster resource supports replica set clusters only. The Cassandra provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/product/49055.htm).
 * > **NOTE:**  Available in 1.88.0+.
 * > **NOTE:**  The following regions support create Vpc network Cassandra cluster.
 * The official website mark more regions. Or you can call [DescribeRegions](https://help.aliyun.com/document_detail/157540.html).
 * > **NOTE:**  Create Cassandra cluster or change cluster type and storage would cost 30 minutes. Please make full preparation.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
 * ## Example Usage
 * ### Create a cassandra cluster
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.cassandra.Cluster("default", {
 *     clusterName: "cassandra-cluster-name-tf",
 *     dataCenterName: "dc-1",
 *     autoRenew: false,
 *     instanceType: "cassandra.c.large",
 *     majorVersion: "3.11",
 *     nodeCount: 2,
 *     payType: "PayAsYouGo",
 *     vswitchId: "vsw-xxxx",
 *     diskSize: 160,
 *     diskType: "cloud_ssd",
 *     maintainStartTime: "18:00Z",
 *     maintainEndTime: "20:00Z",
 *     ipWhite: "127.0.0.1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.cassandra.Cluster("default",
 *     cluster_name="cassandra-cluster-name-tf",
 *     data_center_name="dc-1",
 *     auto_renew=False,
 *     instance_type="cassandra.c.large",
 *     major_version="3.11",
 *     node_count=2,
 *     pay_type="PayAsYouGo",
 *     vswitch_id="vsw-xxxx",
 *     disk_size=160,
 *     disk_type="cloud_ssd",
 *     maintain_start_time="18:00Z",
 *     maintain_end_time="20:00Z",
 *     ip_white="127.0.0.1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Cassandra.Cluster("default", new()
 *     {
 *         ClusterName = "cassandra-cluster-name-tf",
 *         DataCenterName = "dc-1",
 *         AutoRenew = false,
 *         InstanceType = "cassandra.c.large",
 *         MajorVersion = "3.11",
 *         NodeCount = 2,
 *         PayType = "PayAsYouGo",
 *         VswitchId = "vsw-xxxx",
 *         DiskSize = 160,
 *         DiskType = "cloud_ssd",
 *         MaintainStartTime = "18:00Z",
 *         MaintainEndTime = "20:00Z",
 *         IpWhite = "127.0.0.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cassandra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cassandra.NewCluster(ctx, "default", &cassandra.ClusterArgs{
 * 			ClusterName:       pulumi.String("cassandra-cluster-name-tf"),
 * 			DataCenterName:    pulumi.String("dc-1"),
 * 			AutoRenew:         pulumi.Bool(false),
 * 			InstanceType:      pulumi.String("cassandra.c.large"),
 * 			MajorVersion:      pulumi.String("3.11"),
 * 			NodeCount:         pulumi.Int(2),
 * 			PayType:           pulumi.String("PayAsYouGo"),
 * 			VswitchId:         pulumi.String("vsw-xxxx"),
 * 			DiskSize:          pulumi.Int(160),
 * 			DiskType:          pulumi.String("cloud_ssd"),
 * 			MaintainStartTime: pulumi.String("18:00Z"),
 * 			MaintainEndTime:   pulumi.String("20:00Z"),
 * 			IpWhite:           pulumi.String("127.0.0.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cassandra.Cluster;
 * import com.pulumi.alicloud.cassandra.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterName("cassandra-cluster-name-tf")
 *             .dataCenterName("dc-1")
 *             .autoRenew("false")
 *             .instanceType("cassandra.c.large")
 *             .majorVersion("3.11")
 *             .nodeCount("2")
 *             .payType("PayAsYouGo")
 *             .vswitchId("vsw-xxxx")
 *             .diskSize("160")
 *             .diskType("cloud_ssd")
 *             .maintainStartTime("18:00Z")
 *             .maintainEndTime("20:00Z")
 *             .ipWhite("127.0.0.1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:cassandra:Cluster
 *     properties:
 *       clusterName: cassandra-cluster-name-tf
 *       dataCenterName: dc-1
 *       autoRenew: 'false'
 *       instanceType: cassandra.c.large
 *       majorVersion: '3.11'
 *       nodeCount: '2'
 *       payType: PayAsYouGo
 *       vswitchId: vsw-xxxx
 *       diskSize: '160'
 *       diskType: cloud_ssd
 *       maintainStartTime: 18:00Z
 *       maintainEndTime: 20:00Z
 *       ipWhite: 127.0.0.1
 * ```
 * <!--End PulumiCodeChooser -->
 * This is a example for class netType cluster. You can find more detail with the examples/cassandra_cluster dir.
 * ## Import
 * Cassandra cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cassandra/cluster:Cluster example cds-wz9sr400dd7xxxxx
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.alicloud.cassandra.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
     */
    public val clusterName: Output<String>?
        get() = javaResource.clusterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
     */
    public val dataCenterName: Output<String>?
        get() = javaResource.dataCenterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
     * - Custom storage space; value range: [160, 2000].
     * - 80-GB increments.
     */
    public val diskSize: Output<Int>?
        get() = javaResource.diskSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
     */
    public val diskType: Output<String>?
        get() = javaResource.diskType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val enablePublic: Output<Boolean>?
        get() = javaResource.enablePublic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Set the instance's IP whitelist in VPC network.
     */
    public val ipWhite: Output<String>
        get() = javaResource.ipWhite().applyValue({ args0 -> args0 })

    /**
     * The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
     */
    public val maintainEndTime: Output<String>?
        get() = javaResource.maintainEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
     */
    public val maintainStartTime: Output<String>?
        get() = javaResource.maintainStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cassandra major version. Now only support version `3.11`.
     */
    public val majorVersion: Output<String>
        get() = javaResource.majorVersion().applyValue({ args0 -> args0 })

    /**
     * The node count of Cassandra dataCenter-1 default to 2.
     */
    public val nodeCount: Output<Int>
        get() = javaResource.nodeCount().applyValue({ args0 -> args0 })

    public val password: Output<String>?
        get() = javaResource.password().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
     */
    public val payType: Output<String>
        get() = javaResource.payType().applyValue({ args0 -> args0 })

    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val publicPoints: Output<List<String>>
        get() = javaResource.publicPoints().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of security group ids to associate with.
     * > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The vswitch_id of dataCenter-1, can not empty.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cassandra.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.alicloud.cassandra.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
