@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin

import com.pulumi.alicloud.cassandra.ClusterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Cassandra cluster resource supports replica set clusters only. The Cassandra provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/product/49055.htm).
 * > **NOTE:**  Available in 1.88.0+.
 * > **NOTE:**  The following regions support create Vpc network Cassandra cluster.
 * The official website mark more regions. Or you can call [DescribeRegions](https://help.aliyun.com/document_detail/157540.html).
 * > **NOTE:**  Create Cassandra cluster or change cluster type and storage would cost 30 minutes. Please make full preparation.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
 * ## Example Usage
 * ### Create a cassandra cluster
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.cassandra.Cluster("default", {
 *     clusterName: "cassandra-cluster-name-tf",
 *     dataCenterName: "dc-1",
 *     autoRenew: false,
 *     instanceType: "cassandra.c.large",
 *     majorVersion: "3.11",
 *     nodeCount: 2,
 *     payType: "PayAsYouGo",
 *     vswitchId: "vsw-xxxx",
 *     diskSize: 160,
 *     diskType: "cloud_ssd",
 *     maintainStartTime: "18:00Z",
 *     maintainEndTime: "20:00Z",
 *     ipWhite: "127.0.0.1",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.cassandra.Cluster("default",
 *     cluster_name="cassandra-cluster-name-tf",
 *     data_center_name="dc-1",
 *     auto_renew=False,
 *     instance_type="cassandra.c.large",
 *     major_version="3.11",
 *     node_count=2,
 *     pay_type="PayAsYouGo",
 *     vswitch_id="vsw-xxxx",
 *     disk_size=160,
 *     disk_type="cloud_ssd",
 *     maintain_start_time="18:00Z",
 *     maintain_end_time="20:00Z",
 *     ip_white="127.0.0.1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Cassandra.Cluster("default", new()
 *     {
 *         ClusterName = "cassandra-cluster-name-tf",
 *         DataCenterName = "dc-1",
 *         AutoRenew = false,
 *         InstanceType = "cassandra.c.large",
 *         MajorVersion = "3.11",
 *         NodeCount = 2,
 *         PayType = "PayAsYouGo",
 *         VswitchId = "vsw-xxxx",
 *         DiskSize = 160,
 *         DiskType = "cloud_ssd",
 *         MaintainStartTime = "18:00Z",
 *         MaintainEndTime = "20:00Z",
 *         IpWhite = "127.0.0.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cassandra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cassandra.NewCluster(ctx, "default", &cassandra.ClusterArgs{
 * 			ClusterName:       pulumi.String("cassandra-cluster-name-tf"),
 * 			DataCenterName:    pulumi.String("dc-1"),
 * 			AutoRenew:         pulumi.Bool(false),
 * 			InstanceType:      pulumi.String("cassandra.c.large"),
 * 			MajorVersion:      pulumi.String("3.11"),
 * 			NodeCount:         pulumi.Int(2),
 * 			PayType:           pulumi.String("PayAsYouGo"),
 * 			VswitchId:         pulumi.String("vsw-xxxx"),
 * 			DiskSize:          pulumi.Int(160),
 * 			DiskType:          pulumi.String("cloud_ssd"),
 * 			MaintainStartTime: pulumi.String("18:00Z"),
 * 			MaintainEndTime:   pulumi.String("20:00Z"),
 * 			IpWhite:           pulumi.String("127.0.0.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cassandra.Cluster;
 * import com.pulumi.alicloud.cassandra.ClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterName("cassandra-cluster-name-tf")
 *             .dataCenterName("dc-1")
 *             .autoRenew("false")
 *             .instanceType("cassandra.c.large")
 *             .majorVersion("3.11")
 *             .nodeCount("2")
 *             .payType("PayAsYouGo")
 *             .vswitchId("vsw-xxxx")
 *             .diskSize("160")
 *             .diskType("cloud_ssd")
 *             .maintainStartTime("18:00Z")
 *             .maintainEndTime("20:00Z")
 *             .ipWhite("127.0.0.1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:cassandra:Cluster
 *     properties:
 *       clusterName: cassandra-cluster-name-tf
 *       dataCenterName: dc-1
 *       autoRenew: 'false'
 *       instanceType: cassandra.c.large
 *       majorVersion: '3.11'
 *       nodeCount: '2'
 *       payType: PayAsYouGo
 *       vswitchId: vsw-xxxx
 *       diskSize: '160'
 *       diskType: cloud_ssd
 *       maintainStartTime: 18:00Z
 *       maintainEndTime: 20:00Z
 *       ipWhite: 127.0.0.1
 * ```
 * <!--End PulumiCodeChooser -->
 * This is a example for class netType cluster. You can find more detail with the examples/cassandra_cluster dir.
 * ## Import
 * Cassandra cluster can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cassandra/cluster:Cluster example cds-wz9sr400dd7xxxxx
 * ```
 * @property autoRenew Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
 * @property autoRenewPeriod Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
 * @property clusterName Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
 * @property dataCenterName Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
 * @property diskSize User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
 * - Custom storage space; value range: [160, 2000].
 * - 80-GB increments.
 * @property diskType The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
 * @property enablePublic
 * @property instanceType Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
 * @property ipWhite Set the instance's IP whitelist in VPC network.
 * @property maintainEndTime The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
 * @property maintainStartTime The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
 * @property majorVersion Cassandra major version. Now only support version `3.11`.
 * @property nodeCount The node count of Cassandra dataCenter-1 default to 2.
 * @property password
 * @property payType The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
 * @property period
 * @property periodUnit
 * @property securityGroups A list of security group ids to associate with.
 * > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
 * @property tags A mapping of tags to assign to the resource.
 * @property vswitchId The vswitch_id of dataCenter-1, can not empty.
 * @property zoneId The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
 */
public data class ClusterArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val clusterName: Output<String>? = null,
    public val dataCenterName: Output<String>? = null,
    public val diskSize: Output<Int>? = null,
    public val diskType: Output<String>? = null,
    public val enablePublic: Output<Boolean>? = null,
    public val instanceType: Output<String>? = null,
    public val ipWhite: Output<String>? = null,
    public val maintainEndTime: Output<String>? = null,
    public val maintainStartTime: Output<String>? = null,
    public val majorVersion: Output<String>? = null,
    public val nodeCount: Output<Int>? = null,
    public val password: Output<String>? = null,
    public val payType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cassandra.ClusterArgs> {
    override fun toJava(): com.pulumi.alicloud.cassandra.ClusterArgs =
        com.pulumi.alicloud.cassandra.ClusterArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .dataCenterName(dataCenterName?.applyValue({ args0 -> args0 }))
            .diskSize(diskSize?.applyValue({ args0 -> args0 }))
            .diskType(diskType?.applyValue({ args0 -> args0 }))
            .enablePublic(enablePublic?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .ipWhite(ipWhite?.applyValue({ args0 -> args0 }))
            .maintainEndTime(maintainEndTime?.applyValue({ args0 -> args0 }))
            .maintainStartTime(maintainStartTime?.applyValue({ args0 -> args0 }))
            .majorVersion(majorVersion?.applyValue({ args0 -> args0 }))
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .payType(payType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterArgs].
 */
@PulumiTagMarker
public class ClusterArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var clusterName: Output<String>? = null

    private var dataCenterName: Output<String>? = null

    private var diskSize: Output<Int>? = null

    private var diskType: Output<String>? = null

    private var enablePublic: Output<Boolean>? = null

    private var instanceType: Output<String>? = null

    private var ipWhite: Output<String>? = null

    private var maintainEndTime: Output<String>? = null

    private var maintainStartTime: Output<String>? = null

    private var majorVersion: Output<String>? = null

    private var nodeCount: Output<Int>? = null

    private var password: Output<String>? = null

    private var payType: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var securityGroups: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
     */
    @JvmName("dqgdjwirixnukxka")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
     */
    @JvmName("onyxtjmdwvngfaaj")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
     */
    @JvmName("xubyddrawgssnvxm")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
     */
    @JvmName("omlalguhhujlcfts")
    public suspend fun dataCenterName(`value`: Output<String>) {
        this.dataCenterName = value
    }

    /**
     * @param value User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
     * - Custom storage space; value range: [160, 2000].
     * - 80-GB increments.
     */
    @JvmName("nrvutodegahxyusd")
    public suspend fun diskSize(`value`: Output<Int>) {
        this.diskSize = value
    }

    /**
     * @param value The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
     */
    @JvmName("roqtuubgwmbwnfei")
    public suspend fun diskType(`value`: Output<String>) {
        this.diskType = value
    }

    /**
     * @param value
     */
    @JvmName("hkrpakdrrgulcspw")
    public suspend fun enablePublic(`value`: Output<Boolean>) {
        this.enablePublic = value
    }

    /**
     * @param value Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
     */
    @JvmName("wqixqkjkhdvgvvaj")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Set the instance's IP whitelist in VPC network.
     */
    @JvmName("ggaopxvqymylliyl")
    public suspend fun ipWhite(`value`: Output<String>) {
        this.ipWhite = value
    }

    /**
     * @param value The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
     */
    @JvmName("udujabnnkfyeeccb")
    public suspend fun maintainEndTime(`value`: Output<String>) {
        this.maintainEndTime = value
    }

    /**
     * @param value The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
     */
    @JvmName("vtycmcmfsvuvfcwp")
    public suspend fun maintainStartTime(`value`: Output<String>) {
        this.maintainStartTime = value
    }

    /**
     * @param value Cassandra major version. Now only support version `3.11`.
     */
    @JvmName("xjfmxpdoeypbtjns")
    public suspend fun majorVersion(`value`: Output<String>) {
        this.majorVersion = value
    }

    /**
     * @param value The node count of Cassandra dataCenter-1 default to 2.
     */
    @JvmName("orgrsxuwadosrpsc")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value
     */
    @JvmName("sdabqpexpqmbnkut")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
     */
    @JvmName("rubkhvalcxytsdfm")
    public suspend fun payType(`value`: Output<String>) {
        this.payType = value
    }

    /**
     * @param value
     */
    @JvmName("eyapfoewahjtmeme")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value
     */
    @JvmName("qyvmvrdwjjbxtfux")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value A list of security group ids to associate with.
     * > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
     */
    @JvmName("ssueyihmlugydypm")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("kihtxutuaptylaaq")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group ids to associate with.
     * > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
     */
    @JvmName("yyoevfbpvpcvhvon")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("hesmchkadbnfjtdc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The vswitch_id of dataCenter-1, can not empty.
     */
    @JvmName("vejihvqwwogsrqod")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
     */
    @JvmName("utldcvrxfvfyrvnx")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Auto renew of dataCenter-1,`true` or `false`. System default to `false`, valid when pay_type = PrePaid.
     */
    @JvmName("maydejgkmfxguqcm")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Period of dataCenter-1 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
     */
    @JvmName("nqdjsrakwbcpvctf")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value Cassandra cluster name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
     */
    @JvmName("jfbxhhvkcuiwfrmr")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Cassandra dataCenter-1 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
     */
    @JvmName("oailvrrmqffvahmn")
    public suspend fun dataCenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCenterName = mapped
    }

    /**
     * @param value User-defined Cassandra dataCenter-1 one node's storage space.Unit: GB. Value range:
     * - Custom storage space; value range: [160, 2000].
     * - 80-GB increments.
     */
    @JvmName("mtiqeevwqifoeauu")
    public suspend fun diskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSize = mapped
    }

    /**
     * @param value The disk type of Cassandra dataCenter-1. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
     */
    @JvmName("sfakmlndmuwmduww")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value
     */
    @JvmName("qkgncrupepleaooj")
    public suspend fun enablePublic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePublic = mapped
    }

    /**
     * @param value Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
     */
    @JvmName("eqdkvkgfkwqovroa")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Set the instance's IP whitelist in VPC network.
     */
    @JvmName("vvhusavkebempkcu")
    public suspend fun ipWhite(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipWhite = mapped
    }

    /**
     * @param value The end time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
     */
    @JvmName("vryssjfsximqtufl")
    public suspend fun maintainEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainEndTime = mapped
    }

    /**
     * @param value The start time of the operation and maintenance time period of the cluster, in the format of HH:mmZ (UTC time).
     */
    @JvmName("wdktqoldwywesuwe")
    public suspend fun maintainStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintainStartTime = mapped
    }

    /**
     * @param value Cassandra major version. Now only support version `3.11`.
     */
    @JvmName("eqxhoywulovfdoty")
    public suspend fun majorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.majorVersion = mapped
    }

    /**
     * @param value The node count of Cassandra dataCenter-1 default to 2.
     */
    @JvmName("ctcmikphbndusnfe")
    public suspend fun nodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value
     */
    @JvmName("kfwstsbwlvtflekk")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The pay type of Cassandra dataCenter-1. Valid values are `Subscription`, `PayAsYouGo`,System default to `PayAsYouGo`.
     */
    @JvmName("kgrlpndarlsrvlpc")
    public suspend fun payType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payType = mapped
    }

    /**
     * @param value
     */
    @JvmName("imfoqveyfqvmxrwk")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value
     */
    @JvmName("ccjpjgmbvyjjsoht")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value A list of security group ids to associate with.
     * > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
     */
    @JvmName("xmnlyiuqddiaveqd")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group ids to associate with.
     * > **NOTE:** Now cluster_name,data_center_name,instance_type,node_count,disk_type,disk_size,maintain_start_time,maintain_end_time,tags,ip_white,security_groups can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
     */
    @JvmName("aivrolohhfcksknd")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("vapbgpvpfqbaiehj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("gxbdygjvmxjcchym")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The vswitch_id of dataCenter-1, can not empty.
     */
    @JvmName("pxihydvpwmywnqha")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone to launch the Cassandra cluster. If vswitch_id is not empty, this zone_id can be "" or consistent.
     */
    @JvmName("labtfonfqfhiicwi")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): ClusterArgs = ClusterArgs(
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        clusterName = clusterName,
        dataCenterName = dataCenterName,
        diskSize = diskSize,
        diskType = diskType,
        enablePublic = enablePublic,
        instanceType = instanceType,
        ipWhite = ipWhite,
        maintainEndTime = maintainEndTime,
        maintainStartTime = maintainStartTime,
        majorVersion = majorVersion,
        nodeCount = nodeCount,
        password = password,
        payType = payType,
        period = period,
        periodUnit = periodUnit,
        securityGroups = securityGroups,
        tags = tags,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
