@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DataCenter].
 */
@PulumiTagMarker
public class DataCenterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataCenterArgs = DataCenterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataCenterArgsBuilder.() -> Unit) {
        val builder = DataCenterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataCenter {
        val builtJavaResource = com.pulumi.alicloud.cassandra.DataCenter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataCenter(builtJavaResource)
    }
}

/**
 * Provides a Cassandra dataCenter resource supports replica set dataCenters only. The Cassandra provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/product/49055.htm).
 * > **NOTE:**  Available in 1.88.0+.
 * > **NOTE:**  Create a cassandra dataCenter need a clusterId,so need create a cassandra cluster first.
 * > **NOTE:**  The following regions support create Vpc network Cassandra cluster.
 * The official website mark  more regions. Or you can call [DescribeRegions](https://help.aliyun.com/document_detail/157540.html).
 * > **NOTE:**  Create Cassandra dataCenter or change dataCenter type and storage would cost 30 minutes. Please make full preparation.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
 * ## Example Usage
 * ### Create a cassandra dataCenter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.cassandra.Cluster("default", {
 *     clusterName: "cassandra-cluster-name-tf",
 *     dataCenterName: "dc-1",
 *     autoRenew: false,
 *     instanceType: "cassandra.c.large",
 *     majorVersion: "3.11",
 *     nodeCount: 2,
 *     payType: "PayAsYouGo",
 *     vswitchId: "vsw-xxxx1",
 *     diskSize: 160,
 *     diskType: "cloud_ssd",
 *     maintainStartTime: "18:00Z",
 *     maintainEndTime: "20:00Z",
 *     ipWhite: "127.0.0.1",
 * });
 * const defaultDataCenter = new alicloud.cassandra.DataCenter("default", {
 *     clusterId: _default.id,
 *     dataCenterName: "dc-2",
 *     autoRenew: false,
 *     instanceType: "cassandra.c.large",
 *     nodeCount: 2,
 *     payType: "PayAsYouGo",
 *     vswitchId: "vsw-xxxx2",
 *     diskSize: 160,
 *     diskType: "cloud_ssd",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.cassandra.Cluster("default",
 *     cluster_name="cassandra-cluster-name-tf",
 *     data_center_name="dc-1",
 *     auto_renew=False,
 *     instance_type="cassandra.c.large",
 *     major_version="3.11",
 *     node_count=2,
 *     pay_type="PayAsYouGo",
 *     vswitch_id="vsw-xxxx1",
 *     disk_size=160,
 *     disk_type="cloud_ssd",
 *     maintain_start_time="18:00Z",
 *     maintain_end_time="20:00Z",
 *     ip_white="127.0.0.1")
 * default_data_center = alicloud.cassandra.DataCenter("default",
 *     cluster_id=default.id,
 *     data_center_name="dc-2",
 *     auto_renew=False,
 *     instance_type="cassandra.c.large",
 *     node_count=2,
 *     pay_type="PayAsYouGo",
 *     vswitch_id="vsw-xxxx2",
 *     disk_size=160,
 *     disk_type="cloud_ssd")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Cassandra.Cluster("default", new()
 *     {
 *         ClusterName = "cassandra-cluster-name-tf",
 *         DataCenterName = "dc-1",
 *         AutoRenew = false,
 *         InstanceType = "cassandra.c.large",
 *         MajorVersion = "3.11",
 *         NodeCount = 2,
 *         PayType = "PayAsYouGo",
 *         VswitchId = "vsw-xxxx1",
 *         DiskSize = 160,
 *         DiskType = "cloud_ssd",
 *         MaintainStartTime = "18:00Z",
 *         MaintainEndTime = "20:00Z",
 *         IpWhite = "127.0.0.1",
 *     });
 *     var defaultDataCenter = new AliCloud.Cassandra.DataCenter("default", new()
 *     {
 *         ClusterId = @default.Id,
 *         DataCenterName = "dc-2",
 *         AutoRenew = false,
 *         InstanceType = "cassandra.c.large",
 *         NodeCount = 2,
 *         PayType = "PayAsYouGo",
 *         VswitchId = "vsw-xxxx2",
 *         DiskSize = 160,
 *         DiskType = "cloud_ssd",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cassandra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cassandra.NewCluster(ctx, "default", &cassandra.ClusterArgs{
 * 			ClusterName:       pulumi.String("cassandra-cluster-name-tf"),
 * 			DataCenterName:    pulumi.String("dc-1"),
 * 			AutoRenew:         pulumi.Bool(false),
 * 			InstanceType:      pulumi.String("cassandra.c.large"),
 * 			MajorVersion:      pulumi.String("3.11"),
 * 			NodeCount:         pulumi.Int(2),
 * 			PayType:           pulumi.String("PayAsYouGo"),
 * 			VswitchId:         pulumi.String("vsw-xxxx1"),
 * 			DiskSize:          pulumi.Int(160),
 * 			DiskType:          pulumi.String("cloud_ssd"),
 * 			MaintainStartTime: pulumi.String("18:00Z"),
 * 			MaintainEndTime:   pulumi.String("20:00Z"),
 * 			IpWhite:           pulumi.String("127.0.0.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cassandra.NewDataCenter(ctx, "default", &cassandra.DataCenterArgs{
 * 			ClusterId:      _default.ID(),
 * 			DataCenterName: pulumi.String("dc-2"),
 * 			AutoRenew:      pulumi.Bool(false),
 * 			InstanceType:   pulumi.String("cassandra.c.large"),
 * 			NodeCount:      pulumi.Int(2),
 * 			PayType:        pulumi.String("PayAsYouGo"),
 * 			VswitchId:      pulumi.String("vsw-xxxx2"),
 * 			DiskSize:       pulumi.Int(160),
 * 			DiskType:       pulumi.String("cloud_ssd"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cassandra.Cluster;
 * import com.pulumi.alicloud.cassandra.ClusterArgs;
 * import com.pulumi.alicloud.cassandra.DataCenter;
 * import com.pulumi.alicloud.cassandra.DataCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterName("cassandra-cluster-name-tf")
 *             .dataCenterName("dc-1")
 *             .autoRenew("false")
 *             .instanceType("cassandra.c.large")
 *             .majorVersion("3.11")
 *             .nodeCount("2")
 *             .payType("PayAsYouGo")
 *             .vswitchId("vsw-xxxx1")
 *             .diskSize("160")
 *             .diskType("cloud_ssd")
 *             .maintainStartTime("18:00Z")
 *             .maintainEndTime("20:00Z")
 *             .ipWhite("127.0.0.1")
 *             .build());
 *         var defaultDataCenter = new DataCenter("defaultDataCenter", DataCenterArgs.builder()
 *             .clusterId(default_.id())
 *             .dataCenterName("dc-2")
 *             .autoRenew("false")
 *             .instanceType("cassandra.c.large")
 *             .nodeCount("2")
 *             .payType("PayAsYouGo")
 *             .vswitchId("vsw-xxxx2")
 *             .diskSize("160")
 *             .diskType("cloud_ssd")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:cassandra:Cluster
 *     properties:
 *       clusterName: cassandra-cluster-name-tf
 *       dataCenterName: dc-1
 *       autoRenew: 'false'
 *       instanceType: cassandra.c.large
 *       majorVersion: '3.11'
 *       nodeCount: '2'
 *       payType: PayAsYouGo
 *       vswitchId: vsw-xxxx1
 *       diskSize: '160'
 *       diskType: cloud_ssd
 *       maintainStartTime: 18:00Z
 *       maintainEndTime: 20:00Z
 *       ipWhite: 127.0.0.1
 *   defaultDataCenter:
 *     type: alicloud:cassandra:DataCenter
 *     name: default
 *     properties:
 *       clusterId: ${default.id}
 *       dataCenterName: dc-2
 *       autoRenew: 'false'
 *       instanceType: cassandra.c.large
 *       nodeCount: '2'
 *       payType: PayAsYouGo
 *       vswitchId: vsw-xxxx2
 *       diskSize: '160'
 *       diskType: cloud_ssd
 * ```
 * <!--End PulumiCodeChooser -->
 * This is a example for class netType dataCenter. You can find more detail with the examples/cassandra_data_center dir.
 * ## Import
 * If you need full function, please import Cassandra cluster first.
 * Cassandra dataCenter can be imported using the dcId:clusterId, e.g.
 * ```sh
 * $ pulumi import alicloud:cassandra/dataCenter:DataCenter dc_2 cn-shenxxxx-x:cds-wz933ryoaurxxxxx
 * ```
 */
public class DataCenter internal constructor(
    override val javaResource: com.pulumi.alicloud.cassandra.DataCenter,
) : KotlinCustomResource(javaResource, DataCenterMapper) {
    /**
     * Auto renew of dataCenter-2,`true` or `false`. System default to `false`, valid when pay_type = Subscription.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Period of dataCenter-2 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
     */
    public val autoRenewPeriod: Output<Int>?
        get() = javaResource.autoRenewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Cassandra cluster id of dataCenter-2 belongs to.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    public val dataCenterId: Output<String>
        get() = javaResource.dataCenterId().applyValue({ args0 -> args0 })

    /**
     * Cassandra dataCenter-2 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
     */
    public val dataCenterName: Output<String>?
        get() = javaResource.dataCenterName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User-defined Cassandra dataCenter one core node's storage space.Unit: GB. Value range:
     * - Custom storage space; value range: [160, 2000].
     * - 80-GB increments.
     */
    public val diskSize: Output<Int>?
        get() = javaResource.diskSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The disk type of Cassandra dataCenter-2. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
     */
    public val diskType: Output<String>?
        get() = javaResource.diskType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val enablePublic: Output<Boolean>?
        get() = javaResource.enablePublic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * The node count of Cassandra dataCenter-2, default to 2.
     */
    public val nodeCount: Output<Int>
        get() = javaResource.nodeCount().applyValue({ args0 -> args0 })

    /**
     * The pay type of Cassandra dataCenter-2. Valid values are `Subscription`, `PayAsYouGo`. System default to `PayAsYouGo`.
     */
    public val payType: Output<String>
        get() = javaResource.payType().applyValue({ args0 -> args0 })

    public val period: Output<Int>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val periodUnit: Output<String>?
        get() = javaResource.periodUnit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val publicPoints: Output<List<String>>
        get() = javaResource.publicPoints().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The vswitch_id of dataCenter-2, mast different of vswitch_id(dc-1), can not empty.
     * > **NOTE:** Now data_center_name,instance_type,node_count,disk_type,disk_size can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The Zone to launch the Cassandra dataCenter-2. If vswitch_id is not empty, this zone_id can be "" or consistent.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DataCenterMapper : ResourceMapper<DataCenter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cassandra.DataCenter::class == javaResource::class

    override fun map(javaResource: Resource): DataCenter = DataCenter(
        javaResource as
            com.pulumi.alicloud.cassandra.DataCenter,
    )
}

/**
 * @see [DataCenter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataCenter].
 */
public suspend fun dataCenter(name: String, block: suspend DataCenterResourceBuilder.() -> Unit): DataCenter {
    val builder = DataCenterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataCenter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataCenter(name: String): DataCenter {
    val builder = DataCenterResourceBuilder()
    builder.name(name)
    return builder.build()
}
