@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin

import com.pulumi.alicloud.cassandra.DataCenterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Cassandra dataCenter resource supports replica set dataCenters only. The Cassandra provides stable, reliable, and automatic scalable database services.
 * It offers a full range of database solutions, such as disaster recovery, backup, recovery, monitoring, and alarms.
 * You can see detail product introduction [here](https://www.alibabacloud.com/help/product/49055.htm).
 * > **NOTE:**  Available in 1.88.0+.
 * > **NOTE:**  Create a cassandra dataCenter need a clusterId,so need create a cassandra cluster first.
 * > **NOTE:**  The following regions support create Vpc network Cassandra cluster.
 * The official website mark  more regions. Or you can call [DescribeRegions](https://help.aliyun.com/document_detail/157540.html).
 * > **NOTE:**  Create Cassandra dataCenter or change dataCenter type and storage would cost 30 minutes. Please make full preparation.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-cassandra/latest/cassandra-delisting-notice) from version `1.220.0`.
 * ## Example Usage
 * ### Create a cassandra dataCenter
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _default = new alicloud.cassandra.Cluster("default", {
 *     clusterName: "cassandra-cluster-name-tf",
 *     dataCenterName: "dc-1",
 *     autoRenew: false,
 *     instanceType: "cassandra.c.large",
 *     majorVersion: "3.11",
 *     nodeCount: 2,
 *     payType: "PayAsYouGo",
 *     vswitchId: "vsw-xxxx1",
 *     diskSize: 160,
 *     diskType: "cloud_ssd",
 *     maintainStartTime: "18:00Z",
 *     maintainEndTime: "20:00Z",
 *     ipWhite: "127.0.0.1",
 * });
 * const defaultDataCenter = new alicloud.cassandra.DataCenter("default", {
 *     clusterId: _default.id,
 *     dataCenterName: "dc-2",
 *     autoRenew: false,
 *     instanceType: "cassandra.c.large",
 *     nodeCount: 2,
 *     payType: "PayAsYouGo",
 *     vswitchId: "vsw-xxxx2",
 *     diskSize: 160,
 *     diskType: "cloud_ssd",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.cassandra.Cluster("default",
 *     cluster_name="cassandra-cluster-name-tf",
 *     data_center_name="dc-1",
 *     auto_renew=False,
 *     instance_type="cassandra.c.large",
 *     major_version="3.11",
 *     node_count=2,
 *     pay_type="PayAsYouGo",
 *     vswitch_id="vsw-xxxx1",
 *     disk_size=160,
 *     disk_type="cloud_ssd",
 *     maintain_start_time="18:00Z",
 *     maintain_end_time="20:00Z",
 *     ip_white="127.0.0.1")
 * default_data_center = alicloud.cassandra.DataCenter("default",
 *     cluster_id=default.id,
 *     data_center_name="dc-2",
 *     auto_renew=False,
 *     instance_type="cassandra.c.large",
 *     node_count=2,
 *     pay_type="PayAsYouGo",
 *     vswitch_id="vsw-xxxx2",
 *     disk_size=160,
 *     disk_type="cloud_ssd")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new AliCloud.Cassandra.Cluster("default", new()
 *     {
 *         ClusterName = "cassandra-cluster-name-tf",
 *         DataCenterName = "dc-1",
 *         AutoRenew = false,
 *         InstanceType = "cassandra.c.large",
 *         MajorVersion = "3.11",
 *         NodeCount = 2,
 *         PayType = "PayAsYouGo",
 *         VswitchId = "vsw-xxxx1",
 *         DiskSize = 160,
 *         DiskType = "cloud_ssd",
 *         MaintainStartTime = "18:00Z",
 *         MaintainEndTime = "20:00Z",
 *         IpWhite = "127.0.0.1",
 *     });
 *     var defaultDataCenter = new AliCloud.Cassandra.DataCenter("default", new()
 *     {
 *         ClusterId = @default.Id,
 *         DataCenterName = "dc-2",
 *         AutoRenew = false,
 *         InstanceType = "cassandra.c.large",
 *         NodeCount = 2,
 *         PayType = "PayAsYouGo",
 *         VswitchId = "vsw-xxxx2",
 *         DiskSize = 160,
 *         DiskType = "cloud_ssd",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cassandra"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cassandra.NewCluster(ctx, "default", &cassandra.ClusterArgs{
 * 			ClusterName:       pulumi.String("cassandra-cluster-name-tf"),
 * 			DataCenterName:    pulumi.String("dc-1"),
 * 			AutoRenew:         pulumi.Bool(false),
 * 			InstanceType:      pulumi.String("cassandra.c.large"),
 * 			MajorVersion:      pulumi.String("3.11"),
 * 			NodeCount:         pulumi.Int(2),
 * 			PayType:           pulumi.String("PayAsYouGo"),
 * 			VswitchId:         pulumi.String("vsw-xxxx1"),
 * 			DiskSize:          pulumi.Int(160),
 * 			DiskType:          pulumi.String("cloud_ssd"),
 * 			MaintainStartTime: pulumi.String("18:00Z"),
 * 			MaintainEndTime:   pulumi.String("20:00Z"),
 * 			IpWhite:           pulumi.String("127.0.0.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cassandra.NewDataCenter(ctx, "default", &cassandra.DataCenterArgs{
 * 			ClusterId:      _default.ID(),
 * 			DataCenterName: pulumi.String("dc-2"),
 * 			AutoRenew:      pulumi.Bool(false),
 * 			InstanceType:   pulumi.String("cassandra.c.large"),
 * 			NodeCount:      pulumi.Int(2),
 * 			PayType:        pulumi.String("PayAsYouGo"),
 * 			VswitchId:      pulumi.String("vsw-xxxx2"),
 * 			DiskSize:       pulumi.Int(160),
 * 			DiskType:       pulumi.String("cloud_ssd"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.cassandra.Cluster;
 * import com.pulumi.alicloud.cassandra.ClusterArgs;
 * import com.pulumi.alicloud.cassandra.DataCenter;
 * import com.pulumi.alicloud.cassandra.DataCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterName("cassandra-cluster-name-tf")
 *             .dataCenterName("dc-1")
 *             .autoRenew("false")
 *             .instanceType("cassandra.c.large")
 *             .majorVersion("3.11")
 *             .nodeCount("2")
 *             .payType("PayAsYouGo")
 *             .vswitchId("vsw-xxxx1")
 *             .diskSize("160")
 *             .diskType("cloud_ssd")
 *             .maintainStartTime("18:00Z")
 *             .maintainEndTime("20:00Z")
 *             .ipWhite("127.0.0.1")
 *             .build());
 *         var defaultDataCenter = new DataCenter("defaultDataCenter", DataCenterArgs.builder()
 *             .clusterId(default_.id())
 *             .dataCenterName("dc-2")
 *             .autoRenew("false")
 *             .instanceType("cassandra.c.large")
 *             .nodeCount("2")
 *             .payType("PayAsYouGo")
 *             .vswitchId("vsw-xxxx2")
 *             .diskSize("160")
 *             .diskType("cloud_ssd")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: alicloud:cassandra:Cluster
 *     properties:
 *       clusterName: cassandra-cluster-name-tf
 *       dataCenterName: dc-1
 *       autoRenew: 'false'
 *       instanceType: cassandra.c.large
 *       majorVersion: '3.11'
 *       nodeCount: '2'
 *       payType: PayAsYouGo
 *       vswitchId: vsw-xxxx1
 *       diskSize: '160'
 *       diskType: cloud_ssd
 *       maintainStartTime: 18:00Z
 *       maintainEndTime: 20:00Z
 *       ipWhite: 127.0.0.1
 *   defaultDataCenter:
 *     type: alicloud:cassandra:DataCenter
 *     name: default
 *     properties:
 *       clusterId: ${default.id}
 *       dataCenterName: dc-2
 *       autoRenew: 'false'
 *       instanceType: cassandra.c.large
 *       nodeCount: '2'
 *       payType: PayAsYouGo
 *       vswitchId: vsw-xxxx2
 *       diskSize: '160'
 *       diskType: cloud_ssd
 * ```
 * <!--End PulumiCodeChooser -->
 * This is a example for class netType dataCenter. You can find more detail with the examples/cassandra_data_center dir.
 * ## Import
 * If you need full function, please import Cassandra cluster first.
 * Cassandra dataCenter can be imported using the dcId:clusterId, e.g.
 * ```sh
 * $ pulumi import alicloud:cassandra/dataCenter:DataCenter dc_2 cn-shenxxxx-x:cds-wz933ryoaurxxxxx
 * ```
 * @property autoRenew Auto renew of dataCenter-2,`true` or `false`. System default to `false`, valid when pay_type = Subscription.
 * @property autoRenewPeriod Period of dataCenter-2 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
 * @property clusterId Cassandra cluster id of dataCenter-2 belongs to.
 * @property dataCenterName Cassandra dataCenter-2 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
 * @property diskSize User-defined Cassandra dataCenter one core node's storage space.Unit: GB. Value range:
 * - Custom storage space; value range: [160, 2000].
 * - 80-GB increments.
 * @property diskType The disk type of Cassandra dataCenter-2. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
 * @property enablePublic
 * @property instanceType Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
 * @property nodeCount The node count of Cassandra dataCenter-2, default to 2.
 * @property payType The pay type of Cassandra dataCenter-2. Valid values are `Subscription`, `PayAsYouGo`. System default to `PayAsYouGo`.
 * @property period
 * @property periodUnit
 * @property vswitchId The vswitch_id of dataCenter-2, mast different of vswitch_id(dc-1), can not empty.
 * > **NOTE:** Now data_center_name,instance_type,node_count,disk_type,disk_size can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
 * @property zoneId The Zone to launch the Cassandra dataCenter-2. If vswitch_id is not empty, this zone_id can be "" or consistent.
 */
public data class DataCenterArgs(
    public val autoRenew: Output<Boolean>? = null,
    public val autoRenewPeriod: Output<Int>? = null,
    public val clusterId: Output<String>? = null,
    public val dataCenterName: Output<String>? = null,
    public val diskSize: Output<Int>? = null,
    public val diskType: Output<String>? = null,
    public val enablePublic: Output<Boolean>? = null,
    public val instanceType: Output<String>? = null,
    public val nodeCount: Output<Int>? = null,
    public val payType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val periodUnit: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cassandra.DataCenterArgs> {
    override fun toJava(): com.pulumi.alicloud.cassandra.DataCenterArgs =
        com.pulumi.alicloud.cassandra.DataCenterArgs.builder()
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .autoRenewPeriod(autoRenewPeriod?.applyValue({ args0 -> args0 }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .dataCenterName(dataCenterName?.applyValue({ args0 -> args0 }))
            .diskSize(diskSize?.applyValue({ args0 -> args0 }))
            .diskType(diskType?.applyValue({ args0 -> args0 }))
            .enablePublic(enablePublic?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .nodeCount(nodeCount?.applyValue({ args0 -> args0 }))
            .payType(payType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodUnit(periodUnit?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataCenterArgs].
 */
@PulumiTagMarker
public class DataCenterArgsBuilder internal constructor() {
    private var autoRenew: Output<Boolean>? = null

    private var autoRenewPeriod: Output<Int>? = null

    private var clusterId: Output<String>? = null

    private var dataCenterName: Output<String>? = null

    private var diskSize: Output<Int>? = null

    private var diskType: Output<String>? = null

    private var enablePublic: Output<Boolean>? = null

    private var instanceType: Output<String>? = null

    private var nodeCount: Output<Int>? = null

    private var payType: Output<String>? = null

    private var period: Output<Int>? = null

    private var periodUnit: Output<String>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Auto renew of dataCenter-2,`true` or `false`. System default to `false`, valid when pay_type = Subscription.
     */
    @JvmName("wxkiltjhpdswmtjk")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value Period of dataCenter-2 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
     */
    @JvmName("pexokhhgcwjtxubx")
    public suspend fun autoRenewPeriod(`value`: Output<Int>) {
        this.autoRenewPeriod = value
    }

    /**
     * @param value Cassandra cluster id of dataCenter-2 belongs to.
     */
    @JvmName("oehqvubwdrxuepxd")
    public suspend fun clusterId(`value`: Output<String>) {
        this.clusterId = value
    }

    /**
     * @param value Cassandra dataCenter-2 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
     */
    @JvmName("lipyiqwafvnhtuph")
    public suspend fun dataCenterName(`value`: Output<String>) {
        this.dataCenterName = value
    }

    /**
     * @param value User-defined Cassandra dataCenter one core node's storage space.Unit: GB. Value range:
     * - Custom storage space; value range: [160, 2000].
     * - 80-GB increments.
     */
    @JvmName("cjpqthyleqbxnnok")
    public suspend fun diskSize(`value`: Output<Int>) {
        this.diskSize = value
    }

    /**
     * @param value The disk type of Cassandra dataCenter-2. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
     */
    @JvmName("jvdkjiikjtppetfl")
    public suspend fun diskType(`value`: Output<String>) {
        this.diskType = value
    }

    /**
     * @param value
     */
    @JvmName("bmsdwbangouspgjg")
    public suspend fun enablePublic(`value`: Output<Boolean>) {
        this.enablePublic = value
    }

    /**
     * @param value Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
     */
    @JvmName("kbwomhfyrycfqsfw")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The node count of Cassandra dataCenter-2, default to 2.
     */
    @JvmName("igxnkqjfjsdytaxh")
    public suspend fun nodeCount(`value`: Output<Int>) {
        this.nodeCount = value
    }

    /**
     * @param value The pay type of Cassandra dataCenter-2. Valid values are `Subscription`, `PayAsYouGo`. System default to `PayAsYouGo`.
     */
    @JvmName("rgtidypqefufrgod")
    public suspend fun payType(`value`: Output<String>) {
        this.payType = value
    }

    /**
     * @param value
     */
    @JvmName("gymmvthogwklmsvn")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value
     */
    @JvmName("khumakoorxtemprh")
    public suspend fun periodUnit(`value`: Output<String>) {
        this.periodUnit = value
    }

    /**
     * @param value The vswitch_id of dataCenter-2, mast different of vswitch_id(dc-1), can not empty.
     * > **NOTE:** Now data_center_name,instance_type,node_count,disk_type,disk_size can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
     */
    @JvmName("ebillmmchflshdxh")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The Zone to launch the Cassandra dataCenter-2. If vswitch_id is not empty, this zone_id can be "" or consistent.
     */
    @JvmName("kttihculhgcyvkwt")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Auto renew of dataCenter-2,`true` or `false`. System default to `false`, valid when pay_type = Subscription.
     */
    @JvmName("krasranmqhnusjvc")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value Period of dataCenter-2 auto renew, if auto renew is `true`, one of `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36, 60`, valid when pay_type = Subscription. Unit: month.
     */
    @JvmName("orrujvhqaarapkfu")
    public suspend fun autoRenewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenewPeriod = mapped
    }

    /**
     * @param value Cassandra cluster id of dataCenter-2 belongs to.
     */
    @JvmName("qhwsyqlfgyofbukj")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value Cassandra dataCenter-2 name. Length must be 2~128 characters long. Only Chinese characters, English letters, numbers, period `.`, underline `_`, or dash `-` are permitted.
     */
    @JvmName("bauhwqadfyuocjwi")
    public suspend fun dataCenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCenterName = mapped
    }

    /**
     * @param value User-defined Cassandra dataCenter one core node's storage space.Unit: GB. Value range:
     * - Custom storage space; value range: [160, 2000].
     * - 80-GB increments.
     */
    @JvmName("emgfpavgfvrsolwq")
    public suspend fun diskSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSize = mapped
    }

    /**
     * @param value The disk type of Cassandra dataCenter-2. Valid values are `cloud_ssd`, `cloud_efficiency`, `local_hdd_pro`, `local_ssd_pro`, local_disk size is fixed.
     */
    @JvmName("ytdccojtrgbryhjv")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value
     */
    @JvmName("pmkuejigwfaxiimc")
    public suspend fun enablePublic(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePublic = mapped
    }

    /**
     * @param value Instance specification. See [Instance specifications](https://help.aliyun.com/document_detail/157445.html). Or you can call describeInstanceType api.
     */
    @JvmName("ftjqllkmjxihvdxh")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The node count of Cassandra dataCenter-2, default to 2.
     */
    @JvmName("ivvbpdjfcrqhhmhy")
    public suspend fun nodeCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeCount = mapped
    }

    /**
     * @param value The pay type of Cassandra dataCenter-2. Valid values are `Subscription`, `PayAsYouGo`. System default to `PayAsYouGo`.
     */
    @JvmName("wcnxhibnikveqswd")
    public suspend fun payType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.payType = mapped
    }

    /**
     * @param value
     */
    @JvmName("rdgsyksrfvmjffdo")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value
     */
    @JvmName("velaooqhwvakjxoh")
    public suspend fun periodUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodUnit = mapped
    }

    /**
     * @param value The vswitch_id of dataCenter-2, mast different of vswitch_id(dc-1), can not empty.
     * > **NOTE:** Now data_center_name,instance_type,node_count,disk_type,disk_size can be change. The others(auto_renew, auto_renew_period and so on) will be supported in the furture.
     */
    @JvmName("usmxsxhnbeotscjg")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The Zone to launch the Cassandra dataCenter-2. If vswitch_id is not empty, this zone_id can be "" or consistent.
     */
    @JvmName("biowgbmhkkwcwfrg")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DataCenterArgs = DataCenterArgs(
        autoRenew = autoRenew,
        autoRenewPeriod = autoRenewPeriod,
        clusterId = clusterId,
        dataCenterName = dataCenterName,
        diskSize = diskSize,
        diskType = diskType,
        enablePublic = enablePublic,
        instanceType = instanceType,
        nodeCount = nodeCount,
        payType = payType,
        period = period,
        periodUnit = periodUnit,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
