@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin.inputs

import com.pulumi.alicloud.cassandra.inputs.GetBackupPlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBackupPlans.
 * @property clusterId The ID of the cluster for the backup.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetBackupPlansPlainArgs(
    public val clusterId: String,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cassandra.inputs.GetBackupPlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cassandra.inputs.GetBackupPlansPlainArgs =
        com.pulumi.alicloud.cassandra.inputs.GetBackupPlansPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupPlansPlainArgs].
 */
@PulumiTagMarker
public class GetBackupPlansPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var outputFile: String? = null

    /**
     * @param value The ID of the cluster for the backup.
     */
    @JvmName("ikrktcghxplkmqbp")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nmyomqgetisayfty")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetBackupPlansPlainArgs = GetBackupPlansPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        outputFile = outputFile,
    )
}
