@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin.inputs

import com.pulumi.alicloud.cassandra.inputs.GetClustersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusters.
 * @property ids The list of Cassandra cluster ids.
 * @property nameRegex A regex string to apply to the cluster name.
 * @property outputFile The name of file that can save the collection of clusters after running `pulumi preview`.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetClustersPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cassandra.inputs.GetClustersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cassandra.inputs.GetClustersPlainArgs =
        com.pulumi.alicloud.cassandra.inputs.GetClustersPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetClustersPlainArgs].
 */
@PulumiTagMarker
public class GetClustersPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value The list of Cassandra cluster ids.
     */
    @JvmName("lsvqrkhktpljqnve")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values The list of Cassandra cluster ids.
     */
    @JvmName("fdopqelmonfxxxay")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to apply to the cluster name.
     */
    @JvmName("fjaghlahmmeujnnx")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The name of file that can save the collection of clusters after running `pulumi preview`.
     */
    @JvmName("tdxyimpfbhskpdpd")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("filrervbrgmyrrud")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("eppvpbufuteagpwe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetClustersPlainArgs = GetClustersPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        tags = tags,
    )
}
