@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin.inputs

import com.pulumi.alicloud.cassandra.inputs.GetDataCentersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDataCenters.
 * @property clusterId The cluster id of dataCenters belongs to.
 * @property ids The list of Cassandra data center ids.
 * @property nameRegex A regex string to apply to the cluster name.
 * @property outputFile The name of file that can save the collection of data centers after running `pulumi preview`.
 */
public data class GetDataCentersPlainArgs(
    public val clusterId: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cassandra.inputs.GetDataCentersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cassandra.inputs.GetDataCentersPlainArgs =
        com.pulumi.alicloud.cassandra.inputs.GetDataCentersPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataCentersPlainArgs].
 */
@PulumiTagMarker
public class GetDataCentersPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The cluster id of dataCenters belongs to.
     */
    @JvmName("cfpjpkkmxbgrlkch")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value The list of Cassandra data center ids.
     */
    @JvmName("agvlsoxrllorhcif")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values The list of Cassandra data center ids.
     */
    @JvmName("rjskklllywplqjsh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to apply to the cluster name.
     */
    @JvmName("tuxprsurnswpuohj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The name of file that can save the collection of data centers after running `pulumi preview`.
     */
    @JvmName("qwjbdvipnrocwhfb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetDataCentersPlainArgs = GetDataCentersPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
