@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property active Specifies whether to activate the backup plan.
 * @property backupPeriod The backup cycle. Valid values: Monday, Tuesday, Wednesday, Thursday, Friday, Saturday, and Sunday.
 * @property backupTime The start time of the backup task each day. The time is displayed in UTC and denoted by Z.
 * @property clusterId The ID of the cluster for the backup.
 * @property createTime The time when the backup plan was created.
 * @property dataCenterId The ID of the data center for the backup in the cluster.
 * @property id The ID of the Backup Plan.
 * @property retentionPeriod The duration for which you want to retain the backup. Valid values: 1 to 30. Unit: days.
 */
public data class GetBackupPlansPlan(
    public val active: Boolean,
    public val backupPeriod: String,
    public val backupTime: String,
    public val clusterId: String,
    public val createTime: String,
    public val dataCenterId: String,
    public val id: String,
    public val retentionPeriod: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cassandra.outputs.GetBackupPlansPlan): GetBackupPlansPlan = GetBackupPlansPlan(
            active = javaType.active(),
            backupPeriod = javaType.backupPeriod(),
            backupTime = javaType.backupTime(),
            clusterId = javaType.clusterId(),
            createTime = javaType.createTime(),
            dataCenterId = javaType.dataCenterId(),
            id = javaType.id(),
            retentionPeriod = javaType.retentionPeriod(),
        )
    }
}
