@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBackupPlans.
 * @property clusterId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property plans
 */
public data class GetBackupPlansResult(
    public val clusterId: String,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val plans: List<GetBackupPlansPlan>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cassandra.outputs.GetBackupPlansResult): GetBackupPlansResult = GetBackupPlansResult(
            clusterId = javaType.clusterId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cassandra.kotlin.outputs.GetBackupPlansPlan.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
