@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property clusterId The ID of the Cassandra cluster.
 * @property clusterName The name of the Cassandra cluster.
 * @property createdTime
 * @property dataCenterCount The count of data centers
 * @property expireTime The expire time of the cluster.
 * @property id The ID of the Cassandra cluster.
 * @property lockMode The lock mode of the cluster.
 * @property majorVersion The major version of the cluster.
 * @property minorVersion The minor version of the cluster.
 * @property payType Billing method. Value options are `Subscription` for Pay-As-You-Go and `PayAsYouGo` for yearly or monthly subscription.
 * @property status Status of the cluster.
 * @property tags A mapping of tags to assign to the resource.
 */
public data class GetClustersCluster(
    public val clusterId: String,
    public val clusterName: String,
    public val createdTime: String,
    public val dataCenterCount: Int,
    public val expireTime: String,
    public val id: String,
    public val lockMode: String,
    public val majorVersion: String,
    public val minorVersion: String,
    public val payType: String,
    public val status: String,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cassandra.outputs.GetClustersCluster): GetClustersCluster = GetClustersCluster(
            clusterId = javaType.clusterId(),
            clusterName = javaType.clusterName(),
            createdTime = javaType.createdTime(),
            dataCenterCount = javaType.dataCenterCount(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            lockMode = javaType.lockMode(),
            majorVersion = javaType.majorVersion(),
            minorVersion = javaType.minorVersion(),
            payType = javaType.payType(),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
