@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clusterId The cluster id of dataCenters belongs to.
 * @property commodityInstance The commodity ID of the Cassandra dataCenter.
 * @property createdTime
 * @property dataCenterId The id of the Cassandra dataCenter.
 * @property dataCenterName The name of the Cassandra dataCenter.
 * @property diskSize One node disk size, unit:GB.
 * @property diskType Cloud_ssd or cloud_efficiency.
 * @property expireTime The expire time of the dataCenter.
 * @property instanceType The instance type of the Cassandra dataCenter, eg: cassandra.c.large.
 * @property lockMode The lock mode of the dataCenter.
 * @property nodeCount The node count of dataCenter.
 * @property payType Billing method. Value options are `Subscription` for Pay-As-You-Go and `PayAsYouGo` for yearly or monthly subscription.
 * @property status Status of the dataCenter.
 * @property vpcId VPC ID the dataCenter belongs to.
 * @property vswitchId VSwitch ID the dataCenter belongs to.
 * @property zoneId Zone ID the dataCenter belongs to.
 */
public data class GetDataCentersCenter(
    public val clusterId: String,
    public val commodityInstance: String,
    public val createdTime: String,
    public val dataCenterId: String,
    public val dataCenterName: String,
    public val diskSize: Int,
    public val diskType: String,
    public val expireTime: String,
    public val instanceType: String,
    public val lockMode: String,
    public val nodeCount: Int,
    public val payType: String,
    public val status: String,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cassandra.outputs.GetDataCentersCenter): GetDataCentersCenter = GetDataCentersCenter(
            clusterId = javaType.clusterId(),
            commodityInstance = javaType.commodityInstance(),
            createdTime = javaType.createdTime(),
            dataCenterId = javaType.dataCenterId(),
            dataCenterName = javaType.dataCenterName(),
            diskSize = javaType.diskSize(),
            diskType = javaType.diskType(),
            expireTime = javaType.expireTime(),
            instanceType = javaType.instanceType(),
            lockMode = javaType.lockMode(),
            nodeCount = javaType.nodeCount(),
            payType = javaType.payType(),
            status = javaType.status(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
