@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cassandra.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDataCenters.
 * @property centers A list of Cassandra data centers. Its every element contains the following attributes:
 * @property clusterId The ID of the Cassandra cluster.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids The list of Cassandra data center ids.
 * @property nameRegex
 * @property names The name list of Cassandra data centers.
 * @property outputFile
 */
public data class GetDataCentersResult(
    public val centers: List<GetDataCentersCenter>,
    public val clusterId: String,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cassandra.outputs.GetDataCentersResult): GetDataCentersResult = GetDataCentersResult(
            centers = javaType.centers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cassandra.kotlin.outputs.GetDataCentersCenter.Companion.toKotlin(args0)
                })
            }),
            clusterId = javaType.clusterId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
