@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin

import com.pulumi.alicloud.cddc.CddcFunctions.getDedicatedHostAccountsPlain
import com.pulumi.alicloud.cddc.CddcFunctions.getDedicatedHostGroupsPlain
import com.pulumi.alicloud.cddc.CddcFunctions.getDedicatedHostsPlain
import com.pulumi.alicloud.cddc.CddcFunctions.getHostEcsLevelInfosPlain
import com.pulumi.alicloud.cddc.CddcFunctions.getZonesPlain
import com.pulumi.alicloud.cddc.kotlin.inputs.GetDedicatedHostAccountsPlainArgs
import com.pulumi.alicloud.cddc.kotlin.inputs.GetDedicatedHostAccountsPlainArgsBuilder
import com.pulumi.alicloud.cddc.kotlin.inputs.GetDedicatedHostGroupsPlainArgs
import com.pulumi.alicloud.cddc.kotlin.inputs.GetDedicatedHostGroupsPlainArgsBuilder
import com.pulumi.alicloud.cddc.kotlin.inputs.GetDedicatedHostsPlainArgs
import com.pulumi.alicloud.cddc.kotlin.inputs.GetDedicatedHostsPlainArgsBuilder
import com.pulumi.alicloud.cddc.kotlin.inputs.GetHostEcsLevelInfosPlainArgs
import com.pulumi.alicloud.cddc.kotlin.inputs.GetHostEcsLevelInfosPlainArgsBuilder
import com.pulumi.alicloud.cddc.kotlin.inputs.GetZonesPlainArgs
import com.pulumi.alicloud.cddc.kotlin.inputs.GetZonesPlainArgsBuilder
import com.pulumi.alicloud.cddc.kotlin.outputs.GetDedicatedHostAccountsResult
import com.pulumi.alicloud.cddc.kotlin.outputs.GetDedicatedHostGroupsResult
import com.pulumi.alicloud.cddc.kotlin.outputs.GetDedicatedHostsResult
import com.pulumi.alicloud.cddc.kotlin.outputs.GetHostEcsLevelInfosResult
import com.pulumi.alicloud.cddc.kotlin.outputs.GetZonesResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cddc.kotlin.outputs.GetDedicatedHostAccountsResult.Companion.toKotlin as getDedicatedHostAccountsResultToKotlin
import com.pulumi.alicloud.cddc.kotlin.outputs.GetDedicatedHostGroupsResult.Companion.toKotlin as getDedicatedHostGroupsResultToKotlin
import com.pulumi.alicloud.cddc.kotlin.outputs.GetDedicatedHostsResult.Companion.toKotlin as getDedicatedHostsResultToKotlin
import com.pulumi.alicloud.cddc.kotlin.outputs.GetHostEcsLevelInfosResult.Companion.toKotlin as getHostEcsLevelInfosResultToKotlin
import com.pulumi.alicloud.cddc.kotlin.outputs.GetZonesResult.Companion.toKotlin as getZonesResultToKotlin

public object CddcFunctions {
    /**
     * This data source provides the Cddc Dedicated Host Accounts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.148.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cddc.getDedicatedHostAccounts({});
     * export const cddcDedicatedHostAccountId1 = ids.then(ids => ids.accounts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cddc.get_dedicated_host_accounts()
     * pulumi.export("cddcDedicatedHostAccountId1", ids.accounts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cddc.GetDedicatedHostAccounts.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["cddcDedicatedHostAccountId1"] = ids&#46;Apply(getDedicatedHostAccountsResult => getDedicatedHostAccountsResult&#46;Accounts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cddc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cddc.GetDedicatedHostAccounts(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cddcDedicatedHostAccountId1", ids.Accounts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cddc.CddcFunctions;
     * import com.pulumi.alicloud.cddc.inputs.GetDedicatedHostAccountsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CddcFunctions.getDedicatedHostAccounts();
     *         ctx.export("cddcDedicatedHostAccountId1", ids.applyValue(getDedicatedHostAccountsResult -> getDedicatedHostAccountsResult.accounts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cddc:getDedicatedHostAccounts
     *       Arguments: {}
     * outputs:
     *   cddcDedicatedHostAccountId1: ${ids.accounts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDedicatedHostAccounts.
     * @return A collection of values returned by getDedicatedHostAccounts.
     */
    public suspend fun getDedicatedHostAccounts(argument: GetDedicatedHostAccountsPlainArgs): GetDedicatedHostAccountsResult =
        getDedicatedHostAccountsResultToKotlin(getDedicatedHostAccountsPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedHostAccounts].
     * @param dedicatedHostId The ID of the host.
     * @param ids A list of Dedicated Host Account IDs.
     * @param nameRegex A regex string to filter results by Account name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param pageNumber
     * @param pageSize
     * @return A collection of values returned by getDedicatedHostAccounts.
     */
    public suspend fun getDedicatedHostAccounts(
        dedicatedHostId: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
        pageNumber: Int? = null,
        pageSize: Int? = null,
    ): GetDedicatedHostAccountsResult {
        val argument = GetDedicatedHostAccountsPlainArgs(
            dedicatedHostId = dedicatedHostId,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
            pageNumber = pageNumber,
            pageSize = pageSize,
        )
        return getDedicatedHostAccountsResultToKotlin(getDedicatedHostAccountsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedHostAccounts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cddc&#46;kotlin&#46;inputs&#46;GetDedicatedHostAccountsPlainArgs].
     * @return A collection of values returned by getDedicatedHostAccounts.
     */
    public suspend fun getDedicatedHostAccounts(argument: suspend GetDedicatedHostAccountsPlainArgsBuilder.() -> Unit): GetDedicatedHostAccountsResult {
        val builder = GetDedicatedHostAccountsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedHostAccountsResultToKotlin(getDedicatedHostAccountsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cddc Dedicated Host Groups of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.132.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const default = alicloud.cddc.getDedicatedHostGroups({
     *     engine: "MongoDB",
     * });
     * export const cddcDedicatedHostGroupId = _default.then(_default => _default.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * default = alicloud.cddc.get_dedicated_host_groups(engine="MongoDB")
     * pulumi.export("cddcDedicatedHostGroupId", default.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = AliCloud.Cddc.GetDedicatedHostGroups.Invoke(new()
     *     {
     *         Engine = "MongoDB",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cddcDedicatedHostGroupId"] = @default.Apply(@default => @default.Apply(getDedicatedHostGroupsResult => getDedicatedHostGroupsResult.Id)),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cddc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := cddc.GetDedicatedHostGroups(ctx, &cddc.GetDedicatedHostGroupsArgs{
     * 			Engine: pulumi.StringRef("MongoDB"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cddcDedicatedHostGroupId", _default.Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cddc.CddcFunctions;
     * import com.pulumi.alicloud.cddc.inputs.GetDedicatedHostGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = CddcFunctions.getDedicatedHostGroups(GetDedicatedHostGroupsArgs.builder()
     *             .engine("MongoDB")
     *             .build());
     *         ctx.export("cddcDedicatedHostGroupId", default_.id());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: alicloud:cddc:getDedicatedHostGroups
     *       Arguments:
     *         engine: MongoDB
     * outputs:
     *   cddcDedicatedHostGroupId: ${default.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDedicatedHostGroups.
     * @return A collection of values returned by getDedicatedHostGroups.
     */
    public suspend fun getDedicatedHostGroups(argument: GetDedicatedHostGroupsPlainArgs): GetDedicatedHostGroupsResult =
        getDedicatedHostGroupsResultToKotlin(getDedicatedHostGroupsPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedHostGroups].
     * @param engine Database Engine Type. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`
     * @param ids A list of Dedicated Host Group IDs.
     * @param nameRegex A regex string to filter results by Dedicated Host Group name.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getDedicatedHostGroups.
     */
    public suspend fun getDedicatedHostGroups(
        engine: String? = null,
        ids: List<String>? = null,
        nameRegex: String? = null,
        outputFile: String? = null,
    ): GetDedicatedHostGroupsResult {
        val argument = GetDedicatedHostGroupsPlainArgs(
            engine = engine,
            ids = ids,
            nameRegex = nameRegex,
            outputFile = outputFile,
        )
        return getDedicatedHostGroupsResultToKotlin(getDedicatedHostGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedHostGroups].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cddc&#46;kotlin&#46;inputs&#46;GetDedicatedHostGroupsPlainArgs].
     * @return A collection of values returned by getDedicatedHostGroups.
     */
    public suspend fun getDedicatedHostGroups(argument: suspend GetDedicatedHostGroupsPlainArgsBuilder.() -> Unit): GetDedicatedHostGroupsResult {
        val builder = GetDedicatedHostGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedHostGroupsResultToKotlin(getDedicatedHostGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cddc Dedicated Hosts of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.147.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ids = alicloud.cddc.getDedicatedHosts({
     *     dedicatedHostGroupId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     * });
     * export const cddcDedicatedHostId1 = ids.then(ids => ids.hosts?.[0]?.id);
     * const status = alicloud.cddc.getDedicatedHosts({
     *     dedicatedHostGroupId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     status: "1",
     * });
     * export const cddcDedicatedHostId2 = status.then(status => status.hosts?.[0]?.id);
     * const zoneId = alicloud.cddc.getDedicatedHosts({
     *     dedicatedHostGroupId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     zoneId: "example_value",
     * });
     * export const cddcDedicatedHostId3 = zoneId.then(zoneId => zoneId.hosts?.[0]?.id);
     * const allocationStatus = alicloud.cddc.getDedicatedHosts({
     *     dedicatedHostGroupId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     allocationStatus: "Allocatable",
     * });
     * export const cddcDedicatedHostId4 = allocationStatus.then(allocationStatus => allocationStatus.hosts?.[0]?.id);
     * const hostType = alicloud.cddc.getDedicatedHosts({
     *     dedicatedHostGroupId: "example_value",
     *     ids: [
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     hostType: "dhg_cloud_ssd",
     * });
     * export const cddcDedicatedHostId5 = hostType.then(hostType => hostType.hosts?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ids = alicloud.cddc.get_dedicated_hosts(dedicated_host_group_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ])
     * pulumi.export("cddcDedicatedHostId1", ids.hosts[0].id)
     * status = alicloud.cddc.get_dedicated_hosts(dedicated_host_group_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     status="1")
     * pulumi.export("cddcDedicatedHostId2", status.hosts[0].id)
     * zone_id = alicloud.cddc.get_dedicated_hosts(dedicated_host_group_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     zone_id="example_value")
     * pulumi.export("cddcDedicatedHostId3", zone_id.hosts[0].id)
     * allocation_status = alicloud.cddc.get_dedicated_hosts(dedicated_host_group_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     allocation_status="Allocatable")
     * pulumi.export("cddcDedicatedHostId4", allocation_status.hosts[0].id)
     * host_type = alicloud.cddc.get_dedicated_hosts(dedicated_host_group_id="example_value",
     *     ids=[
     *         "example_value-1",
     *         "example_value-2",
     *     ],
     *     host_type="dhg_cloud_ssd")
     * pulumi.export("cddcDedicatedHostId5", host_type.hosts[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ids = AliCloud.Cddc.GetDedicatedHosts.Invoke(new()
     *     {
     *         DedicatedHostGroupId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *     });
     *     var status = AliCloud.Cddc.GetDedicatedHosts.Invoke(new()
     *     {
     *         DedicatedHostGroupId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *         Status = "1",
     *     });
     *     var zoneId = AliCloud.Cddc.GetDedicatedHosts.Invoke(new()
     *     {
     *         DedicatedHostGroupId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *         ZoneId = "example_value",
     *     });
     *     var allocationStatus = AliCloud.Cddc.GetDedicatedHosts.Invoke(new()
     *     {
     *         DedicatedHostGroupId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *         AllocationStatus = "Allocatable",
     *     });
     *     var hostType = AliCloud.Cddc.GetDedicatedHosts.Invoke(new()
     *     {
     *         DedicatedHostGroupId = "example_value",
     *         Ids = new[]
     *         {
     *             "example_value-1",
     *             "example_value-2",
     *         },
     *         HostType = "dhg_cloud_ssd",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cddcDedicatedHostId1"] = ids&#46;Apply(getDedicatedHostsResult => getDedicatedHostsResult&#46;Hosts[0]?.Id),
     *         ["cddcDedicatedHostId2"] = status&#46;Apply(getDedicatedHostsResult => getDedicatedHostsResult&#46;Hosts[0]?.Id),
     *         ["cddcDedicatedHostId3"] = zoneId&#46;Apply(getDedicatedHostsResult => getDedicatedHostsResult&#46;Hosts[0]?.Id),
     *         ["cddcDedicatedHostId4"] = allocationStatus&#46;Apply(getDedicatedHostsResult => getDedicatedHostsResult&#46;Hosts[0]?.Id),
     *         ["cddcDedicatedHostId5"] = hostType&#46;Apply(getDedicatedHostsResult => getDedicatedHostsResult&#46;Hosts[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cddc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		ids, err := cddc.GetDedicatedHosts(ctx, &cddc.GetDedicatedHostsArgs{
     * 			DedicatedHostGroupId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cddcDedicatedHostId1", ids.Hosts[0].Id)
     * 		status, err := cddc.GetDedicatedHosts(ctx, &cddc.GetDedicatedHostsArgs{
     * 			DedicatedHostGroupId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 			Status: pulumi.StringRef("1"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cddcDedicatedHostId2", status.Hosts[0].Id)
     * 		zoneId, err := cddc.GetDedicatedHosts(ctx, &cddc.GetDedicatedHostsArgs{
     * 			DedicatedHostGroupId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 			ZoneId: pulumi.StringRef("example_value"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cddcDedicatedHostId3", zoneId.Hosts[0].Id)
     * 		allocationStatus, err := cddc.GetDedicatedHosts(ctx, &cddc.GetDedicatedHostsArgs{
     * 			DedicatedHostGroupId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 			AllocationStatus: pulumi.StringRef("Allocatable"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cddcDedicatedHostId4", allocationStatus.Hosts[0].Id)
     * 		hostType, err := cddc.GetDedicatedHosts(ctx, &cddc.GetDedicatedHostsArgs{
     * 			DedicatedHostGroupId: "example_value",
     * 			Ids: []string{
     * 				"example_value-1",
     * 				"example_value-2",
     * 			},
     * 			HostType: pulumi.StringRef("dhg_cloud_ssd"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cddcDedicatedHostId5", hostType.Hosts[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cddc.CddcFunctions;
     * import com.pulumi.alicloud.cddc.inputs.GetDedicatedHostsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ids = CddcFunctions.getDedicatedHosts(GetDedicatedHostsArgs.builder()
     *             .dedicatedHostGroupId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .build());
     *         ctx.export("cddcDedicatedHostId1", ids.applyValue(getDedicatedHostsResult -> getDedicatedHostsResult.hosts()[0].id()));
     *         final var status = CddcFunctions.getDedicatedHosts(GetDedicatedHostsArgs.builder()
     *             .dedicatedHostGroupId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .status("1")
     *             .build());
     *         ctx.export("cddcDedicatedHostId2", status.applyValue(getDedicatedHostsResult -> getDedicatedHostsResult.hosts()[0].id()));
     *         final var zoneId = CddcFunctions.getDedicatedHosts(GetDedicatedHostsArgs.builder()
     *             .dedicatedHostGroupId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .zoneId("example_value")
     *             .build());
     *         ctx.export("cddcDedicatedHostId3", zoneId.applyValue(getDedicatedHostsResult -> getDedicatedHostsResult.hosts()[0].id()));
     *         final var allocationStatus = CddcFunctions.getDedicatedHosts(GetDedicatedHostsArgs.builder()
     *             .dedicatedHostGroupId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .allocationStatus("Allocatable")
     *             .build());
     *         ctx.export("cddcDedicatedHostId4", allocationStatus.applyValue(getDedicatedHostsResult -> getDedicatedHostsResult.hosts()[0].id()));
     *         final var hostType = CddcFunctions.getDedicatedHosts(GetDedicatedHostsArgs.builder()
     *             .dedicatedHostGroupId("example_value")
     *             .ids(
     *                 "example_value-1",
     *                 "example_value-2")
     *             .hostType("dhg_cloud_ssd")
     *             .build());
     *         ctx.export("cddcDedicatedHostId5", hostType.applyValue(getDedicatedHostsResult -> getDedicatedHostsResult.hosts()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ids:
     *     fn::invoke:
     *       Function: alicloud:cddc:getDedicatedHosts
     *       Arguments:
     *         dedicatedHostGroupId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *   status:
     *     fn::invoke:
     *       Function: alicloud:cddc:getDedicatedHosts
     *       Arguments:
     *         dedicatedHostGroupId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *         status: '1'
     *   zoneId:
     *     fn::invoke:
     *       Function: alicloud:cddc:getDedicatedHosts
     *       Arguments:
     *         dedicatedHostGroupId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *         zoneId: example_value
     *   allocationStatus:
     *     fn::invoke:
     *       Function: alicloud:cddc:getDedicatedHosts
     *       Arguments:
     *         dedicatedHostGroupId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *         allocationStatus: Allocatable
     *   hostType:
     *     fn::invoke:
     *       Function: alicloud:cddc:getDedicatedHosts
     *       Arguments:
     *         dedicatedHostGroupId: example_value
     *         ids:
     *           - example_value-1
     *           - example_value-2
     *         hostType: dhg_cloud_ssd
     * outputs:
     *   cddcDedicatedHostId1: ${ids.hosts[0].id}
     *   cddcDedicatedHostId2: ${status.hosts[0].id}
     *   cddcDedicatedHostId3: ${zoneId.hosts[0].id}
     *   cddcDedicatedHostId4: ${allocationStatus.hosts[0].id}
     *   cddcDedicatedHostId5: ${hostType.hosts[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDedicatedHosts.
     * @return A collection of values returned by getDedicatedHosts.
     */
    public suspend fun getDedicatedHosts(argument: GetDedicatedHostsPlainArgs): GetDedicatedHostsResult =
        getDedicatedHostsResultToKotlin(getDedicatedHostsPlain(argument.toJava()).await())

    /**
     * @see [getDedicatedHosts].
     * @param allocationStatus Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
     * @param dedicatedHostGroupId The ID of the dedicated cluster.
     * @param enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
     * @param hostType The storage type of the host. Valid values: `dhg_local_ssd` or `dhg_cloud_ssd`. `dhg_local_ssd`: specifies that the host uses local SSDs. `dhg_cloud_ssd`: specifies that the host uses enhanced SSDs (ESSDs).
     * @param ids A list of Dedicated Host IDs.
     * @param orderId The ID of the order.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The state of the host. Valid values:
     * * `0:` The host is being created.
     * @param tags A mapping of tags to assign to the resource.
     * @param zoneId The ID of the zone.
     * @return A collection of values returned by getDedicatedHosts.
     */
    public suspend fun getDedicatedHosts(
        allocationStatus: String? = null,
        dedicatedHostGroupId: String,
        enableDetails: Boolean? = null,
        hostType: String? = null,
        ids: List<String>? = null,
        orderId: String? = null,
        outputFile: String? = null,
        status: String? = null,
        tags: Map<String, String>? = null,
        zoneId: String? = null,
    ): GetDedicatedHostsResult {
        val argument = GetDedicatedHostsPlainArgs(
            allocationStatus = allocationStatus,
            dedicatedHostGroupId = dedicatedHostGroupId,
            enableDetails = enableDetails,
            hostType = hostType,
            ids = ids,
            orderId = orderId,
            outputFile = outputFile,
            status = status,
            tags = tags,
            zoneId = zoneId,
        )
        return getDedicatedHostsResultToKotlin(getDedicatedHostsPlain(argument.toJava()).await())
    }

    /**
     * @see [getDedicatedHosts].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cddc&#46;kotlin&#46;inputs&#46;GetDedicatedHostsPlainArgs].
     * @return A collection of values returned by getDedicatedHosts.
     */
    public suspend fun getDedicatedHosts(argument: suspend GetDedicatedHostsPlainArgsBuilder.() -> Unit): GetDedicatedHostsResult {
        val builder = GetDedicatedHostsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDedicatedHostsResultToKotlin(getDedicatedHostsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cddc Host Ecs Level Infos of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.147.0+.
     * @param argument A collection of arguments for invoking getHostEcsLevelInfos.
     * @return A collection of values returned by getHostEcsLevelInfos.
     */
    public suspend fun getHostEcsLevelInfos(argument: GetHostEcsLevelInfosPlainArgs): GetHostEcsLevelInfosResult =
        getHostEcsLevelInfosResultToKotlin(getHostEcsLevelInfosPlain(argument.toJava()).await())

    /**
     * @see [getHostEcsLevelInfos].
     * @param dbType The database engine of the host. Valid values: `mysql`, `mssql`, `pgsql`, `redis`.
     * @param imageCategory Host image. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param storageType The storage type of the host ecs level info. Valid values: `local_ssd`, `cloud_essd`, `cloud_essd2`, `cloud_essd3`.
     * @param zoneId The ID of the zone in the region.
     * @return A collection of values returned by getHostEcsLevelInfos.
     */
    public suspend fun getHostEcsLevelInfos(
        dbType: String,
        imageCategory: String? = null,
        outputFile: String? = null,
        storageType: String,
        zoneId: String,
    ): GetHostEcsLevelInfosResult {
        val argument = GetHostEcsLevelInfosPlainArgs(
            dbType = dbType,
            imageCategory = imageCategory,
            outputFile = outputFile,
            storageType = storageType,
            zoneId = zoneId,
        )
        return getHostEcsLevelInfosResultToKotlin(getHostEcsLevelInfosPlain(argument.toJava()).await())
    }

    /**
     * @see [getHostEcsLevelInfos].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cddc&#46;kotlin&#46;inputs&#46;GetHostEcsLevelInfosPlainArgs].
     * @return A collection of values returned by getHostEcsLevelInfos.
     */
    public suspend fun getHostEcsLevelInfos(argument: suspend GetHostEcsLevelInfosPlainArgsBuilder.() -> Unit): GetHostEcsLevelInfosResult {
        val builder = GetHostEcsLevelInfosPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHostEcsLevelInfosResultToKotlin(getHostEcsLevelInfosPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cddc Zones of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.147.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cddc.getZones({});
     * export const cddcZonesId1 = example.then(example => example.zones?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cddc.get_zones()
     * pulumi.export("cddcZonesId1", example.zones[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cddc.GetZones.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["cddcZonesId1"] = example&#46;Apply(getZonesResult => getZonesResult&#46;Zones[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cddc"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cddc.GetZones(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cddcZonesId1", example.Zones[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cddc.CddcFunctions;
     * import com.pulumi.alicloud.cddc.inputs.GetZonesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CddcFunctions.getZones();
     *         ctx.export("cddcZonesId1", example.applyValue(getZonesResult -> getZonesResult.zones()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cddc:getZones
     *       Arguments: {}
     * outputs:
     *   cddcZonesId1: ${example.zones[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getZones.
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: GetZonesPlainArgs): GetZonesResult =
        getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())

    /**
     * @see [getZones].
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(outputFile: String? = null): GetZonesResult {
        val argument = GetZonesPlainArgs(
            outputFile = outputFile,
        )
        return getZonesResultToKotlin(getZonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getZones].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cddc&#46;kotlin&#46;inputs&#46;GetZonesPlainArgs].
     * @return A collection of values returned by getZones.
     */
    public suspend fun getZones(argument: suspend GetZonesPlainArgsBuilder.() -> Unit): GetZonesResult {
        val builder = GetZonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getZonesResultToKotlin(getZonesPlain(builtArgument.toJava()).await())
    }
}
