@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DedicatedHost].
 */
@PulumiTagMarker
public class DedicatedHostResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedHostArgs = DedicatedHostArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedHostArgsBuilder.() -> Unit) {
        val builder = DedicatedHostArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedHost {
        val builtJavaResource = com.pulumi.alicloud.cddc.DedicatedHost(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DedicatedHost(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * ApsaraDB for MyBase Dedicated Host can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cddc/dedicatedHost:DedicatedHost example <dedicated_host_group_id>:<dedicated_host_id>
 * ```
 */
public class DedicatedHost internal constructor(
    override val javaResource: com.pulumi.alicloud.cddc.DedicatedHost,
) : KotlinCustomResource(javaResource, DedicatedHostMapper) {
    /**
     * Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
     */
    public val allocationStatus: Output<String>
        get() = javaResource.allocationStatus().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to enable the auto-renewal feature.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the dedicated cluster.
     */
    public val dedicatedHostGroupId: Output<String>
        get() = javaResource.dedicatedHostGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the host.
     */
    public val dedicatedHostId: Output<String>
        get() = javaResource.dedicatedHostId().applyValue({ args0 -> args0 })

    /**
     * The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
     */
    public val hostClass: Output<String>
        get() = javaResource.hostClass().applyValue({ args0 -> args0 })

    /**
     * The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
     */
    public val hostName: Output<String>
        get() = javaResource.hostName().applyValue({ args0 -> args0 })

    /**
     * Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
     */
    public val imageCategory: Output<String>?
        get() = javaResource.imageCategory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
     */
    public val osPassword: Output<String>?
        get() = javaResource.osPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The payment type of the resource. Valid values: `Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The state of the host. Valid values: `0:` The host is being created. `1`: The host is running. `2`: The host is faulty. `3`: The host is ready for deactivation. `4`: The host is being maintained. `5`: The host is deactivated. `6`: The host is restarting. `7`: The host is locked.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The subscription duration of the host. Valid values:
     * * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
     * * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
     * * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
     */
    public val usedTime: Output<Int>?
        get() = javaResource.usedTime().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the vSwitch to which the host is connected.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })

    /**
     * The ID of the zone.
     */
    public val zoneId: Output<String>
        get() = javaResource.zoneId().applyValue({ args0 -> args0 })
}

public object DedicatedHostMapper : ResourceMapper<DedicatedHost> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cddc.DedicatedHost::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedHost = DedicatedHost(
        javaResource as
            com.pulumi.alicloud.cddc.DedicatedHost,
    )
}

/**
 * @see [DedicatedHost].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedHost].
 */
public suspend fun dedicatedHost(
    name: String,
    block: suspend DedicatedHostResourceBuilder.() -> Unit,
): DedicatedHost {
    val builder = DedicatedHostResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedHost].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedHost(name: String): DedicatedHost {
    val builder = DedicatedHostResourceBuilder()
    builder.name(name)
    return builder.build()
}
