@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin

import com.pulumi.alicloud.cddc.DedicatedHostArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * ApsaraDB for MyBase Dedicated Host can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cddc/dedicatedHost:DedicatedHost example <dedicated_host_group_id>:<dedicated_host_id>
 * ```
 * @property allocationStatus Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
 * @property autoRenew Specifies whether to enable the auto-renewal feature.
 * @property dedicatedHostGroupId The ID of the dedicated cluster.
 * @property hostClass The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
 * @property hostName The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
 * @property imageCategory Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
 * @property osPassword Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
 * @property paymentType The payment type of the resource. Valid values: `Subscription`.
 * @property period The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
 * @property tags A mapping of tags to assign to the resource.
 * @property usedTime The subscription duration of the host. Valid values:
 * * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
 * * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
 * * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
 * @property vswitchId The ID of the vSwitch to which the host is connected.
 * @property zoneId The ID of the zone.
 */
public data class DedicatedHostArgs(
    public val allocationStatus: Output<String>? = null,
    public val autoRenew: Output<Boolean>? = null,
    public val dedicatedHostGroupId: Output<String>? = null,
    public val hostClass: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val imageCategory: Output<String>? = null,
    public val osPassword: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val usedTime: Output<Int>? = null,
    public val vswitchId: Output<String>? = null,
    public val zoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cddc.DedicatedHostArgs> {
    override fun toJava(): com.pulumi.alicloud.cddc.DedicatedHostArgs =
        com.pulumi.alicloud.cddc.DedicatedHostArgs.builder()
            .allocationStatus(allocationStatus?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .dedicatedHostGroupId(dedicatedHostGroupId?.applyValue({ args0 -> args0 }))
            .hostClass(hostClass?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .imageCategory(imageCategory?.applyValue({ args0 -> args0 }))
            .osPassword(osPassword?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .usedTime(usedTime?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 }))
            .zoneId(zoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedHostArgs].
 */
@PulumiTagMarker
public class DedicatedHostArgsBuilder internal constructor() {
    private var allocationStatus: Output<String>? = null

    private var autoRenew: Output<Boolean>? = null

    private var dedicatedHostGroupId: Output<String>? = null

    private var hostClass: Output<String>? = null

    private var hostName: Output<String>? = null

    private var imageCategory: Output<String>? = null

    private var osPassword: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var usedTime: Output<Int>? = null

    private var vswitchId: Output<String>? = null

    private var zoneId: Output<String>? = null

    /**
     * @param value Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
     */
    @JvmName("dbinvlrlmsdykpmv")
    public suspend fun allocationStatus(`value`: Output<String>) {
        this.allocationStatus = value
    }

    /**
     * @param value Specifies whether to enable the auto-renewal feature.
     */
    @JvmName("bbuqsvgkplbmvlal")
    public suspend fun autoRenew(`value`: Output<Boolean>) {
        this.autoRenew = value
    }

    /**
     * @param value The ID of the dedicated cluster.
     */
    @JvmName("wmqqcqwjjbkpihxy")
    public suspend fun dedicatedHostGroupId(`value`: Output<String>) {
        this.dedicatedHostGroupId = value
    }

    /**
     * @param value The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
     */
    @JvmName("nlrbipbyvogmsvuj")
    public suspend fun hostClass(`value`: Output<String>) {
        this.hostClass = value
    }

    /**
     * @param value The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("xqhdknqqfsqlfsxu")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
     */
    @JvmName("xmpwnodvbwvulchg")
    public suspend fun imageCategory(`value`: Output<String>) {
        this.imageCategory = value
    }

    /**
     * @param value Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
     */
    @JvmName("baqayhkmoyipacnx")
    public suspend fun osPassword(`value`: Output<String>) {
        this.osPassword = value
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`.
     */
    @JvmName("manqrqcggafwossb")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
     */
    @JvmName("pnuomrgkqobyluux")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("iilmuilpinfdiuam")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The subscription duration of the host. Valid values:
     * * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
     * * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
     * * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
     */
    @JvmName("glpsiunnpptjwdtx")
    public suspend fun usedTime(`value`: Output<Int>) {
        this.usedTime = value
    }

    /**
     * @param value The ID of the vSwitch to which the host is connected.
     */
    @JvmName("vtvnabppfujerkji")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("kuoqoebpciqsdicb")
    public suspend fun zoneId(`value`: Output<String>) {
        this.zoneId = value
    }

    /**
     * @param value Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
     */
    @JvmName("blwjttfwxodfhmki")
    public suspend fun allocationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationStatus = mapped
    }

    /**
     * @param value Specifies whether to enable the auto-renewal feature.
     */
    @JvmName("plkuoryhsgjagwob")
    public suspend fun autoRenew(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value The ID of the dedicated cluster.
     */
    @JvmName("votduaeghrrmewsc")
    public suspend fun dedicatedHostGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostGroupId = mapped
    }

    /**
     * @param value The instance type of the host. For more information about the supported instance types of hosts, see [Host specification details](https://www.alibabacloud.com/help/doc-detail/206343.htm).
     */
    @JvmName("yqfrvuchxrqvrvyb")
    public suspend fun hostClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostClass = mapped
    }

    /**
     * @param value The name of the host. The name must be `1` to `64` characters in length and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter.
     */
    @JvmName("bisgrynjudnqkusw")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Host Image Category. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
     */
    @JvmName("xahjsamgretnendh")
    public suspend fun imageCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageCategory = mapped
    }

    /**
     * @param value Host password. **NOTE:** The creation of a host password is supported only when the database type is `Tair-PMem`.
     */
    @JvmName("hyokixrvqqwikcqt")
    public suspend fun osPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osPassword = mapped
    }

    /**
     * @param value The payment type of the resource. Valid values: `Subscription`.
     */
    @JvmName("qdwacbcnjqflcooj")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value The unit of the subscription duration. Valid values: `Year`, `Month`, `Week`.
     */
    @JvmName("vhkbkqyxyyxvmgcs")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("ptaeeqlkjltiifmb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("qntxfhlxtrigfodi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The subscription duration of the host. Valid values:
     * * If the Period parameter is set to `Year`, the value of the UsedTime parameter ranges from `1` to `5`.
     * * If the Period parameter is set to `Month`, the value of the UsedTime parameter ranges from `1` to `9`.
     * * If the Period parameter is set to `Week`, the value of the UsedTime parameter ranges from `1`, `2` and `3`.
     */
    @JvmName("nwtdrlchomopwnmp")
    public suspend fun usedTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usedTime = mapped
    }

    /**
     * @param value The ID of the vSwitch to which the host is connected.
     */
    @JvmName("dwkejqbnfaxuhbhu")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("trmqgqxcddpipemc")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneId = mapped
    }

    internal fun build(): DedicatedHostArgs = DedicatedHostArgs(
        allocationStatus = allocationStatus,
        autoRenew = autoRenew,
        dedicatedHostGroupId = dedicatedHostGroupId,
        hostClass = hostClass,
        hostName = hostName,
        imageCategory = imageCategory,
        osPassword = osPassword,
        paymentType = paymentType,
        period = period,
        tags = tags,
        usedTime = usedTime,
        vswitchId = vswitchId,
        zoneId = zoneId,
    )
}
