@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DedicatedHostGroup].
 */
@PulumiTagMarker
public class DedicatedHostGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedHostGroupArgs = DedicatedHostGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedHostGroupArgsBuilder.() -> Unit) {
        val builder = DedicatedHostGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedHostGroup {
        val builtJavaResource = com.pulumi.alicloud.cddc.DedicatedHostGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DedicatedHostGroup(builtJavaResource)
    }
}

/**
 * Provides a ApsaraDB for MyBase Dedicated Host Group resource.
 * For information about ApsaraDB for MyBase Dedicated Host Group and how to use it, see [What is Dedicated Host Group](https://www.alibabacloud.com/help/en/apsaradb-for-mybase/latest/creatededicatedhostgroup).
 * > **NOTE:** Available since v1.132.0.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-mybase/latest/notice-stop-selling-mybase-hosted-instances-from-august-31-2023) from version `1.225.1`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultDedicatedHostGroup = new alicloud.cddc.DedicatedHostGroup("default", {
 *     engine: "MySQL",
 *     vpcId: _default.id,
 *     cpuAllocationRatio: 101,
 *     memAllocationRatio: 50,
 *     diskAllocationRatio: 200,
 *     allocationPolicy: "Evenly",
 *     hostReplacePolicy: "Manual",
 *     dedicatedHostGroupDesc: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_dedicated_host_group = alicloud.cddc.DedicatedHostGroup("default",
 *     engine="MySQL",
 *     vpc_id=default.id,
 *     cpu_allocation_ratio=101,
 *     mem_allocation_ratio=50,
 *     disk_allocation_ratio=200,
 *     allocation_policy="Evenly",
 *     host_replace_policy="Manual",
 *     dedicated_host_group_desc=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultDedicatedHostGroup = new AliCloud.Cddc.DedicatedHostGroup("default", new()
 *     {
 *         Engine = "MySQL",
 *         VpcId = @default.Id,
 *         CpuAllocationRatio = 101,
 *         MemAllocationRatio = 50,
 *         DiskAllocationRatio = 200,
 *         AllocationPolicy = "Evenly",
 *         HostReplacePolicy = "Manual",
 *         DedicatedHostGroupDesc = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cddc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cddc.NewDedicatedHostGroup(ctx, "default", &cddc.DedicatedHostGroupArgs{
 * 			Engine:                 pulumi.String("MySQL"),
 * 			VpcId:                  _default.ID(),
 * 			CpuAllocationRatio:     pulumi.Int(101),
 * 			MemAllocationRatio:     pulumi.Int(50),
 * 			DiskAllocationRatio:    pulumi.Int(200),
 * 			AllocationPolicy:       pulumi.String("Evenly"),
 * 			HostReplacePolicy:      pulumi.String("Manual"),
 * 			DedicatedHostGroupDesc: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.cddc.DedicatedHostGroup;
 * import com.pulumi.alicloud.cddc.DedicatedHostGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultDedicatedHostGroup = new DedicatedHostGroup("defaultDedicatedHostGroup", DedicatedHostGroupArgs.builder()
 *             .engine("MySQL")
 *             .vpcId(default_.id())
 *             .cpuAllocationRatio(101)
 *             .memAllocationRatio(50)
 *             .diskAllocationRatio(200)
 *             .allocationPolicy("Evenly")
 *             .hostReplacePolicy("Manual")
 *             .dedicatedHostGroupDesc(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultDedicatedHostGroup:
 *     type: alicloud:cddc:DedicatedHostGroup
 *     name: default
 *     properties:
 *       engine: MySQL
 *       vpcId: ${default.id}
 *       cpuAllocationRatio: 101
 *       memAllocationRatio: 50
 *       diskAllocationRatio: 200
 *       allocationPolicy: Evenly
 *       hostReplacePolicy: Manual
 *       dedicatedHostGroupDesc: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ApsaraDB for MyBase Dedicated Host Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cddc/dedicatedHostGroup:DedicatedHostGroup example <id>
 * ```
 */
public class DedicatedHostGroup internal constructor(
    override val javaResource: com.pulumi.alicloud.cddc.DedicatedHostGroup,
) : KotlinCustomResource(javaResource, DedicatedHostGroupMapper) {
    /**
     * AThe policy that is used to allocate resources in the dedicated cluster. Valid values:`Evenly`,`Intensively`
     */
    public val allocationPolicy: Output<String>
        get() = javaResource.allocationPolicy().applyValue({ args0 -> args0 })

    /**
     * The CPU overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
     */
    public val cpuAllocationRatio: Output<Int>
        get() = javaResource.cpuAllocationRatio().applyValue({ args0 -> args0 })

    /**
     * The name of the dedicated cluster. The name must be 1 to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
     */
    public val dedicatedHostGroupDesc: Output<String>?
        get() = javaResource.dedicatedHostGroupDesc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Disk Allocation Ratio of the Dedicated Host Group. **NOTE:** When `engine = SQLServer`, this attribute does not support to set.
     */
    public val diskAllocationRatio: Output<Int>
        get() = javaResource.diskAllocationRatio().applyValue({ args0 -> args0 })

    /**
     * Database Engine Type.The database engine of the dedicated cluster. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`, `alisql`, `tair`, `mssql`. **NOTE:** Since v1.210.0., the `engine = SQLServer` was deprecated.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The policy based on which the system handles host failures. Valid values:`Auto`,`Manual`
     */
    public val hostReplacePolicy: Output<String>
        get() = javaResource.hostReplacePolicy().applyValue({ args0 -> args0 })

    /**
     * The Memory Allocation Ratio of the Dedicated Host Group.
     */
    public val memAllocationRatio: Output<Int>
        get() = javaResource.memAllocationRatio().applyValue({ args0 -> args0 })

    /**
     * Whether to enable the feature that allows you to have OS permissions on the hosts in the dedicated cluster. Valid values: `true` and `false`.
     * **NOTE:** The `open_permission` should be `true` when `engine = "SQLServer"`
     */
    public val openPermission: Output<Boolean>
        get() = javaResource.openPermission().applyValue({ args0 -> args0 })

    /**
     * The virtual private cloud (VPC) ID of the dedicated cluster.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object DedicatedHostGroupMapper : ResourceMapper<DedicatedHostGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cddc.DedicatedHostGroup::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedHostGroup = DedicatedHostGroup(
        javaResource as
            com.pulumi.alicloud.cddc.DedicatedHostGroup,
    )
}

/**
 * @see [DedicatedHostGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedHostGroup].
 */
public suspend fun dedicatedHostGroup(
    name: String,
    block: suspend DedicatedHostGroupResourceBuilder.() -> Unit,
): DedicatedHostGroup {
    val builder = DedicatedHostGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedHostGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedHostGroup(name: String): DedicatedHostGroup {
    val builder = DedicatedHostGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
