@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin

import com.pulumi.alicloud.cddc.DedicatedHostGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a ApsaraDB for MyBase Dedicated Host Group resource.
 * For information about ApsaraDB for MyBase Dedicated Host Group and how to use it, see [What is Dedicated Host Group](https://www.alibabacloud.com/help/en/apsaradb-for-mybase/latest/creatededicatedhostgroup).
 * > **NOTE:** Available since v1.132.0.
 * > **DEPRECATED:**  This resource has been [deprecated](https://www.alibabacloud.com/help/en/apsaradb-for-mybase/latest/notice-stop-selling-mybase-hosted-instances-from-august-31-2023) from version `1.225.1`.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "terraform-example";
 * const _default = new alicloud.vpc.Network("default", {
 *     vpcName: name,
 *     cidrBlock: "10.4.0.0/16",
 * });
 * const defaultDedicatedHostGroup = new alicloud.cddc.DedicatedHostGroup("default", {
 *     engine: "MySQL",
 *     vpcId: _default.id,
 *     cpuAllocationRatio: 101,
 *     memAllocationRatio: 50,
 *     diskAllocationRatio: 200,
 *     allocationPolicy: "Evenly",
 *     hostReplacePolicy: "Manual",
 *     dedicatedHostGroupDesc: name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "terraform-example"
 * default = alicloud.vpc.Network("default",
 *     vpc_name=name,
 *     cidr_block="10.4.0.0/16")
 * default_dedicated_host_group = alicloud.cddc.DedicatedHostGroup("default",
 *     engine="MySQL",
 *     vpc_id=default.id,
 *     cpu_allocation_ratio=101,
 *     mem_allocation_ratio=50,
 *     disk_allocation_ratio=200,
 *     allocation_policy="Evenly",
 *     host_replace_policy="Manual",
 *     dedicated_host_group_desc=name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "terraform-example";
 *     var @default = new AliCloud.Vpc.Network("default", new()
 *     {
 *         VpcName = name,
 *         CidrBlock = "10.4.0.0/16",
 *     });
 *     var defaultDedicatedHostGroup = new AliCloud.Cddc.DedicatedHostGroup("default", new()
 *     {
 *         Engine = "MySQL",
 *         VpcId = @default.Id,
 *         CpuAllocationRatio = 101,
 *         MemAllocationRatio = 50,
 *         DiskAllocationRatio = 200,
 *         AllocationPolicy = "Evenly",
 *         HostReplacePolicy = "Manual",
 *         DedicatedHostGroupDesc = name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cddc"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/vpc"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "terraform-example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		_, err := vpc.NewNetwork(ctx, "default", &vpc.NetworkArgs{
 * 			VpcName:   pulumi.String(name),
 * 			CidrBlock: pulumi.String("10.4.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cddc.NewDedicatedHostGroup(ctx, "default", &cddc.DedicatedHostGroupArgs{
 * 			Engine:                 pulumi.String("MySQL"),
 * 			VpcId:                  _default.ID(),
 * 			CpuAllocationRatio:     pulumi.Int(101),
 * 			MemAllocationRatio:     pulumi.Int(50),
 * 			DiskAllocationRatio:    pulumi.Int(200),
 * 			AllocationPolicy:       pulumi.String("Evenly"),
 * 			HostReplacePolicy:      pulumi.String("Manual"),
 * 			DedicatedHostGroupDesc: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.vpc.Network;
 * import com.pulumi.alicloud.vpc.NetworkArgs;
 * import com.pulumi.alicloud.cddc.DedicatedHostGroup;
 * import com.pulumi.alicloud.cddc.DedicatedHostGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("terraform-example");
 *         var default_ = new Network("default", NetworkArgs.builder()
 *             .vpcName(name)
 *             .cidrBlock("10.4.0.0/16")
 *             .build());
 *         var defaultDedicatedHostGroup = new DedicatedHostGroup("defaultDedicatedHostGroup", DedicatedHostGroupArgs.builder()
 *             .engine("MySQL")
 *             .vpcId(default_.id())
 *             .cpuAllocationRatio(101)
 *             .memAllocationRatio(50)
 *             .diskAllocationRatio(200)
 *             .allocationPolicy("Evenly")
 *             .hostReplacePolicy("Manual")
 *             .dedicatedHostGroupDesc(name)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: terraform-example
 * resources:
 *   default:
 *     type: alicloud:vpc:Network
 *     properties:
 *       vpcName: ${name}
 *       cidrBlock: 10.4.0.0/16
 *   defaultDedicatedHostGroup:
 *     type: alicloud:cddc:DedicatedHostGroup
 *     name: default
 *     properties:
 *       engine: MySQL
 *       vpcId: ${default.id}
 *       cpuAllocationRatio: 101
 *       memAllocationRatio: 50
 *       diskAllocationRatio: 200
 *       allocationPolicy: Evenly
 *       hostReplacePolicy: Manual
 *       dedicatedHostGroupDesc: ${name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ApsaraDB for MyBase Dedicated Host Group can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cddc/dedicatedHostGroup:DedicatedHostGroup example <id>
 * ```
 * @property allocationPolicy AThe policy that is used to allocate resources in the dedicated cluster. Valid values:`Evenly`,`Intensively`
 * @property cpuAllocationRatio The CPU overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
 * @property dedicatedHostGroupDesc The name of the dedicated cluster. The name must be 1 to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
 * @property diskAllocationRatio The Disk Allocation Ratio of the Dedicated Host Group. **NOTE:** When `engine = SQLServer`, this attribute does not support to set.
 * @property engine Database Engine Type.The database engine of the dedicated cluster. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`, `alisql`, `tair`, `mssql`. **NOTE:** Since v1.210.0., the `engine = SQLServer` was deprecated.
 * @property hostReplacePolicy The policy based on which the system handles host failures. Valid values:`Auto`,`Manual`
 * @property memAllocationRatio The Memory Allocation Ratio of the Dedicated Host Group.
 * @property openPermission Whether to enable the feature that allows you to have OS permissions on the hosts in the dedicated cluster. Valid values: `true` and `false`.
 * **NOTE:** The `open_permission` should be `true` when `engine = "SQLServer"`
 * @property vpcId The virtual private cloud (VPC) ID of the dedicated cluster.
 */
public data class DedicatedHostGroupArgs(
    public val allocationPolicy: Output<String>? = null,
    public val cpuAllocationRatio: Output<Int>? = null,
    public val dedicatedHostGroupDesc: Output<String>? = null,
    public val diskAllocationRatio: Output<Int>? = null,
    public val engine: Output<String>? = null,
    public val hostReplacePolicy: Output<String>? = null,
    public val memAllocationRatio: Output<Int>? = null,
    public val openPermission: Output<Boolean>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cddc.DedicatedHostGroupArgs> {
    override fun toJava(): com.pulumi.alicloud.cddc.DedicatedHostGroupArgs =
        com.pulumi.alicloud.cddc.DedicatedHostGroupArgs.builder()
            .allocationPolicy(allocationPolicy?.applyValue({ args0 -> args0 }))
            .cpuAllocationRatio(cpuAllocationRatio?.applyValue({ args0 -> args0 }))
            .dedicatedHostGroupDesc(dedicatedHostGroupDesc?.applyValue({ args0 -> args0 }))
            .diskAllocationRatio(diskAllocationRatio?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .hostReplacePolicy(hostReplacePolicy?.applyValue({ args0 -> args0 }))
            .memAllocationRatio(memAllocationRatio?.applyValue({ args0 -> args0 }))
            .openPermission(openPermission?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedHostGroupArgs].
 */
@PulumiTagMarker
public class DedicatedHostGroupArgsBuilder internal constructor() {
    private var allocationPolicy: Output<String>? = null

    private var cpuAllocationRatio: Output<Int>? = null

    private var dedicatedHostGroupDesc: Output<String>? = null

    private var diskAllocationRatio: Output<Int>? = null

    private var engine: Output<String>? = null

    private var hostReplacePolicy: Output<String>? = null

    private var memAllocationRatio: Output<Int>? = null

    private var openPermission: Output<Boolean>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value AThe policy that is used to allocate resources in the dedicated cluster. Valid values:`Evenly`,`Intensively`
     */
    @JvmName("ldcittelqlhngsub")
    public suspend fun allocationPolicy(`value`: Output<String>) {
        this.allocationPolicy = value
    }

    /**
     * @param value The CPU overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
     */
    @JvmName("alynaswkixemiikn")
    public suspend fun cpuAllocationRatio(`value`: Output<Int>) {
        this.cpuAllocationRatio = value
    }

    /**
     * @param value The name of the dedicated cluster. The name must be 1 to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
     */
    @JvmName("pqcmdgjvkyfgqdeo")
    public suspend fun dedicatedHostGroupDesc(`value`: Output<String>) {
        this.dedicatedHostGroupDesc = value
    }

    /**
     * @param value The Disk Allocation Ratio of the Dedicated Host Group. **NOTE:** When `engine = SQLServer`, this attribute does not support to set.
     */
    @JvmName("xosaeilksbqhpfmk")
    public suspend fun diskAllocationRatio(`value`: Output<Int>) {
        this.diskAllocationRatio = value
    }

    /**
     * @param value Database Engine Type.The database engine of the dedicated cluster. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`, `alisql`, `tair`, `mssql`. **NOTE:** Since v1.210.0., the `engine = SQLServer` was deprecated.
     */
    @JvmName("oirlkbujvlxasshd")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The policy based on which the system handles host failures. Valid values:`Auto`,`Manual`
     */
    @JvmName("vfwwwvxjvodjhwkp")
    public suspend fun hostReplacePolicy(`value`: Output<String>) {
        this.hostReplacePolicy = value
    }

    /**
     * @param value The Memory Allocation Ratio of the Dedicated Host Group.
     */
    @JvmName("xpaxkyfhofybqyko")
    public suspend fun memAllocationRatio(`value`: Output<Int>) {
        this.memAllocationRatio = value
    }

    /**
     * @param value Whether to enable the feature that allows you to have OS permissions on the hosts in the dedicated cluster. Valid values: `true` and `false`.
     * **NOTE:** The `open_permission` should be `true` when `engine = "SQLServer"`
     */
    @JvmName("mnxcwvwlclpsplwb")
    public suspend fun openPermission(`value`: Output<Boolean>) {
        this.openPermission = value
    }

    /**
     * @param value The virtual private cloud (VPC) ID of the dedicated cluster.
     */
    @JvmName("upkmvaslctkjtwbu")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value AThe policy that is used to allocate resources in the dedicated cluster. Valid values:`Evenly`,`Intensively`
     */
    @JvmName("hhnbnpsfnsipgxgf")
    public suspend fun allocationPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allocationPolicy = mapped
    }

    /**
     * @param value The CPU overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
     */
    @JvmName("jgljskroycaqoowc")
    public suspend fun cpuAllocationRatio(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuAllocationRatio = mapped
    }

    /**
     * @param value The name of the dedicated cluster. The name must be 1 to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
     */
    @JvmName("kxgrirowoyaupdlr")
    public suspend fun dedicatedHostGroupDesc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostGroupDesc = mapped
    }

    /**
     * @param value The Disk Allocation Ratio of the Dedicated Host Group. **NOTE:** When `engine = SQLServer`, this attribute does not support to set.
     */
    @JvmName("mbcxmrxsksswarck")
    public suspend fun diskAllocationRatio(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskAllocationRatio = mapped
    }

    /**
     * @param value Database Engine Type.The database engine of the dedicated cluster. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`, `alisql`, `tair`, `mssql`. **NOTE:** Since v1.210.0., the `engine = SQLServer` was deprecated.
     */
    @JvmName("yqclsnmhxyraudnn")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The policy based on which the system handles host failures. Valid values:`Auto`,`Manual`
     */
    @JvmName("dyorkrxrpignmihn")
    public suspend fun hostReplacePolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostReplacePolicy = mapped
    }

    /**
     * @param value The Memory Allocation Ratio of the Dedicated Host Group.
     */
    @JvmName("kbttshcjejaydksr")
    public suspend fun memAllocationRatio(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memAllocationRatio = mapped
    }

    /**
     * @param value Whether to enable the feature that allows you to have OS permissions on the hosts in the dedicated cluster. Valid values: `true` and `false`.
     * **NOTE:** The `open_permission` should be `true` when `engine = "SQLServer"`
     */
    @JvmName("osdktwpaymravaws")
    public suspend fun openPermission(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.openPermission = mapped
    }

    /**
     * @param value The virtual private cloud (VPC) ID of the dedicated cluster.
     */
    @JvmName("dpvarbxfrfytxcrk")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): DedicatedHostGroupArgs = DedicatedHostGroupArgs(
        allocationPolicy = allocationPolicy,
        cpuAllocationRatio = cpuAllocationRatio,
        dedicatedHostGroupDesc = dedicatedHostGroupDesc,
        diskAllocationRatio = diskAllocationRatio,
        engine = engine,
        hostReplacePolicy = hostReplacePolicy,
        memAllocationRatio = memAllocationRatio,
        openPermission = openPermission,
        vpcId = vpcId,
    )
}
