@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin

import com.pulumi.alicloud.cddc.kotlin.outputs.DedicatedPropreHostEcsClassList
import com.pulumi.alicloud.cddc.kotlin.outputs.DedicatedPropreHostEcsClassList.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DedicatedPropreHost].
 */
@PulumiTagMarker
public class DedicatedPropreHostResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedPropreHostArgs = DedicatedPropreHostArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedPropreHostArgsBuilder.() -> Unit) {
        val builder = DedicatedPropreHostArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedPropreHost {
        val builtJavaResource = com.pulumi.alicloud.cddc.DedicatedPropreHost(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DedicatedPropreHost(builtJavaResource)
    }
}

/**
 *
 * ## Import
 * CDDC Dedicated Propre Host can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cddc/dedicatedPropreHost:DedicatedPropreHost example <dedicated_host_group_id>:<ecs_instance_id>
 * ```
 */
public class DedicatedPropreHost internal constructor(
    override val javaResource: com.pulumi.alicloud.cddc.DedicatedPropreHost,
) : KotlinCustomResource(javaResource, DedicatedPropreHostMapper) {
    /**
     * Whether to pay automatically when the host is created.
     */
    public val autoPay: Output<Boolean>?
        get() = javaResource.autoPay().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to enable automatic renewal. Valid values:
     * - **true**: On
     * - **false** (default): Off
     */
    public val autoRenew: Output<String>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * You have a dedicated cluster ID.
     */
    public val dedicatedHostGroupId: Output<String>
        get() = javaResource.dedicatedHostGroupId().applyValue({ args0 -> args0 })

    /**
     * ECS specifications. See `ecs_class_list` below.
     */
    public val ecsClassLists: Output<List<DedicatedPropreHostEcsClassList>>
        get() = javaResource.ecsClassLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * The ID of the cloud server deployment set.
     */
    public val ecsDeploymentSetId: Output<String>?
        get() = javaResource.ecsDeploymentSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers. Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
     */
    public val ecsHostName: Output<String>?
        get() = javaResource.ecsHostName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ECS instance ID.
     */
    public val ecsInstanceId: Output<String>
        get() = javaResource.ecsInstanceId().applyValue({ args0 -> args0 })

    /**
     * The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
     */
    public val ecsInstanceName: Output<String>?
        get() = javaResource.ecsInstanceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
     * - **true**: added.
     * - **false** (default): Do not add.
     * When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
     */
    public val ecsUniqueSuffix: Output<String>?
        get() = javaResource.ecsUniqueSuffix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the zone.
     */
    public val ecsZoneId: Output<String>
        get() = javaResource.ecsZoneId().applyValue({ args0 -> args0 })

    /**
     * Database type, value:
     * - **alisql**
     * - **tair**
     * - **mssql**
     * Must be consistent with the parent resource cluster engine attributes.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The ID of the custom image.
     * > **NOTE:**  If you need to use the default image, you do not need to fill it in.
     */
    public val imageId: Output<String>?
        get() = javaResource.imageId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Network billing type. Value range: PayByBandwidth: Billing based on fixed bandwidth. PayByTraffic: charges by using the flow meter.
     */
    public val internetChargeType: Output<String>?
        get() = javaResource.internetChargeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum outbound bandwidth of the public network, in Mbit/s. Value range: 0~100.  Default value: 0. When set to greater than 0, a public IP is automatically created.
     */
    public val internetMaxBandwidthOut: Output<Int>?
        get() = javaResource.internetMaxBandwidthOut().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The key pair name.
     */
    public val keyPairName: Output<String>?
        get() = javaResource.keyPairName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Host login password, which can be set later. The password must meet the following requirements:
     * - Length is 8~30 characters.
     * - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
     * - Special symbol '()\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
     * > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
     */
    public val osPassword: Output<String>?
        get() = javaResource.osPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to use the default password of the image.
     * - **false**: (default)Do not use
     * - **true**: Use
     * > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
     */
    public val passwordInherit: Output<String>?
        get() = javaResource.passwordInherit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Payment type. Currently, only **Subscription** is supported.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Duration of purchase.
     */
    public val period: Output<String>?
        get() = javaResource.period().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The subscription type. Currently, only **Monthly** (subscription) is supported.
     */
    public val periodType: Output<String>?
        get() = javaResource.periodType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * The ID of the security group.
     */
    public val securityGroupId: Output<String>
        get() = javaResource.securityGroupId().applyValue({ args0 -> args0 })

    /**
     * Host tag information.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * User-defined script data. The maximum size of the original data is 16kB.
     */
    public val userData: Output<String>?
        get() = javaResource.userData().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether custom data is encoded in Base64 format.
     */
    public val userDataEncoded: Output<Boolean>?
        get() = javaResource.userDataEncoded().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * VPCID of the VPC.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The ID of the virtual switch.
     */
    public val vswitchId: Output<String>
        get() = javaResource.vswitchId().applyValue({ args0 -> args0 })
}

public object DedicatedPropreHostMapper : ResourceMapper<DedicatedPropreHost> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cddc.DedicatedPropreHost::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedPropreHost = DedicatedPropreHost(
        javaResource
            as com.pulumi.alicloud.cddc.DedicatedPropreHost,
    )
}

/**
 * @see [DedicatedPropreHost].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedPropreHost].
 */
public suspend fun dedicatedPropreHost(
    name: String,
    block: suspend DedicatedPropreHostResourceBuilder.() -> Unit,
): DedicatedPropreHost {
    val builder = DedicatedPropreHostResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedPropreHost].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedPropreHost(name: String): DedicatedPropreHost {
    val builder = DedicatedPropreHostResourceBuilder()
    builder.name(name)
    return builder.build()
}
