@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin

import com.pulumi.alicloud.cddc.DedicatedPropreHostArgs.builder
import com.pulumi.alicloud.cddc.kotlin.inputs.DedicatedPropreHostEcsClassListArgs
import com.pulumi.alicloud.cddc.kotlin.inputs.DedicatedPropreHostEcsClassListArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * ## Import
 * CDDC Dedicated Propre Host can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cddc/dedicatedPropreHost:DedicatedPropreHost example <dedicated_host_group_id>:<ecs_instance_id>
 * ```
 * @property autoPay Whether to pay automatically when the host is created.
 * @property autoRenew Whether to enable automatic renewal. Valid values:
 * - **true**: On
 * - **false** (default): Off
 * @property dedicatedHostGroupId You have a dedicated cluster ID.
 * @property ecsClassLists ECS specifications. See `ecs_class_list` below.
 * @property ecsDeploymentSetId The ID of the cloud server deployment set.
 * @property ecsHostName Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers. Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
 * @property ecsInstanceName The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
 * @property ecsUniqueSuffix Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
 * - **true**: added.
 * - **false** (default): Do not add.
 * When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
 * @property ecsZoneId The ID of the zone.
 * @property engine Database type, value:
 * - **alisql**
 * - **tair**
 * - **mssql**
 * Must be consistent with the parent resource cluster engine attributes.
 * @property imageId The ID of the custom image.
 * > **NOTE:**  If you need to use the default image, you do not need to fill it in.
 * @property internetChargeType Network billing type. Value range: PayByBandwidth: Billing based on fixed bandwidth. PayByTraffic: charges by using the flow meter.
 * @property internetMaxBandwidthOut The maximum outbound bandwidth of the public network, in Mbit/s. Value range: 0~100.  Default value: 0. When set to greater than 0, a public IP is automatically created.
 * @property keyPairName The key pair name.
 * @property osPassword Host login password, which can be set later. The password must meet the following requirements:
 * - Length is 8~30 characters.
 * - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
 * - Special symbol '()\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
 * > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
 * @property passwordInherit Whether to use the default password of the image.
 * - **false**: (default)Do not use
 * - **true**: Use
 * > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
 * @property paymentType The Payment type. Currently, only **Subscription** is supported.
 * @property period Duration of purchase.
 * @property periodType The subscription type. Currently, only **Monthly** (subscription) is supported.
 * @property resourceGroupId The ID of the resource group.
 * @property securityGroupId The ID of the security group.
 * @property tags Host tag information.
 * @property userData User-defined script data. The maximum size of the original data is 16kB.
 * @property userDataEncoded Whether custom data is encoded in Base64 format.
 * @property vpcId VPCID of the VPC.
 * @property vswitchId The ID of the virtual switch.
 */
public data class DedicatedPropreHostArgs(
    public val autoPay: Output<Boolean>? = null,
    public val autoRenew: Output<String>? = null,
    public val dedicatedHostGroupId: Output<String>? = null,
    public val ecsClassLists: Output<List<DedicatedPropreHostEcsClassListArgs>>? = null,
    public val ecsDeploymentSetId: Output<String>? = null,
    public val ecsHostName: Output<String>? = null,
    public val ecsInstanceName: Output<String>? = null,
    public val ecsUniqueSuffix: Output<String>? = null,
    public val ecsZoneId: Output<String>? = null,
    public val engine: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val internetChargeType: Output<String>? = null,
    public val internetMaxBandwidthOut: Output<Int>? = null,
    public val keyPairName: Output<String>? = null,
    public val osPassword: Output<String>? = null,
    public val passwordInherit: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<String>? = null,
    public val periodType: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val securityGroupId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userData: Output<String>? = null,
    public val userDataEncoded: Output<Boolean>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cddc.DedicatedPropreHostArgs> {
    override fun toJava(): com.pulumi.alicloud.cddc.DedicatedPropreHostArgs =
        com.pulumi.alicloud.cddc.DedicatedPropreHostArgs.builder()
            .autoPay(autoPay?.applyValue({ args0 -> args0 }))
            .autoRenew(autoRenew?.applyValue({ args0 -> args0 }))
            .dedicatedHostGroupId(dedicatedHostGroupId?.applyValue({ args0 -> args0 }))
            .ecsClassLists(
                ecsClassLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ecsDeploymentSetId(ecsDeploymentSetId?.applyValue({ args0 -> args0 }))
            .ecsHostName(ecsHostName?.applyValue({ args0 -> args0 }))
            .ecsInstanceName(ecsInstanceName?.applyValue({ args0 -> args0 }))
            .ecsUniqueSuffix(ecsUniqueSuffix?.applyValue({ args0 -> args0 }))
            .ecsZoneId(ecsZoneId?.applyValue({ args0 -> args0 }))
            .engine(engine?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .internetChargeType(internetChargeType?.applyValue({ args0 -> args0 }))
            .internetMaxBandwidthOut(internetMaxBandwidthOut?.applyValue({ args0 -> args0 }))
            .keyPairName(keyPairName?.applyValue({ args0 -> args0 }))
            .osPassword(osPassword?.applyValue({ args0 -> args0 }))
            .passwordInherit(passwordInherit?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .periodType(periodType?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userData(userData?.applyValue({ args0 -> args0 }))
            .userDataEncoded(userDataEncoded?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchId(vswitchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedPropreHostArgs].
 */
@PulumiTagMarker
public class DedicatedPropreHostArgsBuilder internal constructor() {
    private var autoPay: Output<Boolean>? = null

    private var autoRenew: Output<String>? = null

    private var dedicatedHostGroupId: Output<String>? = null

    private var ecsClassLists: Output<List<DedicatedPropreHostEcsClassListArgs>>? = null

    private var ecsDeploymentSetId: Output<String>? = null

    private var ecsHostName: Output<String>? = null

    private var ecsInstanceName: Output<String>? = null

    private var ecsUniqueSuffix: Output<String>? = null

    private var ecsZoneId: Output<String>? = null

    private var engine: Output<String>? = null

    private var imageId: Output<String>? = null

    private var internetChargeType: Output<String>? = null

    private var internetMaxBandwidthOut: Output<Int>? = null

    private var keyPairName: Output<String>? = null

    private var osPassword: Output<String>? = null

    private var passwordInherit: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<String>? = null

    private var periodType: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var securityGroupId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userData: Output<String>? = null

    private var userDataEncoded: Output<Boolean>? = null

    private var vpcId: Output<String>? = null

    private var vswitchId: Output<String>? = null

    /**
     * @param value Whether to pay automatically when the host is created.
     */
    @JvmName("kqfsudsgacmrykto")
    public suspend fun autoPay(`value`: Output<Boolean>) {
        this.autoPay = value
    }

    /**
     * @param value Whether to enable automatic renewal. Valid values:
     * - **true**: On
     * - **false** (default): Off
     */
    @JvmName("xsbpdbfwhtgosdmu")
    public suspend fun autoRenew(`value`: Output<String>) {
        this.autoRenew = value
    }

    /**
     * @param value You have a dedicated cluster ID.
     */
    @JvmName("yuytpltwnxlesluk")
    public suspend fun dedicatedHostGroupId(`value`: Output<String>) {
        this.dedicatedHostGroupId = value
    }

    /**
     * @param value ECS specifications. See `ecs_class_list` below.
     */
    @JvmName("jusxtfnoltjtueqh")
    public suspend fun ecsClassLists(`value`: Output<List<DedicatedPropreHostEcsClassListArgs>>) {
        this.ecsClassLists = value
    }

    @JvmName("jsdbqxbbwojvefhh")
    public suspend fun ecsClassLists(vararg values: Output<DedicatedPropreHostEcsClassListArgs>) {
        this.ecsClassLists = Output.all(values.asList())
    }

    /**
     * @param values ECS specifications. See `ecs_class_list` below.
     */
    @JvmName("gwxjeyragvqerohm")
    public suspend fun ecsClassLists(values: List<Output<DedicatedPropreHostEcsClassListArgs>>) {
        this.ecsClassLists = Output.all(values)
    }

    /**
     * @param value The ID of the cloud server deployment set.
     */
    @JvmName("iwttvuwfdkelsptl")
    public suspend fun ecsDeploymentSetId(`value`: Output<String>) {
        this.ecsDeploymentSetId = value
    }

    /**
     * @param value Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers. Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
     */
    @JvmName("ivnwdqpncsrwgybb")
    public suspend fun ecsHostName(`value`: Output<String>) {
        this.ecsHostName = value
    }

    /**
     * @param value The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
     */
    @JvmName("difogcwxfyscwkav")
    public suspend fun ecsInstanceName(`value`: Output<String>) {
        this.ecsInstanceName = value
    }

    /**
     * @param value Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
     * - **true**: added.
     * - **false** (default): Do not add.
     * When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
     */
    @JvmName("dhhcfvnukgklcwah")
    public suspend fun ecsUniqueSuffix(`value`: Output<String>) {
        this.ecsUniqueSuffix = value
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("qivxdxrlurbxtxei")
    public suspend fun ecsZoneId(`value`: Output<String>) {
        this.ecsZoneId = value
    }

    /**
     * @param value Database type, value:
     * - **alisql**
     * - **tair**
     * - **mssql**
     * Must be consistent with the parent resource cluster engine attributes.
     */
    @JvmName("pwukneusnonudhgo")
    public suspend fun engine(`value`: Output<String>) {
        this.engine = value
    }

    /**
     * @param value The ID of the custom image.
     * > **NOTE:**  If you need to use the default image, you do not need to fill it in.
     */
    @JvmName("yrgvderlgpwhshfa")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Network billing type. Value range: PayByBandwidth: Billing based on fixed bandwidth. PayByTraffic: charges by using the flow meter.
     */
    @JvmName("owrbtsjdcdrhpvfh")
    public suspend fun internetChargeType(`value`: Output<String>) {
        this.internetChargeType = value
    }

    /**
     * @param value The maximum outbound bandwidth of the public network, in Mbit/s. Value range: 0~100.  Default value: 0. When set to greater than 0, a public IP is automatically created.
     */
    @JvmName("kaxmmdbyligrywrg")
    public suspend fun internetMaxBandwidthOut(`value`: Output<Int>) {
        this.internetMaxBandwidthOut = value
    }

    /**
     * @param value The key pair name.
     */
    @JvmName("xweeiludwvkwqqiy")
    public suspend fun keyPairName(`value`: Output<String>) {
        this.keyPairName = value
    }

    /**
     * @param value Host login password, which can be set later. The password must meet the following requirements:
     * - Length is 8~30 characters.
     * - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
     * - Special symbol '()\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
     * > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
     */
    @JvmName("edseltpuasdwwkhx")
    public suspend fun osPassword(`value`: Output<String>) {
        this.osPassword = value
    }

    /**
     * @param value Whether to use the default password of the image.
     * - **false**: (default)Do not use
     * - **true**: Use
     * > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
     */
    @JvmName("bstdfdchkplsgvkh")
    public suspend fun passwordInherit(`value`: Output<String>) {
        this.passwordInherit = value
    }

    /**
     * @param value The Payment type. Currently, only **Subscription** is supported.
     */
    @JvmName("koonuvyjbqovadqh")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Duration of purchase.
     */
    @JvmName("ydxslxvcijfxwgvs")
    public suspend fun period(`value`: Output<String>) {
        this.period = value
    }

    /**
     * @param value The subscription type. Currently, only **Monthly** (subscription) is supported.
     */
    @JvmName("ogvnpviavsdomokl")
    public suspend fun periodType(`value`: Output<String>) {
        this.periodType = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("vbwlrwwgfxjyiuax")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("xshkpmfnbmwacoud")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value Host tag information.
     */
    @JvmName("vsbwimvcxjleecfs")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value User-defined script data. The maximum size of the original data is 16kB.
     */
    @JvmName("vvchqlukwvswqgeu")
    public suspend fun userData(`value`: Output<String>) {
        this.userData = value
    }

    /**
     * @param value Whether custom data is encoded in Base64 format.
     */
    @JvmName("wtiotksyloyscxvd")
    public suspend fun userDataEncoded(`value`: Output<Boolean>) {
        this.userDataEncoded = value
    }

    /**
     * @param value VPCID of the VPC.
     */
    @JvmName("ydrmbvyhosflhoux")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the virtual switch.
     */
    @JvmName("dlvwthqdvryanmyk")
    public suspend fun vswitchId(`value`: Output<String>) {
        this.vswitchId = value
    }

    /**
     * @param value Whether to pay automatically when the host is created.
     */
    @JvmName("hnsrihynoopcvlap")
    public suspend fun autoPay(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPay = mapped
    }

    /**
     * @param value Whether to enable automatic renewal. Valid values:
     * - **true**: On
     * - **false** (default): Off
     */
    @JvmName("buhjjrprtvvlopaw")
    public suspend fun autoRenew(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoRenew = mapped
    }

    /**
     * @param value You have a dedicated cluster ID.
     */
    @JvmName("tswvtrloqnmplvdm")
    public suspend fun dedicatedHostGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dedicatedHostGroupId = mapped
    }

    /**
     * @param value ECS specifications. See `ecs_class_list` below.
     */
    @JvmName("kaojyipsdcqtcjjo")
    public suspend fun ecsClassLists(`value`: List<DedicatedPropreHostEcsClassListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsClassLists = mapped
    }

    /**
     * @param argument ECS specifications. See `ecs_class_list` below.
     */
    @JvmName("pcfpedfkjtvxvsny")
    public suspend fun ecsClassLists(argument: List<suspend DedicatedPropreHostEcsClassListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DedicatedPropreHostEcsClassListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ecsClassLists = mapped
    }

    /**
     * @param argument ECS specifications. See `ecs_class_list` below.
     */
    @JvmName("gquaqjcdkujtftxy")
    public suspend fun ecsClassLists(vararg argument: suspend DedicatedPropreHostEcsClassListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DedicatedPropreHostEcsClassListArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ecsClassLists = mapped
    }

    /**
     * @param argument ECS specifications. See `ecs_class_list` below.
     */
    @JvmName("nfvmqwfmnwmtncwi")
    public suspend fun ecsClassLists(argument: suspend DedicatedPropreHostEcsClassListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DedicatedPropreHostEcsClassListArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ecsClassLists = mapped
    }

    /**
     * @param values ECS specifications. See `ecs_class_list` below.
     */
    @JvmName("tpyutepjfvwvaibs")
    public suspend fun ecsClassLists(vararg values: DedicatedPropreHostEcsClassListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ecsClassLists = mapped
    }

    /**
     * @param value The ID of the cloud server deployment set.
     */
    @JvmName("kcghfmyocmlhpnki")
    public suspend fun ecsDeploymentSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsDeploymentSetId = mapped
    }

    /**
     * @param value Windows system: length of 2 to 15 characters, allowing the use of upper and lower case letters, numbers. You cannot use only numbers. Other operating systems (such as Linux): the length of 2 to 64 characters, allowing the use of dot (.) to separate characters into multiple segments, each segment allows the use of upper and lower case letters, numbers, but can not use continuous dot (.). Cannot start or end with a dot (.).
     */
    @JvmName("xlcyxcubxvmjylqq")
    public suspend fun ecsHostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsHostName = mapped
    }

    /**
     * @param value The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. Can contain Chinese, English, numbers, half-width colons (:), underscores (_), half-width periods (.), or dashes (-). The default value is the InstanceId of the instance.
     */
    @JvmName("hrhxlocswltkvcvv")
    public suspend fun ecsInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsInstanceName = mapped
    }

    /**
     * @param value Whether to automatically add an ordered suffix for HostName and InstanceName when creating multiple instances. The ordered suffix starts from 001 and cannot exceed 999. Value Description:
     * - **true**: added.
     * - **false** (default): Do not add.
     * When the HostName or InstanceName is set according to the specified sorting format, and the naming suffix name_suffix is not set, that is, when the naming format is name_prefix[begin_number,bits], the UniqueSuffix does not take effect, and the names are only sorted according to the specified order.
     */
    @JvmName("ohjlsvvlaqoxeyvk")
    public suspend fun ecsUniqueSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsUniqueSuffix = mapped
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("quvfsegmrqgelvlp")
    public suspend fun ecsZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecsZoneId = mapped
    }

    /**
     * @param value Database type, value:
     * - **alisql**
     * - **tair**
     * - **mssql**
     * Must be consistent with the parent resource cluster engine attributes.
     */
    @JvmName("exipcsooyvkjpgfd")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engine = mapped
    }

    /**
     * @param value The ID of the custom image.
     * > **NOTE:**  If you need to use the default image, you do not need to fill it in.
     */
    @JvmName("xevgwdfbpljgfwfv")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Network billing type. Value range: PayByBandwidth: Billing based on fixed bandwidth. PayByTraffic: charges by using the flow meter.
     */
    @JvmName("rjsfennaxuyicqcs")
    public suspend fun internetChargeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetChargeType = mapped
    }

    /**
     * @param value The maximum outbound bandwidth of the public network, in Mbit/s. Value range: 0~100.  Default value: 0. When set to greater than 0, a public IP is automatically created.
     */
    @JvmName("lqfkdrubdmnqesfj")
    public suspend fun internetMaxBandwidthOut(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.internetMaxBandwidthOut = mapped
    }

    /**
     * @param value The key pair name.
     */
    @JvmName("jqankikbtiynvtjv")
    public suspend fun keyPairName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPairName = mapped
    }

    /**
     * @param value Host login password, which can be set later. The password must meet the following requirements:
     * - Length is 8~30 characters.
     * - Must contain at least three items: uppercase letters, lowercase letters, numbers, and special characters.
     * - Special symbol '()\' ~! @#$%^& *-_+ =|{}[]:;',.? /'
     * > **NOTE:** - If you need to set the host login password later, fill in an empty string for this parameter. If you need to set a host login password, we recommend that you use the HTTPS protocol to send requests to avoid password leakage.
     */
    @JvmName("adtqihjxwudbodej")
    public suspend fun osPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osPassword = mapped
    }

    /**
     * @param value Whether to use the default password of the image.
     * - **false**: (default)Do not use
     * - **true**: Use
     * > **NOTE:**  If the default password of the image is used, the **OSPassword** parameter is not required.
     */
    @JvmName("fimhtytlushiurhk")
    public suspend fun passwordInherit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordInherit = mapped
    }

    /**
     * @param value The Payment type. Currently, only **Subscription** is supported.
     */
    @JvmName("gmmcyyaomfsfrqem")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Duration of purchase.
     */
    @JvmName("dddwqshvksdhaecn")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The subscription type. Currently, only **Monthly** (subscription) is supported.
     */
    @JvmName("tvbswtfxmdiqscse")
    public suspend fun periodType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodType = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("wwqmqyagdswgiukk")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The ID of the security group.
     */
    @JvmName("tthjqlcwjaphlqkb")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value Host tag information.
     */
    @JvmName("kpadsntsjcuadrcy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Host tag information.
     */
    @JvmName("sjwpwdjaaisoddho")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value User-defined script data. The maximum size of the original data is 16kB.
     */
    @JvmName("pswtlhawxengspub")
    public suspend fun userData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userData = mapped
    }

    /**
     * @param value Whether custom data is encoded in Base64 format.
     */
    @JvmName("ykbmffrqtmmlfxfa")
    public suspend fun userDataEncoded(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataEncoded = mapped
    }

    /**
     * @param value VPCID of the VPC.
     */
    @JvmName("lborwyexkndcrgpm")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value The ID of the virtual switch.
     */
    @JvmName("lbgknwuwpxjaqjoi")
    public suspend fun vswitchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchId = mapped
    }

    internal fun build(): DedicatedPropreHostArgs = DedicatedPropreHostArgs(
        autoPay = autoPay,
        autoRenew = autoRenew,
        dedicatedHostGroupId = dedicatedHostGroupId,
        ecsClassLists = ecsClassLists,
        ecsDeploymentSetId = ecsDeploymentSetId,
        ecsHostName = ecsHostName,
        ecsInstanceName = ecsInstanceName,
        ecsUniqueSuffix = ecsUniqueSuffix,
        ecsZoneId = ecsZoneId,
        engine = engine,
        imageId = imageId,
        internetChargeType = internetChargeType,
        internetMaxBandwidthOut = internetMaxBandwidthOut,
        keyPairName = keyPairName,
        osPassword = osPassword,
        passwordInherit = passwordInherit,
        paymentType = paymentType,
        period = period,
        periodType = periodType,
        resourceGroupId = resourceGroupId,
        securityGroupId = securityGroupId,
        tags = tags,
        userData = userData,
        userDataEncoded = userDataEncoded,
        vpcId = vpcId,
        vswitchId = vswitchId,
    )
}
