@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.inputs

import com.pulumi.alicloud.cddc.inputs.DedicatedPropreHostEcsClassListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataDiskPerformanceLevel Data disk PL level.
 * @property diskCapacity The capacity of the data disk.
 * @property diskCount Number of mounted data disks.
 * @property diskType Data disk type, value range:
 * - **cloud_essd**: the ESSD cloud disk.
 * - **cloud_ssd**: SSD cloud disk.
 * - **cloud_efficiency**: The ultra cloud disk.
 * - **cloud_auto**: ESSD AutoPL cloud disk.
 * @property instanceType ECS specifications.
 * @property sysDiskCapacity System disk capacity.
 * @property sysDiskType System disk type, value:
 * - **cloud_essd**: the ESSD cloud disk.
 * - **cloud_ssd**: SSD cloud disk.
 * - **cloud_efficiency**: The ultra cloud disk.
 * - **cloud_auto**: ESSD AutoPL cloud disk.
 * @property systemDiskPerformanceLevel System disk PL level.
 */
public data class DedicatedPropreHostEcsClassListArgs(
    public val dataDiskPerformanceLevel: Output<String>? = null,
    public val diskCapacity: Output<Int>? = null,
    public val diskCount: Output<Int>? = null,
    public val diskType: Output<String>? = null,
    public val instanceType: Output<String>,
    public val sysDiskCapacity: Output<Int>,
    public val sysDiskType: Output<String>,
    public val systemDiskPerformanceLevel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cddc.inputs.DedicatedPropreHostEcsClassListArgs> {
    override fun toJava(): com.pulumi.alicloud.cddc.inputs.DedicatedPropreHostEcsClassListArgs =
        com.pulumi.alicloud.cddc.inputs.DedicatedPropreHostEcsClassListArgs.builder()
            .dataDiskPerformanceLevel(dataDiskPerformanceLevel?.applyValue({ args0 -> args0 }))
            .diskCapacity(diskCapacity?.applyValue({ args0 -> args0 }))
            .diskCount(diskCount?.applyValue({ args0 -> args0 }))
            .diskType(diskType?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .sysDiskCapacity(sysDiskCapacity.applyValue({ args0 -> args0 }))
            .sysDiskType(sysDiskType.applyValue({ args0 -> args0 }))
            .systemDiskPerformanceLevel(systemDiskPerformanceLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DedicatedPropreHostEcsClassListArgs].
 */
@PulumiTagMarker
public class DedicatedPropreHostEcsClassListArgsBuilder internal constructor() {
    private var dataDiskPerformanceLevel: Output<String>? = null

    private var diskCapacity: Output<Int>? = null

    private var diskCount: Output<Int>? = null

    private var diskType: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var sysDiskCapacity: Output<Int>? = null

    private var sysDiskType: Output<String>? = null

    private var systemDiskPerformanceLevel: Output<String>? = null

    /**
     * @param value Data disk PL level.
     */
    @JvmName("xatpyrjhgudlswal")
    public suspend fun dataDiskPerformanceLevel(`value`: Output<String>) {
        this.dataDiskPerformanceLevel = value
    }

    /**
     * @param value The capacity of the data disk.
     */
    @JvmName("flmekildohncpjgk")
    public suspend fun diskCapacity(`value`: Output<Int>) {
        this.diskCapacity = value
    }

    /**
     * @param value Number of mounted data disks.
     */
    @JvmName("fpryoofqynvkqjcm")
    public suspend fun diskCount(`value`: Output<Int>) {
        this.diskCount = value
    }

    /**
     * @param value Data disk type, value range:
     * - **cloud_essd**: the ESSD cloud disk.
     * - **cloud_ssd**: SSD cloud disk.
     * - **cloud_efficiency**: The ultra cloud disk.
     * - **cloud_auto**: ESSD AutoPL cloud disk.
     */
    @JvmName("rkqabdutumchnkmw")
    public suspend fun diskType(`value`: Output<String>) {
        this.diskType = value
    }

    /**
     * @param value ECS specifications.
     */
    @JvmName("tnsmpcupbeumkofx")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value System disk capacity.
     */
    @JvmName("pyjnnvmbnjahpwqd")
    public suspend fun sysDiskCapacity(`value`: Output<Int>) {
        this.sysDiskCapacity = value
    }

    /**
     * @param value System disk type, value:
     * - **cloud_essd**: the ESSD cloud disk.
     * - **cloud_ssd**: SSD cloud disk.
     * - **cloud_efficiency**: The ultra cloud disk.
     * - **cloud_auto**: ESSD AutoPL cloud disk.
     */
    @JvmName("yqiqeennggkjuhri")
    public suspend fun sysDiskType(`value`: Output<String>) {
        this.sysDiskType = value
    }

    /**
     * @param value System disk PL level.
     */
    @JvmName("vltedwwsldrinfah")
    public suspend fun systemDiskPerformanceLevel(`value`: Output<String>) {
        this.systemDiskPerformanceLevel = value
    }

    /**
     * @param value Data disk PL level.
     */
    @JvmName("jcuuarjepxmpqber")
    public suspend fun dataDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskPerformanceLevel = mapped
    }

    /**
     * @param value The capacity of the data disk.
     */
    @JvmName("auttcnnavattwhis")
    public suspend fun diskCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCapacity = mapped
    }

    /**
     * @param value Number of mounted data disks.
     */
    @JvmName("tyuuynhwpbnyjobw")
    public suspend fun diskCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskCount = mapped
    }

    /**
     * @param value Data disk type, value range:
     * - **cloud_essd**: the ESSD cloud disk.
     * - **cloud_ssd**: SSD cloud disk.
     * - **cloud_efficiency**: The ultra cloud disk.
     * - **cloud_auto**: ESSD AutoPL cloud disk.
     */
    @JvmName("rjkexsesmqtxvxwu")
    public suspend fun diskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskType = mapped
    }

    /**
     * @param value ECS specifications.
     */
    @JvmName("vuddmwsfieymatom")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value System disk capacity.
     */
    @JvmName("tgsnrkgrhqujturc")
    public suspend fun sysDiskCapacity(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sysDiskCapacity = mapped
    }

    /**
     * @param value System disk type, value:
     * - **cloud_essd**: the ESSD cloud disk.
     * - **cloud_ssd**: SSD cloud disk.
     * - **cloud_efficiency**: The ultra cloud disk.
     * - **cloud_auto**: ESSD AutoPL cloud disk.
     */
    @JvmName("ljkpypgxnyhigfpu")
    public suspend fun sysDiskType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sysDiskType = mapped
    }

    /**
     * @param value System disk PL level.
     */
    @JvmName("mjrimadsplhwhyey")
    public suspend fun systemDiskPerformanceLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemDiskPerformanceLevel = mapped
    }

    internal fun build(): DedicatedPropreHostEcsClassListArgs = DedicatedPropreHostEcsClassListArgs(
        dataDiskPerformanceLevel = dataDiskPerformanceLevel,
        diskCapacity = diskCapacity,
        diskCount = diskCount,
        diskType = diskType,
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        sysDiskCapacity = sysDiskCapacity ?: throw PulumiNullFieldException("sysDiskCapacity"),
        sysDiskType = sysDiskType ?: throw PulumiNullFieldException("sysDiskType"),
        systemDiskPerformanceLevel = systemDiskPerformanceLevel,
    )
}
