@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.inputs

import com.pulumi.alicloud.cddc.inputs.GetDedicatedHostAccountsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDedicatedHostAccounts.
 * @property dedicatedHostId The ID of the host.
 * @property ids A list of Dedicated Host Account IDs.
 * @property nameRegex A regex string to filter results by Account name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetDedicatedHostAccountsPlainArgs(
    public val dedicatedHostId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cddc.inputs.GetDedicatedHostAccountsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cddc.inputs.GetDedicatedHostAccountsPlainArgs =
        com.pulumi.alicloud.cddc.inputs.GetDedicatedHostAccountsPlainArgs.builder()
            .dedicatedHostId(dedicatedHostId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedHostAccountsPlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedHostAccountsPlainArgsBuilder internal constructor() {
    private var dedicatedHostId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value The ID of the host.
     */
    @JvmName("hirhpwjvjuvxbhqu")
    public suspend fun dedicatedHostId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dedicatedHostId = mapped
    }

    /**
     * @param value A list of Dedicated Host Account IDs.
     */
    @JvmName("butnjbdhpagwgwiy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Dedicated Host Account IDs.
     */
    @JvmName("acyhgdxrohbytovj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Account name.
     */
    @JvmName("efxbekkvuymqodxh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ykwrdisrouvpkhjb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("iowjypbjuqfahjux")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("agxvluirbckktclj")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetDedicatedHostAccountsPlainArgs = GetDedicatedHostAccountsPlainArgs(
        dedicatedHostId = dedicatedHostId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
