@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.inputs

import com.pulumi.alicloud.cddc.inputs.GetDedicatedHostGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDedicatedHostGroups.
 * @property engine Database Engine Type. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`
 * @property ids A list of Dedicated Host Group IDs.
 * @property nameRegex A regex string to filter results by Dedicated Host Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetDedicatedHostGroupsPlainArgs(
    public val engine: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cddc.inputs.GetDedicatedHostGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cddc.inputs.GetDedicatedHostGroupsPlainArgs =
        com.pulumi.alicloud.cddc.inputs.GetDedicatedHostGroupsPlainArgs.builder()
            .engine(engine?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedHostGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedHostGroupsPlainArgsBuilder internal constructor() {
    private var engine: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value Database Engine Type. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`
     */
    @JvmName("xkbbmwmnebaeutua")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value A list of Dedicated Host Group IDs.
     */
    @JvmName("ohiyimkcamlhhkyo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Dedicated Host Group IDs.
     */
    @JvmName("lrpuwjlassowboll")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Dedicated Host Group name.
     */
    @JvmName("oexyfmlkpkdldqqg")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("kpserhocbhyclwvs")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetDedicatedHostGroupsPlainArgs = GetDedicatedHostGroupsPlainArgs(
        engine = engine,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
