@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.inputs

import com.pulumi.alicloud.cddc.inputs.GetDedicatedHostsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDedicatedHosts.
 * @property allocationStatus Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
 * @property dedicatedHostGroupId The ID of the dedicated cluster.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property hostType The storage type of the host. Valid values: `dhg_local_ssd` or `dhg_cloud_ssd`. `dhg_local_ssd`: specifies that the host uses local SSDs. `dhg_cloud_ssd`: specifies that the host uses enhanced SSDs (ESSDs).
 * @property ids A list of Dedicated Host IDs.
 * @property orderId The ID of the order.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The state of the host. Valid values:
 * * `0:` The host is being created.
 * @property tags A mapping of tags to assign to the resource.
 * @property zoneId The ID of the zone.
 */
public data class GetDedicatedHostsPlainArgs(
    public val allocationStatus: String? = null,
    public val dedicatedHostGroupId: String,
    public val enableDetails: Boolean? = null,
    public val hostType: String? = null,
    public val ids: List<String>? = null,
    public val orderId: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val zoneId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cddc.inputs.GetDedicatedHostsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cddc.inputs.GetDedicatedHostsPlainArgs =
        com.pulumi.alicloud.cddc.inputs.GetDedicatedHostsPlainArgs.builder()
            .allocationStatus(allocationStatus?.let({ args0 -> args0 }))
            .dedicatedHostGroupId(dedicatedHostGroupId.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .hostType(hostType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .orderId(orderId?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneId(zoneId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedHostsPlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedHostsPlainArgsBuilder internal constructor() {
    private var allocationStatus: String? = null

    private var dedicatedHostGroupId: String? = null

    private var enableDetails: Boolean? = null

    private var hostType: String? = null

    private var ids: List<String>? = null

    private var orderId: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var tags: Map<String, String>? = null

    private var zoneId: String? = null

    /**
     * @param value Specifies whether instances can be created on the host. Valid values: `Allocatable` or `Suspended`. `Allocatable`: Instances can be created on the host. `Suspended`: Instances cannot be created on the host.
     */
    @JvmName("rtmoqciwxvuefcrb")
    public suspend fun allocationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.allocationStatus = mapped
    }

    /**
     * @param value The ID of the dedicated cluster.
     */
    @JvmName("ixlaheypehimwade")
    public suspend fun dedicatedHostGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dedicatedHostGroupId = mapped
    }

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("dqalrjcvjhvgrpwt")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value The storage type of the host. Valid values: `dhg_local_ssd` or `dhg_cloud_ssd`. `dhg_local_ssd`: specifies that the host uses local SSDs. `dhg_cloud_ssd`: specifies that the host uses enhanced SSDs (ESSDs).
     */
    @JvmName("kyootfidowoqswha")
    public suspend fun hostType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostType = mapped
    }

    /**
     * @param value A list of Dedicated Host IDs.
     */
    @JvmName("gvvnmhivgwjbxskb")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Dedicated Host IDs.
     */
    @JvmName("cbodewjmllduwqgh")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of the order.
     */
    @JvmName("jblugoprwkahsfgs")
    public suspend fun orderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderId = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("koyurdrnfmskaeay")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The state of the host. Valid values:
     * * `0:` The host is being created.
     */
    @JvmName("kyqhuyqumqgtphrg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("kiljbsqahejwkink")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("slgcncwvityughim")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The ID of the zone.
     */
    @JvmName("efdtrdukhxlpafrb")
    public suspend fun zoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetDedicatedHostsPlainArgs = GetDedicatedHostsPlainArgs(
        allocationStatus = allocationStatus,
        dedicatedHostGroupId = dedicatedHostGroupId ?: throw
            PulumiNullFieldException("dedicatedHostGroupId"),
        enableDetails = enableDetails,
        hostType = hostType,
        ids = ids,
        orderId = orderId,
        outputFile = outputFile,
        status = status,
        tags = tags,
        zoneId = zoneId,
    )
}
