@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.inputs

import com.pulumi.alicloud.cddc.inputs.GetHostEcsLevelInfosPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHostEcsLevelInfos.
 * @property dbType The database engine of the host. Valid values: `mysql`, `mssql`, `pgsql`, `redis`.
 * @property imageCategory Host image. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property storageType The storage type of the host ecs level info. Valid values: `local_ssd`, `cloud_essd`, `cloud_essd2`, `cloud_essd3`.
 * @property zoneId The ID of the zone in the region.
 */
public data class GetHostEcsLevelInfosPlainArgs(
    public val dbType: String,
    public val imageCategory: String? = null,
    public val outputFile: String? = null,
    public val storageType: String,
    public val zoneId: String,
) : ConvertibleToJava<com.pulumi.alicloud.cddc.inputs.GetHostEcsLevelInfosPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cddc.inputs.GetHostEcsLevelInfosPlainArgs =
        com.pulumi.alicloud.cddc.inputs.GetHostEcsLevelInfosPlainArgs.builder()
            .dbType(dbType.let({ args0 -> args0 }))
            .imageCategory(imageCategory?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .storageType(storageType.let({ args0 -> args0 }))
            .zoneId(zoneId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHostEcsLevelInfosPlainArgs].
 */
@PulumiTagMarker
public class GetHostEcsLevelInfosPlainArgsBuilder internal constructor() {
    private var dbType: String? = null

    private var imageCategory: String? = null

    private var outputFile: String? = null

    private var storageType: String? = null

    private var zoneId: String? = null

    /**
     * @param value The database engine of the host. Valid values: `mysql`, `mssql`, `pgsql`, `redis`.
     */
    @JvmName("abfipeknwhsliwhd")
    public suspend fun dbType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbType = mapped
    }

    /**
     * @param value Host image. Valid values: `WindowsWithMssqlEntAlwaysonLicense`, `WindowsWithMssqlStdLicense`, `WindowsWithMssqlEntLicense`, `WindowsWithMssqlWebLicense`, `AliLinux`.
     */
    @JvmName("cnooltgmwuxqdcao")
    public suspend fun imageCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageCategory = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ashwmchqdtaifxak")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The storage type of the host ecs level info. Valid values: `local_ssd`, `cloud_essd`, `cloud_essd2`, `cloud_essd3`.
     */
    @JvmName("picymhxcjhydaqgu")
    public suspend fun storageType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageType = mapped
    }

    /**
     * @param value The ID of the zone in the region.
     */
    @JvmName("vvmiqufwyityseps")
    public suspend fun zoneId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.zoneId = mapped
    }

    internal fun build(): GetHostEcsLevelInfosPlainArgs = GetHostEcsLevelInfosPlainArgs(
        dbType = dbType ?: throw PulumiNullFieldException("dbType"),
        imageCategory = imageCategory,
        outputFile = outputFile,
        storageType = storageType ?: throw PulumiNullFieldException("storageType"),
        zoneId = zoneId ?: throw PulumiNullFieldException("zoneId"),
    )
}
