@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataDiskPerformanceLevel Data disk PL level.
 * @property diskCapacity The capacity of the data disk.
 * @property diskCount Number of mounted data disks.
 * @property diskType Data disk type, value range:
 * - **cloud_essd**: the ESSD cloud disk.
 * - **cloud_ssd**: SSD cloud disk.
 * - **cloud_efficiency**: The ultra cloud disk.
 * - **cloud_auto**: ESSD AutoPL cloud disk.
 * @property instanceType ECS specifications.
 * @property sysDiskCapacity System disk capacity.
 * @property sysDiskType System disk type, value:
 * - **cloud_essd**: the ESSD cloud disk.
 * - **cloud_ssd**: SSD cloud disk.
 * - **cloud_efficiency**: The ultra cloud disk.
 * - **cloud_auto**: ESSD AutoPL cloud disk.
 * @property systemDiskPerformanceLevel System disk PL level.
 */
public data class DedicatedPropreHostEcsClassList(
    public val dataDiskPerformanceLevel: String? = null,
    public val diskCapacity: Int? = null,
    public val diskCount: Int? = null,
    public val diskType: String? = null,
    public val instanceType: String,
    public val sysDiskCapacity: Int,
    public val sysDiskType: String,
    public val systemDiskPerformanceLevel: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cddc.outputs.DedicatedPropreHostEcsClassList): DedicatedPropreHostEcsClassList = DedicatedPropreHostEcsClassList(
            dataDiskPerformanceLevel = javaType.dataDiskPerformanceLevel().map({ args0 -> args0 }).orElse(null),
            diskCapacity = javaType.diskCapacity().map({ args0 -> args0 }).orElse(null),
            diskCount = javaType.diskCount().map({ args0 -> args0 }).orElse(null),
            diskType = javaType.diskType().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            sysDiskCapacity = javaType.sysDiskCapacity(),
            sysDiskType = javaType.sysDiskType(),
            systemDiskPerformanceLevel = javaType.systemDiskPerformanceLevel().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
