@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountName The name of the Dedicated host account.
 * @property dedicatedHostId The ID of the Dedicated host.
 * @property id The ID of the Dedicated Host Account. The value formats as `<dedicated_host_id>:<account_name>`.
 */
public data class GetDedicatedHostAccountsAccount(
    public val accountName: String,
    public val dedicatedHostId: String,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cddc.outputs.GetDedicatedHostAccountsAccount): GetDedicatedHostAccountsAccount = GetDedicatedHostAccountsAccount(
            accountName = javaType.accountName(),
            dedicatedHostId = javaType.dedicatedHostId(),
            id = javaType.id(),
        )
    }
}
