@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allocationPolicy The policy that is used to allocate resources in the dedicated cluster. Valid values:`Evenly`,`Intensively`
 * @property bastionInstanceId The Bastion Instance id of the Dedicated Host Group.
 * @property cpuAllocateRation The CPU overcommitment ratio of the dedicated cluster. If you set this parameter to 200, the CPU resources that can be allocated are twice as many as the CPU resources that are provided. This maximizes the CPU utilization. Valid values: 100 to 300. Default value: 200.
 * @property cpuAllocatedAmount The CPU Allocated Amount of the Dedicated Host Group.
 * @property cpuAllocationRatio The CPU overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
 * @property createTime The Created Time of the Dedicated Host Group.
 * @property dedicatedHostCountGroupByHostTypes The Dedicated Host Count Group by Host Type of the Dedicated Host Group.
 * @property dedicatedHostGroupDesc The name of the dedicated cluster. The name must be 1 to 64 characters in length and can contain letters, digits, underscores (_), and hyphens (-). It must start with a letter.
 * @property dedicatedHostGroupId Dedicated Host Group ID.
 * @property deployType The Deployment Type of the Dedicated Host Group.
 * @property diskAllocateRation The storage overcommitment ratio of the dedicated cluster.Valid values: 100 to 300. Default value: 200.
 * @property diskAllocatedAmount The Disk Allocated Amount of the Dedicated Host Group.
 * @property diskAllocationRatio The Disk Allocation Ratio of the Dedicated Host Group.
 * @property diskUsedAmount The DiskUsedAmount of the Dedicated Host Group.
 * @property diskUtility The DiskUtility of the Dedicated Host Group.
 * @property engine Database Engine Type.The database engine of the dedicated cluster. Valid values:`Redis`, `SQLServer`, `MySQL`, `PostgreSQL`, `MongoDB`
 * @property hostNumber The Total Host Number  of the Dedicated Host Group.
 * @property hostReplacePolicy The policy based on which the system handles host failures. Valid values:`Auto`,`Manual`
 * @property id The ID of the Dedicated Host Group.
 * @property instanceNumber The Total Instance Number of the Dedicated Host Group.
 * @property memAllocateRation The maximum memory usage of each host in the dedicated cluster.Valid values: 0 to 90. Default value: 90.
 * @property memAllocatedAmount The MemAllocatedAmount of the Dedicated Host Group.
 * @property memAllocationRatio The Memory Allocation Ratio of the Dedicated Host Group.
 * @property memUsedAmount The MemUsedAmount of the Dedicated Host Group.
 * @property memUtility The Mem Utility of the Dedicated Host Group.
 * @property text The Text of the Dedicated Host Group.
 * @property vpcId The virtual private cloud (VPC) ID of the dedicated cluster.
 * @property zoneIdLists The ZoneIDList of the Dedicated Host Group.
 */
public data class GetDedicatedHostGroupsGroup(
    public val allocationPolicy: String,
    public val bastionInstanceId: String,
    public val cpuAllocateRation: Double,
    public val cpuAllocatedAmount: Double,
    public val cpuAllocationRatio: Int,
    public val createTime: String,
    public val dedicatedHostCountGroupByHostTypes: List<GetDedicatedHostGroupsGroupDedicatedHostCountGroupByHostType>,
    public val dedicatedHostGroupDesc: String,
    public val dedicatedHostGroupId: String,
    public val deployType: String,
    public val diskAllocateRation: Double,
    public val diskAllocatedAmount: Double,
    public val diskAllocationRatio: Int,
    public val diskUsedAmount: Double,
    public val diskUtility: Double,
    public val engine: String,
    public val hostNumber: Int,
    public val hostReplacePolicy: String,
    public val id: String,
    public val instanceNumber: Int,
    public val memAllocateRation: Double,
    public val memAllocatedAmount: Double,
    public val memAllocationRatio: Int,
    public val memUsedAmount: Double,
    public val memUtility: Double,
    public val text: String,
    public val vpcId: String,
    public val zoneIdLists: List<GetDedicatedHostGroupsGroupZoneIdList>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cddc.outputs.GetDedicatedHostGroupsGroup): GetDedicatedHostGroupsGroup = GetDedicatedHostGroupsGroup(
            allocationPolicy = javaType.allocationPolicy(),
            bastionInstanceId = javaType.bastionInstanceId(),
            cpuAllocateRation = javaType.cpuAllocateRation(),
            cpuAllocatedAmount = javaType.cpuAllocatedAmount(),
            cpuAllocationRatio = javaType.cpuAllocationRatio(),
            createTime = javaType.createTime(),
            dedicatedHostCountGroupByHostTypes = javaType.dedicatedHostCountGroupByHostTypes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cddc.kotlin.outputs.GetDedicatedHostGroupsGroupDedicatedHostCountGroupByHostType.Companion.toKotlin(args0)
                })
            }),
            dedicatedHostGroupDesc = javaType.dedicatedHostGroupDesc(),
            dedicatedHostGroupId = javaType.dedicatedHostGroupId(),
            deployType = javaType.deployType(),
            diskAllocateRation = javaType.diskAllocateRation(),
            diskAllocatedAmount = javaType.diskAllocatedAmount(),
            diskAllocationRatio = javaType.diskAllocationRatio(),
            diskUsedAmount = javaType.diskUsedAmount(),
            diskUtility = javaType.diskUtility(),
            engine = javaType.engine(),
            hostNumber = javaType.hostNumber(),
            hostReplacePolicy = javaType.hostReplacePolicy(),
            id = javaType.id(),
            instanceNumber = javaType.instanceNumber(),
            memAllocateRation = javaType.memAllocateRation(),
            memAllocatedAmount = javaType.memAllocatedAmount(),
            memAllocationRatio = javaType.memAllocationRatio(),
            memUsedAmount = javaType.memUsedAmount(),
            memUtility = javaType.memUtility(),
            text = javaType.text(),
            vpcId = javaType.vpcId(),
            zoneIdLists = javaType.zoneIdLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cddc.kotlin.outputs.GetDedicatedHostGroupsGroupZoneIdList.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
