@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property allocationStatus Specifies whether instances can be created on the host. Valid values: `1` or `0`. `1`: Instances can be created on the host. `0`: Instances cannot be created on the host.
 * @property bastionInstanceId The ID of the bastion host with which the host is associated.
 * @property cpuAllocationRatio The numeric value of the CPU over commit ratio of the dedicated cluster.
 * @property cpuUsed The number of CPU cores used by the host.
 * @property createTime The time when the host was created. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
 * @property dedicatedHostGroupId The ID of the dedicated cluster in which the host is created.
 * @property dedicatedHostId The ID of the host.
 * @property diskAllocationRatio The disk usage in percentage.
 * @property ecsClassCode The Elastic Compute Service (ECS) instance type.
 * @property endTime The time when the host expires. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
 * @property engine The type of the database engine that is used by the host.
 * @property expiredTime The time when the host expires. The time follows the ISO 8601 standard in the `yyyy-MM-ddTHH:mm:ssZ` format. The time is displayed in UTC.
 * @property hostClass The instance type of the host.
 * @property hostCpu The number of CPU cores specified for the host. Unit: `core`.
 * @property hostMem The memory of the host. Unit: `GB`.
 * @property hostName The name of the host.
 * @property hostStorage The total storage capacity of the host. Unit: `GB`.
 * @property hostType The storage type of the host.
 * @property id The ID of the Dedicated Host. The value formats as `<dedicated_host_group_id>:<dedicated_host_id>`.
 * @property imageCategory The image type of the host.
 * @property ipAddress The IP address of the host.
 * @property memAllocationRatio The memory usage in percentage.
 * @property memoryUsed The amount of memory used by the host. Unit: `GB`.
 * @property openPermission Indicates whether you have the OS permissions on the host. Valid values: `0`: You do not have the OS permissions on the host. `1`: You have the OS permissions on the host.
 * @property status The state of the host.
 * @property storageUsed The storage usage of the host. Unit: `GB`.
 * @property tags The tag of the resource.
 * @property vpcId The ID of the virtual private cloud (VPC) to which the host is connected.
 * @property vswitchId The ID of the vSwitch.
 * @property zoneId The zone ID of the host.
 */
public data class GetDedicatedHostsHost(
    public val allocationStatus: String,
    public val bastionInstanceId: String,
    public val cpuAllocationRatio: String,
    public val cpuUsed: String,
    public val createTime: String,
    public val dedicatedHostGroupId: String,
    public val dedicatedHostId: String,
    public val diskAllocationRatio: String,
    public val ecsClassCode: String,
    public val endTime: String,
    public val engine: String,
    public val expiredTime: String,
    public val hostClass: String,
    public val hostCpu: String,
    public val hostMem: String,
    public val hostName: String,
    public val hostStorage: String,
    public val hostType: String,
    public val id: String,
    public val imageCategory: String,
    public val ipAddress: String,
    public val memAllocationRatio: String,
    public val memoryUsed: String,
    public val openPermission: String,
    public val status: String,
    public val storageUsed: String,
    public val tags: Map<String, String>,
    public val vpcId: String,
    public val vswitchId: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cddc.outputs.GetDedicatedHostsHost): GetDedicatedHostsHost = GetDedicatedHostsHost(
            allocationStatus = javaType.allocationStatus(),
            bastionInstanceId = javaType.bastionInstanceId(),
            cpuAllocationRatio = javaType.cpuAllocationRatio(),
            cpuUsed = javaType.cpuUsed(),
            createTime = javaType.createTime(),
            dedicatedHostGroupId = javaType.dedicatedHostGroupId(),
            dedicatedHostId = javaType.dedicatedHostId(),
            diskAllocationRatio = javaType.diskAllocationRatio(),
            ecsClassCode = javaType.ecsClassCode(),
            endTime = javaType.endTime(),
            engine = javaType.engine(),
            expiredTime = javaType.expiredTime(),
            hostClass = javaType.hostClass(),
            hostCpu = javaType.hostCpu(),
            hostMem = javaType.hostMem(),
            hostName = javaType.hostName(),
            hostStorage = javaType.hostStorage(),
            hostType = javaType.hostType(),
            id = javaType.id(),
            imageCategory = javaType.imageCategory(),
            ipAddress = javaType.ipAddress(),
            memAllocationRatio = javaType.memAllocationRatio(),
            memoryUsed = javaType.memoryUsed(),
            openPermission = javaType.openPermission(),
            status = javaType.status(),
            storageUsed = javaType.storageUsed(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            vpcId = javaType.vpcId(),
            vswitchId = javaType.vswitchId(),
            zoneId = javaType.zoneId(),
        )
    }
}
