@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDedicatedHosts.
 * @property allocationStatus
 * @property dedicatedHostGroupId
 * @property enableDetails
 * @property hostType
 * @property hosts
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property orderId
 * @property outputFile
 * @property status
 * @property tags
 * @property zoneId
 */
public data class GetDedicatedHostsResult(
    public val allocationStatus: String? = null,
    public val dedicatedHostGroupId: String,
    public val enableDetails: Boolean? = null,
    public val hostType: String? = null,
    public val hosts: List<GetDedicatedHostsHost>,
    public val id: String,
    public val ids: List<String>,
    public val orderId: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tags: Map<String, String>? = null,
    public val zoneId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cddc.outputs.GetDedicatedHostsResult): GetDedicatedHostsResult = GetDedicatedHostsResult(
            allocationStatus = javaType.allocationStatus().map({ args0 -> args0 }).orElse(null),
            dedicatedHostGroupId = javaType.dedicatedHostGroupId(),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            hostType = javaType.hostType().map({ args0 -> args0 }).orElse(null),
            hosts = javaType.hosts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cddc.kotlin.outputs.GetDedicatedHostsHost.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            orderId = javaType.orderId().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            zoneId = javaType.zoneId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
