@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description The description of the host ecs level info.
 * @property ecsClass The instance family of the host ecs level info.
 * @property ecsClassCode The Elastic Compute Service (ECS) instance type.
 * @property resClassCode The ApsaraDB RDS instance type of the host ecs level info.
 */
public data class GetHostEcsLevelInfosInfo(
    public val description: String,
    public val ecsClass: String,
    public val ecsClassCode: String,
    public val resClassCode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cddc.outputs.GetHostEcsLevelInfosInfo): GetHostEcsLevelInfosInfo = GetHostEcsLevelInfosInfo(
            description = javaType.description(),
            ecsClass = javaType.ecsClass(),
            ecsClassCode = javaType.ecsClassCode(),
            resClassCode = javaType.resClassCode(),
        )
    }
}
