@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cddc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHostEcsLevelInfos.
 * @property dbType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageCategory
 * @property infos
 * @property outputFile
 * @property storageType
 * @property zoneId
 */
public data class GetHostEcsLevelInfosResult(
    public val dbType: String,
    public val id: String,
    public val imageCategory: String? = null,
    public val infos: List<GetHostEcsLevelInfosInfo>,
    public val outputFile: String? = null,
    public val storageType: String,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cddc.outputs.GetHostEcsLevelInfosResult): GetHostEcsLevelInfosResult = GetHostEcsLevelInfosResult(
            dbType = javaType.dbType(),
            id = javaType.id(),
            imageCategory = javaType.imageCategory().map({ args0 -> args0 }).orElse(null),
            infos = javaType.infos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cddc.kotlin.outputs.GetHostEcsLevelInfosInfo.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            storageType = javaType.storageType(),
            zoneId = javaType.zoneId(),
        )
    }
}
