@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin

import com.pulumi.alicloud.cdn.CdnFunctions.getBlockedRegionsPlain
import com.pulumi.alicloud.cdn.CdnFunctions.getIpInfoPlain
import com.pulumi.alicloud.cdn.CdnFunctions.getRealTimeLogDeliveriesPlain
import com.pulumi.alicloud.cdn.CdnFunctions.getServicePlain
import com.pulumi.alicloud.cdn.kotlin.inputs.GetBlockedRegionsPlainArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.GetBlockedRegionsPlainArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.GetIpInfoPlainArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.GetIpInfoPlainArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.GetRealTimeLogDeliveriesPlainArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.GetRealTimeLogDeliveriesPlainArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.GetServicePlainArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.outputs.GetBlockedRegionsResult
import com.pulumi.alicloud.cdn.kotlin.outputs.GetIpInfoResult
import com.pulumi.alicloud.cdn.kotlin.outputs.GetRealTimeLogDeliveriesResult
import com.pulumi.alicloud.cdn.kotlin.outputs.GetServiceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.alicloud.cdn.kotlin.outputs.GetBlockedRegionsResult.Companion.toKotlin as getBlockedRegionsResultToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.GetIpInfoResult.Companion.toKotlin as getIpInfoResultToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.GetRealTimeLogDeliveriesResult.Companion.toKotlin as getRealTimeLogDeliveriesResultToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin

public object CdnFunctions {
    /**
     * This data source provides the Cdn blocked regions.
     * > **NOTE:** Available in v1.173.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cdn.getBlockedRegions({
     *     language: "zh",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cdn.get_blocked_regions(language="zh")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cdn.GetBlockedRegions.Invoke(new()
     *     {
     *         Language = "zh",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cdn.GetBlockedRegions(ctx, &cdn.GetBlockedRegionsArgs{
     * 			Language: "zh",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cdn.CdnFunctions;
     * import com.pulumi.alicloud.cdn.inputs.GetBlockedRegionsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CdnFunctions.getBlockedRegions(GetBlockedRegionsArgs.builder()
     *             .language("zh")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cdn:getBlockedRegions
     *       Arguments:
     *         language: zh
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getBlockedRegions.
     * @return A collection of values returned by getBlockedRegions.
     */
    public suspend fun getBlockedRegions(argument: GetBlockedRegionsPlainArgs): GetBlockedRegionsResult =
        getBlockedRegionsResultToKotlin(getBlockedRegionsPlain(argument.toJava()).await())

    /**
     * @see [getBlockedRegions].
     * @param language The language. Valid values: `zh`, `en`, `jp`.
     * @return A collection of values returned by getBlockedRegions.
     */
    public suspend fun getBlockedRegions(language: String): GetBlockedRegionsResult {
        val argument = GetBlockedRegionsPlainArgs(
            language = language,
        )
        return getBlockedRegionsResultToKotlin(getBlockedRegionsPlain(argument.toJava()).await())
    }

    /**
     * @see [getBlockedRegions].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cdn&#46;kotlin&#46;inputs&#46;GetBlockedRegionsPlainArgs].
     * @return A collection of values returned by getBlockedRegions.
     */
    public suspend fun getBlockedRegions(argument: suspend GetBlockedRegionsPlainArgsBuilder.() -> Unit): GetBlockedRegionsResult {
        val builder = GetBlockedRegionsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBlockedRegionsResultToKotlin(getBlockedRegionsPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the function of verifying whether an IP is a CDN node.
     * > **NOTE:** Available in v1.153.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const ipTest = alicloud.cdn.getIpInfo({
     *     ip: "114.114.114.114",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * ip_test = alicloud.cdn.get_ip_info(ip="114.114.114.114")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var ipTest = AliCloud.Cdn.GetIpInfo.Invoke(new()
     *     {
     *         Ip = "114.114.114.114",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cdn.GetIpInfo(ctx, &cdn.GetIpInfoArgs{
     * 			Ip: "114.114.114.114",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cdn.CdnFunctions;
     * import com.pulumi.alicloud.cdn.inputs.GetIpInfoArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var ipTest = CdnFunctions.getIpInfo(GetIpInfoArgs.builder()
     *             .ip("114.114.114.114")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   ipTest:
     *     fn::invoke:
     *       Function: alicloud:cdn:getIpInfo
     *       Arguments:
     *         ip: 114.114.114.114
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpInfo.
     * @return A collection of values returned by getIpInfo.
     */
    public suspend fun getIpInfo(argument: GetIpInfoPlainArgs): GetIpInfoResult =
        getIpInfoResultToKotlin(getIpInfoPlain(argument.toJava()).await())

    /**
     * @see [getIpInfo].
     * @param ip Specify IP address.
     * @return A collection of values returned by getIpInfo.
     */
    public suspend fun getIpInfo(ip: String): GetIpInfoResult {
        val argument = GetIpInfoPlainArgs(
            ip = ip,
        )
        return getIpInfoResultToKotlin(getIpInfoPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpInfo].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cdn&#46;kotlin&#46;inputs&#46;GetIpInfoPlainArgs].
     * @return A collection of values returned by getIpInfo.
     */
    public suspend fun getIpInfo(argument: suspend GetIpInfoPlainArgsBuilder.() -> Unit): GetIpInfoResult {
        val builder = GetIpInfoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpInfoResultToKotlin(getIpInfoPlain(builtArgument.toJava()).await())
    }

    /**
     * This data source provides the Cdn Real Time Log Deliveries of the current Alibaba Cloud user.
     * > **NOTE:** Available in v1.134.0+.
     * ## Example Usage
     * Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const example = alicloud.cdn.getRealTimeLogDeliveries({
     *     domain: "example_value",
     * });
     * export const cdnRealTimeLogDelivery1 = example.then(example => example.deliveries?.[0]?.id);
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * example = alicloud.cdn.get_real_time_log_deliveries(domain="example_value")
     * pulumi.export("cdnRealTimeLogDelivery1", example.deliveries[0].id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = AliCloud.Cdn.GetRealTimeLogDeliveries.Invoke(new()
     *     {
     *         Domain = "example_value",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["cdnRealTimeLogDelivery1"] = example&#46;Apply(getRealTimeLogDeliveriesResult => getRealTimeLogDeliveriesResult&#46;Deliveries[0]?.Id),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := cdn.GetRealTimeLogDeliveries(ctx, &cdn.GetRealTimeLogDeliveriesArgs{
     * 			Domain: "example_value",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("cdnRealTimeLogDelivery1", example.Deliveries[0].Id)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cdn.CdnFunctions;
     * import com.pulumi.alicloud.cdn.inputs.GetRealTimeLogDeliveriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = CdnFunctions.getRealTimeLogDeliveries(GetRealTimeLogDeliveriesArgs.builder()
     *             .domain("example_value")
     *             .build());
     *         ctx.export("cdnRealTimeLogDelivery1", example.applyValue(getRealTimeLogDeliveriesResult -> getRealTimeLogDeliveriesResult.deliveries()[0].id()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: alicloud:cdn:getRealTimeLogDeliveries
     *       Arguments:
     *         domain: example_value
     * outputs:
     *   cdnRealTimeLogDelivery1: ${example.deliveries[0].id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRealTimeLogDeliveries.
     * @return A collection of values returned by getRealTimeLogDeliveries.
     */
    public suspend fun getRealTimeLogDeliveries(argument: GetRealTimeLogDeliveriesPlainArgs): GetRealTimeLogDeliveriesResult =
        getRealTimeLogDeliveriesResultToKotlin(getRealTimeLogDeliveriesPlain(argument.toJava()).await())

    /**
     * @see [getRealTimeLogDeliveries].
     * @param domain
     * @param outputFile File name where to save data source results (after running `pulumi preview`).
     * @param status The status of the real-time log delivery feature. Valid Values: `online` and `offline`.
     * @return A collection of values returned by getRealTimeLogDeliveries.
     */
    public suspend fun getRealTimeLogDeliveries(
        domain: String,
        outputFile: String? = null,
        status: String? = null,
    ): GetRealTimeLogDeliveriesResult {
        val argument = GetRealTimeLogDeliveriesPlainArgs(
            domain = domain,
            outputFile = outputFile,
            status = status,
        )
        return getRealTimeLogDeliveriesResultToKotlin(getRealTimeLogDeliveriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getRealTimeLogDeliveries].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cdn&#46;kotlin&#46;inputs&#46;GetRealTimeLogDeliveriesPlainArgs].
     * @return A collection of values returned by getRealTimeLogDeliveries.
     */
    public suspend fun getRealTimeLogDeliveries(argument: suspend GetRealTimeLogDeliveriesPlainArgsBuilder.() -> Unit): GetRealTimeLogDeliveriesResult {
        val builder = GetRealTimeLogDeliveriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRealTimeLogDeliveriesResultToKotlin(getRealTimeLogDeliveriesPlain(builtArgument.toJava()).await())
    }

    /**
     * Using this data source can enable CDN service automatically. If the service has been enabled, it will return `Opened`.
     * For information about CDN and how to use it, see [What is CDN](https://www.alibabacloud.com/help/product/27099.htm).
     * > **NOTE:** Available since v1.98.0.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as alicloud from "@pulumi/alicloud";
     * const open = alicloud.cdn.getService({
     *     enable: "On",
     *     internetChargeType: "PayByTraffic",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_alicloud as alicloud
     * open = alicloud.cdn.get_service(enable="On",
     *     internet_charge_type="PayByTraffic")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using AliCloud = Pulumi.AliCloud;
     * return await Deployment.RunAsync(() =>
     * {
     *     var open = AliCloud.Cdn.GetService.Invoke(new()
     *     {
     *         Enable = "On",
     *         InternetChargeType = "PayByTraffic",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := cdn.GetService(ctx, &cdn.GetServiceArgs{
     * 			Enable:             pulumi.StringRef("On"),
     * 			InternetChargeType: pulumi.StringRef("PayByTraffic"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.alicloud.cdn.CdnFunctions;
     * import com.pulumi.alicloud.cdn.inputs.GetServiceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var open = CdnFunctions.getService(GetServiceArgs.builder()
     *             .enable("On")
     *             .internetChargeType("PayByTraffic")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   open:
     *     fn::invoke:
     *       Function: alicloud:cdn:getService
     *       Arguments:
     *         enable: On
     *         internetChargeType: PayByTraffic
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getService.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param enable Setting the value to `On` to enable the service. If has been enabled, return the result. Valid values: "On" or "Off". Default to "Off".
     * @param internetChargeType The new billing method. Valid values: `PayByTraffic` and `PayByBandwidth`. Default value: `PayByTraffic`.
     * It is required when `enable = on`. If the CDN service has been opened and you can update its internet charge type by modifying the filed `internet_charge_type`.
     * As a note, the updated internet charge type will be effective in the next day zero time.
     * > **NOTE:** Setting `enable = "On"` to open the CDN service that means you have read and agreed the [CDN Terms of Service](https://help.aliyun.com/document_detail/27110.html). The service can not closed once it is opened.
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(enable: String? = null, internetChargeType: String? = null): GetServiceResult {
        val argument = GetServicePlainArgs(
            enable = enable,
            internetChargeType = internetChargeType,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;alicloud&#46;cdn&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return A collection of values returned by getService.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit): GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }
}
