@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin

import com.pulumi.alicloud.cdn.kotlin.outputs.DomainAuthConfig
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainCacheConfig
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainCertificateConfig
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainHttpHeaderConfig
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainPage404Config
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainParameterFilterConfig
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainReferConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainAuthConfig.Companion.toKotlin as domainAuthConfigToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainCacheConfig.Companion.toKotlin as domainCacheConfigToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainCertificateConfig.Companion.toKotlin as domainCertificateConfigToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainHttpHeaderConfig.Companion.toKotlin as domainHttpHeaderConfigToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainPage404Config.Companion.toKotlin as domainPage404ConfigToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainParameterFilterConfig.Companion.toKotlin as domainParameterFilterConfigToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainReferConfig.Companion.toKotlin as domainReferConfigToKotlin

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource = com.pulumi.alicloud.cdn.Domain(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Domain(builtJavaResource)
    }
}

public class Domain internal constructor(
    override val javaResource: com.pulumi.alicloud.cdn.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val authConfig: Output<DomainAuthConfig>?
        get() = javaResource.authConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    domainAuthConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val blockIps: Output<List<String>>?
        get() = javaResource.blockIps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val cacheConfigs: Output<List<DomainCacheConfig>>?
        get() = javaResource.cacheConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> domainCacheConfigToKotlin(args0) })
                })
            }).orElse(null)
        })

    public val cdnType: Output<String>
        get() = javaResource.cdnType().applyValue({ args0 -> args0 })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val certificateConfig: Output<DomainCertificateConfig>?
        get() = javaResource.certificateConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainCertificateConfigToKotlin(args0) })
            }).orElse(null)
        })

    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val httpHeaderConfigs: Output<List<DomainHttpHeaderConfig>>?
        get() = javaResource.httpHeaderConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        domainHttpHeaderConfigToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val optimizeEnable: Output<String>?
        get() = javaResource.optimizeEnable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val page404Config: Output<DomainPage404Config>?
        get() = javaResource.page404Config().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainPage404ConfigToKotlin(args0) })
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val pageCompressEnable: Output<String>?
        get() = javaResource.pageCompressEnable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val parameterFilterConfig: Output<DomainParameterFilterConfig>?
        get() = javaResource.parameterFilterConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> domainParameterFilterConfigToKotlin(args0) })
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val rangeEnable: Output<String>?
        get() = javaResource.rangeEnable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val referConfig: Output<DomainReferConfig>?
        get() = javaResource.referConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    domainReferConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` block `port` argument instead.
  """,
    )
    public val sourcePort: Output<Int>?
        get() = javaResource.sourcePort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` block `type` argument instead.
  """,
    )
    public val sourceType: Output<String>?
        get() = javaResource.sourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` argument instead.
  """,
    )
    public val sources: Output<List<String>>?
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val videoSeekEnable: Output<String>?
        get() = javaResource.videoSeekEnable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cdn.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.alicloud.cdn.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
