@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin

import com.pulumi.alicloud.cdn.DomainArgs.builder
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainAuthConfigArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainAuthConfigArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainCacheConfigArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainCacheConfigArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainCertificateConfigArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainCertificateConfigArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainHttpHeaderConfigArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainHttpHeaderConfigArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainPage404ConfigArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainPage404ConfigArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainParameterFilterConfigArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainParameterFilterConfigArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainReferConfigArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainReferConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property authConfig
 * @property blockIps
 * @property cacheConfigs
 * @property cdnType
 * @property certificateConfig
 * @property domainName
 * @property httpHeaderConfigs
 * @property optimizeEnable
 * @property page404Config
 * @property pageCompressEnable
 * @property parameterFilterConfig
 * @property rangeEnable
 * @property referConfig
 * @property scope
 * @property sourcePort
 * @property sourceType
 * @property sources
 * @property videoSeekEnable
 */
public data class DomainArgs(
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val authConfig: Output<DomainAuthConfigArgs>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val blockIps: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val cacheConfigs: Output<List<DomainCacheConfigArgs>>? = null,
    public val cdnType: Output<String>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val certificateConfig: Output<DomainCertificateConfigArgs>? = null,
    public val domainName: Output<String>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val httpHeaderConfigs: Output<List<DomainHttpHeaderConfigArgs>>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val optimizeEnable: Output<String>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val page404Config: Output<DomainPage404ConfigArgs>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val pageCompressEnable: Output<String>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val parameterFilterConfig: Output<DomainParameterFilterConfigArgs>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val rangeEnable: Output<String>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val referConfig: Output<DomainReferConfigArgs>? = null,
    public val scope: Output<String>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` block `port` argument instead.
  """,
    )
    public val sourcePort: Output<Int>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` block `type` argument instead.
  """,
    )
    public val sourceType: Output<String>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` argument instead.
  """,
    )
    public val sources: Output<List<String>>? = null,
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    public val videoSeekEnable: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.DomainArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.DomainArgs =
        com.pulumi.alicloud.cdn.DomainArgs.builder()
            .authConfig(authConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .blockIps(blockIps?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cacheConfigs(
                cacheConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .cdnType(cdnType?.applyValue({ args0 -> args0 }))
            .certificateConfig(certificateConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .httpHeaderConfigs(
                httpHeaderConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .optimizeEnable(optimizeEnable?.applyValue({ args0 -> args0 }))
            .page404Config(page404Config?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pageCompressEnable(pageCompressEnable?.applyValue({ args0 -> args0 }))
            .parameterFilterConfig(
                parameterFilterConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rangeEnable(rangeEnable?.applyValue({ args0 -> args0 }))
            .referConfig(referConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sourcePort(sourcePort?.applyValue({ args0 -> args0 }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .sources(sources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .videoSeekEnable(videoSeekEnable?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var authConfig: Output<DomainAuthConfigArgs>? = null

    private var blockIps: Output<List<String>>? = null

    private var cacheConfigs: Output<List<DomainCacheConfigArgs>>? = null

    private var cdnType: Output<String>? = null

    private var certificateConfig: Output<DomainCertificateConfigArgs>? = null

    private var domainName: Output<String>? = null

    private var httpHeaderConfigs: Output<List<DomainHttpHeaderConfigArgs>>? = null

    private var optimizeEnable: Output<String>? = null

    private var page404Config: Output<DomainPage404ConfigArgs>? = null

    private var pageCompressEnable: Output<String>? = null

    private var parameterFilterConfig: Output<DomainParameterFilterConfigArgs>? = null

    private var rangeEnable: Output<String>? = null

    private var referConfig: Output<DomainReferConfigArgs>? = null

    private var scope: Output<String>? = null

    private var sourcePort: Output<Int>? = null

    private var sourceType: Output<String>? = null

    private var sources: Output<List<String>>? = null

    private var videoSeekEnable: Output<String>? = null

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("cirokcgutnghwksm")
    public suspend fun authConfig(`value`: Output<DomainAuthConfigArgs>) {
        this.authConfig = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("palhlxwesgptapcu")
    public suspend fun blockIps(`value`: Output<List<String>>) {
        this.blockIps = value
    }

    @JvmName("pulteuftinfyebtk")
    public suspend fun blockIps(vararg values: Output<String>) {
        this.blockIps = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("jdnnhnyuxqlmqlbp")
    public suspend fun blockIps(values: List<Output<String>>) {
        this.blockIps = Output.all(values)
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("fsfgfldpvgqbqurc")
    public suspend fun cacheConfigs(`value`: Output<List<DomainCacheConfigArgs>>) {
        this.cacheConfigs = value
    }

    @JvmName("blcmdgnbkxcjwpcu")
    public suspend fun cacheConfigs(vararg values: Output<DomainCacheConfigArgs>) {
        this.cacheConfigs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("qxrhvdhriavmjafy")
    public suspend fun cacheConfigs(values: List<Output<DomainCacheConfigArgs>>) {
        this.cacheConfigs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("txhghkaqnedqdgbv")
    public suspend fun cdnType(`value`: Output<String>) {
        this.cdnType = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("omguwaupnseybylb")
    public suspend fun certificateConfig(`value`: Output<DomainCertificateConfigArgs>) {
        this.certificateConfig = value
    }

    /**
     * @param value
     */
    @JvmName("acofykxnxwuxmjsg")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("deapvybsnwxakmrx")
    public suspend fun httpHeaderConfigs(`value`: Output<List<DomainHttpHeaderConfigArgs>>) {
        this.httpHeaderConfigs = value
    }

    @JvmName("ckpyomiyrrgcshvl")
    public suspend fun httpHeaderConfigs(vararg values: Output<DomainHttpHeaderConfigArgs>) {
        this.httpHeaderConfigs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("xsmgakmhygwwcbuf")
    public suspend fun httpHeaderConfigs(values: List<Output<DomainHttpHeaderConfigArgs>>) {
        this.httpHeaderConfigs = Output.all(values)
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("hyroxjlaxfdjfrkk")
    public suspend fun optimizeEnable(`value`: Output<String>) {
        this.optimizeEnable = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("slifnowbcjpovtma")
    public suspend fun page404Config(`value`: Output<DomainPage404ConfigArgs>) {
        this.page404Config = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("jhshhvhakwgjjeee")
    public suspend fun pageCompressEnable(`value`: Output<String>) {
        this.pageCompressEnable = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("ytrynrjnkayvljwx")
    public suspend fun parameterFilterConfig(`value`: Output<DomainParameterFilterConfigArgs>) {
        this.parameterFilterConfig = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("kxwxgsqqtgkuvvug")
    public suspend fun rangeEnable(`value`: Output<String>) {
        this.rangeEnable = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("nqagfrywkyolfxsn")
    public suspend fun referConfig(`value`: Output<DomainReferConfigArgs>) {
        this.referConfig = value
    }

    /**
     * @param value
     */
    @JvmName("aldhsyesuvqlvhgb")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` block `port` argument instead.
  """,
    )
    @JvmName("kxustsktpebnebly")
    public suspend fun sourcePort(`value`: Output<Int>) {
        this.sourcePort = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` block `type` argument instead.
  """,
    )
    @JvmName("ktnausykqstqqifw")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` argument instead.
  """,
    )
    @JvmName("bmmofgrfjnqlttmp")
    public suspend fun sources(`value`: Output<List<String>>) {
        this.sources = value
    }

    @JvmName("btukholypqxljgmc")
    public suspend fun sources(vararg values: Output<String>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` argument instead.
  """,
    )
    @JvmName("wmjagokpewaahyvd")
    public suspend fun sources(values: List<Output<String>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("mvrasajuogmqmtrv")
    public suspend fun videoSeekEnable(`value`: Output<String>) {
        this.videoSeekEnable = value
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("anslhehnckqbspfp")
    public suspend fun authConfig(`value`: DomainAuthConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authConfig = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("lcehcmoxcrwneydh")
    public suspend fun authConfig(argument: suspend DomainAuthConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainAuthConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authConfig = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("rwavbjitrwbthidu")
    public suspend fun blockIps(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockIps = mapped
    }

    /**
     * @param values
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("dkhivejrykmevhwg")
    public suspend fun blockIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockIps = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("fqbduxnecpbolygl")
    public suspend fun cacheConfigs(`value`: List<DomainCacheConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheConfigs = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("boxeyebvdigvfubt")
    public suspend fun cacheConfigs(argument: List<suspend DomainCacheConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainCacheConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheConfigs = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("bqeohtpkxshmkpih")
    public suspend fun cacheConfigs(vararg argument: suspend DomainCacheConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainCacheConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.cacheConfigs = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("jcmljiwddroxahth")
    public suspend fun cacheConfigs(argument: suspend DomainCacheConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainCacheConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.cacheConfigs = mapped
    }

    /**
     * @param values
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("bkjovaexlpuljjjc")
    public suspend fun cacheConfigs(vararg values: DomainCacheConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheConfigs = mapped
    }

    /**
     * @param value
     */
    @JvmName("ppgyaphcibsrfgtu")
    public suspend fun cdnType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdnType = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("hbqbtobbrjurnkrf")
    public suspend fun certificateConfig(`value`: DomainCertificateConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateConfig = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("uuxgjbkincmivdxq")
    public suspend fun certificateConfig(argument: suspend DomainCertificateConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainCertificateConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.certificateConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("lxixphwwfngwlemi")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("esjstmmevlqfmxco")
    public suspend fun httpHeaderConfigs(`value`: List<DomainHttpHeaderConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpHeaderConfigs = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("dksoeupohdnvaayp")
    public suspend fun httpHeaderConfigs(argument: List<suspend DomainHttpHeaderConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainHttpHeaderConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeaderConfigs = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("stmbrclwcbricode")
    public suspend fun httpHeaderConfigs(vararg argument: suspend DomainHttpHeaderConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainHttpHeaderConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpHeaderConfigs = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("giagnwbxaccbueha")
    public suspend fun httpHeaderConfigs(argument: suspend DomainHttpHeaderConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainHttpHeaderConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.httpHeaderConfigs = mapped
    }

    /**
     * @param values
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("exqqgxqanamifyqb")
    public suspend fun httpHeaderConfigs(vararg values: DomainHttpHeaderConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpHeaderConfigs = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("sxrxnjpbsxtmhyik")
    public suspend fun optimizeEnable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizeEnable = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("qvwtlgfyviravkdy")
    public suspend fun page404Config(`value`: DomainPage404ConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.page404Config = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("lsrptuasyrurobtb")
    public suspend fun page404Config(argument: suspend DomainPage404ConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainPage404ConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.page404Config = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("ixdilbnoxmdkhbqd")
    public suspend fun pageCompressEnable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pageCompressEnable = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("weuupohteyhobois")
    public suspend fun parameterFilterConfig(`value`: DomainParameterFilterConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterFilterConfig = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("ykloryqwyfdfkcin")
    public suspend fun parameterFilterConfig(argument: suspend DomainParameterFilterConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainParameterFilterConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameterFilterConfig = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("pvmfwcmpueaemxuu")
    public suspend fun rangeEnable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rangeEnable = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("xjuoysjvvgvddcso")
    public suspend fun referConfig(`value`: DomainReferConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referConfig = mapped
    }

    /**
     * @param argument
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("hbocydqwjvywibla")
    public suspend fun referConfig(argument: suspend DomainReferConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainReferConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.referConfig = mapped
    }

    /**
     * @param value
     */
    @JvmName("qmuixucberhwdgkk")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` block `port` argument instead.
  """,
    )
    @JvmName("fwtcrqrhhbwvjosd")
    public suspend fun sourcePort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcePort = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` block `type` argument instead.
  """,
    )
    @JvmName("cktutkxaitlbnusp")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` argument instead.
  """,
    )
    @JvmName("pjsfoefqbhdoqnci")
    public suspend fun sources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param values
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainNew` configuration `sources` argument instead.
  """,
    )
    @JvmName("aajraqnurrruyrsb")
    public suspend fun sources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value
     */
    @Deprecated(
        message = """
  Use `alicloud.cdn.DomainConfig` configuration `function_name` and `function_args` arguments
      instead.
  """,
    )
    @JvmName("driggcgxthfpriuo")
    public suspend fun videoSeekEnable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoSeekEnable = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        authConfig = authConfig,
        blockIps = blockIps,
        cacheConfigs = cacheConfigs,
        cdnType = cdnType,
        certificateConfig = certificateConfig,
        domainName = domainName,
        httpHeaderConfigs = httpHeaderConfigs,
        optimizeEnable = optimizeEnable,
        page404Config = page404Config,
        pageCompressEnable = pageCompressEnable,
        parameterFilterConfig = parameterFilterConfig,
        rangeEnable = rangeEnable,
        referConfig = referConfig,
        scope = scope,
        sourcePort = sourcePort,
        sourceType = sourceType,
        sources = sources,
        videoSeekEnable = videoSeekEnable,
    )
}
