@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin

import com.pulumi.alicloud.cdn.kotlin.outputs.DomainConfigFunctionArg
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainConfigFunctionArg.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DomainConfig].
 */
@PulumiTagMarker
public class DomainConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainConfigArgs = DomainConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainConfigArgsBuilder.() -> Unit) {
        val builder = DomainConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainConfig {
        val builtJavaResource = com.pulumi.alicloud.cdn.DomainConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainConfig(builtJavaResource)
    }
}

/**
 * Provides a Cdn Domain Config resource.
 * For information about Cdn Domain Config and how to use it, see [What is Domain Config](https://www.alibabacloud.com/help/en/doc-detail/90915.htm)
 * > **NOTE:** Available since v1.34.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * // Create a new Domain config.
 * const domain = new alicloud.cdn.DomainNew("domain", {
 *     domainName: `mycdndomain-${_default.result}.alicloud-provider.cn`,
 *     cdnType: "web",
 *     scope: "overseas",
 *     sources: [{
 *         content: "1.1.1.1",
 *         type: "ipaddr",
 *         priority: 20,
 *         port: 80,
 *         weight: 15,
 *     }],
 * });
 * const config = new alicloud.cdn.DomainConfig("config", {
 *     domainName: domain.domainName,
 *     functionName: "ip_allow_list_set",
 *     functionArgs: [{
 *         argName: "ip_list",
 *         argValue: "110.110.110.110",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * # Create a new Domain config.
 * domain = alicloud.cdn.DomainNew("domain",
 *     domain_name=f"mycdndomain-{default['result']}.alicloud-provider.cn",
 *     cdn_type="web",
 *     scope="overseas",
 *     sources=[{
 *         "content": "1.1.1.1",
 *         "type": "ipaddr",
 *         "priority": 20,
 *         "port": 80,
 *         "weight": 15,
 *     }])
 * config = alicloud.cdn.DomainConfig("config",
 *     domain_name=domain.domain_name,
 *     function_name="ip_allow_list_set",
 *     function_args=[{
 *         "arg_name": "ip_list",
 *         "arg_value": "110.110.110.110",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     // Create a new Domain config.
 *     var domain = new AliCloud.Cdn.DomainNew("domain", new()
 *     {
 *         DomainName = $"mycdndomain-{@default.Result}.alicloud-provider.cn",
 *         CdnType = "web",
 *         Scope = "overseas",
 *         Sources = new[]
 *         {
 *             new AliCloud.Cdn.Inputs.DomainNewSourceArgs
 *             {
 *                 Content = "1.1.1.1",
 *                 Type = "ipaddr",
 *                 Priority = 20,
 *                 Port = 80,
 *                 Weight = 15,
 *             },
 *         },
 *     });
 *     var config = new AliCloud.Cdn.DomainConfig("config", new()
 *     {
 *         DomainName = domain.DomainName,
 *         FunctionName = "ip_allow_list_set",
 *         FunctionArgs = new[]
 *         {
 *             new AliCloud.Cdn.Inputs.DomainConfigFunctionArgArgs
 *             {
 *                 ArgName = "ip_list",
 *                 ArgValue = "110.110.110.110",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Create a new Domain config.
 * 		domain, err := cdn.NewDomainNew(ctx, "domain", &cdn.DomainNewArgs{
 * 			DomainName: pulumi.Sprintf("mycdndomain-%v.alicloud-provider.cn", _default.Result),
 * 			CdnType:    pulumi.String("web"),
 * 			Scope:      pulumi.String("overseas"),
 * 			Sources: cdn.DomainNewSourceArray{
 * 				&cdn.DomainNewSourceArgs{
 * 					Content:  pulumi.String("1.1.1.1"),
 * 					Type:     pulumi.String("ipaddr"),
 * 					Priority: pulumi.Int(20),
 * 					Port:     pulumi.Int(80),
 * 					Weight:   pulumi.Int(15),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cdn.NewDomainConfig(ctx, "config", &cdn.DomainConfigArgs{
 * 			DomainName:   domain.DomainName,
 * 			FunctionName: pulumi.String("ip_allow_list_set"),
 * 			FunctionArgs: cdn.DomainConfigFunctionArgArray{
 * 				&cdn.DomainConfigFunctionArgArgs{
 * 					ArgName:  pulumi.String("ip_list"),
 * 					ArgValue: pulumi.String("110.110.110.110"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.cdn.DomainNew;
 * import com.pulumi.alicloud.cdn.DomainNewArgs;
 * import com.pulumi.alicloud.cdn.inputs.DomainNewSourceArgs;
 * import com.pulumi.alicloud.cdn.DomainConfig;
 * import com.pulumi.alicloud.cdn.DomainConfigArgs;
 * import com.pulumi.alicloud.cdn.inputs.DomainConfigFunctionArgArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         // Create a new Domain config.
 *         var domain = new DomainNew("domain", DomainNewArgs.builder()
 *             .domainName(String.format("mycdndomain-%s.alicloud-provider.cn", default_.result()))
 *             .cdnType("web")
 *             .scope("overseas")
 *             .sources(DomainNewSourceArgs.builder()
 *                 .content("1.1.1.1")
 *                 .type("ipaddr")
 *                 .priority("20")
 *                 .port(80)
 *                 .weight("15")
 *                 .build())
 *             .build());
 *         var config = new DomainConfig("config", DomainConfigArgs.builder()
 *             .domainName(domain.domainName())
 *             .functionName("ip_allow_list_set")
 *             .functionArgs(DomainConfigFunctionArgArgs.builder()
 *                 .argName("ip_list")
 *                 .argValue("110.110.110.110")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   # Create a new Domain config.
 *   domain:
 *     type: alicloud:cdn:DomainNew
 *     properties:
 *       domainName: mycdndomain-${default.result}.alicloud-provider.cn
 *       cdnType: web
 *       scope: overseas
 *       sources:
 *         - content: 1.1.1.1
 *           type: ipaddr
 *           priority: '20'
 *           port: 80
 *           weight: '15'
 *   config:
 *     type: alicloud:cdn:DomainConfig
 *     properties:
 *       domainName: ${domain.domainName}
 *       functionName: ip_allow_list_set
 *       functionArgs:
 *         - argName: ip_list
 *           argValue: 110.110.110.110
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CDN domain config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cdn/domainConfig:DomainConfig example <domain_name>:<function_name>:<config_id>
 * ```
 * ```sh
 * $ pulumi import alicloud:cdn/domainConfig:DomainConfig example <domain_name>:<function_name>
 * ```
 */
public class DomainConfig internal constructor(
    override val javaResource: com.pulumi.alicloud.cdn.DomainConfig,
) : KotlinCustomResource(javaResource, DomainConfigMapper) {
    /**
     * (Available since v1.132.0) The ID of the domain config function.
     */
    public val configId: Output<String>
        get() = javaResource.configId().applyValue({ args0 -> args0 })

    /**
     * Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The args of the domain config. See `function_args` below.
     */
    public val functionArgs: Output<List<DomainConfigFunctionArg>>
        get() = javaResource.functionArgs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The name of the domain config.
     */
    public val functionName: Output<String>
        get() = javaResource.functionName().applyValue({ args0 -> args0 })

    /**
     * By configuring the function condition (rule engine) in the domain name configuration function parameters, Rule conditions can be created (Rule conditions can match and filter user requests by identifying various parameters carried in user requests). After each rule condition is created, a corresponding ConfigId will be generated, and the ConfigId can be referenced by other functions as a ParentId parameter, in this way, the rule conditions can be combined with the functional configuration to form a more flexible configuration.
     */
    public val parentId: Output<String>
        get() = javaResource.parentId().applyValue({ args0 -> args0 })

    /**
     * (Available since v1.132.0) The Status of the function.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object DomainConfigMapper : ResourceMapper<DomainConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cdn.DomainConfig::class == javaResource::class

    override fun map(javaResource: Resource): DomainConfig = DomainConfig(
        javaResource as
            com.pulumi.alicloud.cdn.DomainConfig,
    )
}

/**
 * @see [DomainConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainConfig].
 */
public suspend fun domainConfig(
    name: String,
    block: suspend DomainConfigResourceBuilder.() -> Unit,
): DomainConfig {
    val builder = DomainConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainConfig(name: String): DomainConfig {
    val builder = DomainConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
