@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin

import com.pulumi.alicloud.cdn.kotlin.outputs.DomainNewCertificateConfig
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainNewSource
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainNewCertificateConfig.Companion.toKotlin as domainNewCertificateConfigToKotlin
import com.pulumi.alicloud.cdn.kotlin.outputs.DomainNewSource.Companion.toKotlin as domainNewSourceToKotlin

/**
 * Builder for [DomainNew].
 */
@PulumiTagMarker
public class DomainNewResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainNewArgs = DomainNewArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainNewArgsBuilder.() -> Unit) {
        val builder = DomainNewArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainNew {
        val builtJavaResource = com.pulumi.alicloud.cdn.DomainNew(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainNew(builtJavaResource)
    }
}

/**
 * Provides a CDN Domain resource. CDN domain name.
 * For information about CDN Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addcdndomain).
 * > **NOTE:** Available since v1.34.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultDomainNew = new alicloud.cdn.DomainNew("default", {
 *     scope: "overseas",
 *     domainName: `mycdndomain-${_default.result}.alicloud-provider.cn`,
 *     cdnType: "web",
 *     sources: [{
 *         type: "ipaddr",
 *         content: "1.1.1.1",
 *         priority: 20,
 *         port: 80,
 *         weight: 15,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_domain_new = alicloud.cdn.DomainNew("default",
 *     scope="overseas",
 *     domain_name=f"mycdndomain-{default['result']}.alicloud-provider.cn",
 *     cdn_type="web",
 *     sources=[{
 *         "type": "ipaddr",
 *         "content": "1.1.1.1",
 *         "priority": 20,
 *         "port": 80,
 *         "weight": 15,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultDomainNew = new AliCloud.Cdn.DomainNew("default", new()
 *     {
 *         Scope = "overseas",
 *         DomainName = $"mycdndomain-{@default.Result}.alicloud-provider.cn",
 *         CdnType = "web",
 *         Sources = new[]
 *         {
 *             new AliCloud.Cdn.Inputs.DomainNewSourceArgs
 *             {
 *                 Type = "ipaddr",
 *                 Content = "1.1.1.1",
 *                 Priority = 20,
 *                 Port = 80,
 *                 Weight = 15,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cdn.NewDomainNew(ctx, "default", &cdn.DomainNewArgs{
 * 			Scope:      pulumi.String("overseas"),
 * 			DomainName: pulumi.Sprintf("mycdndomain-%v.alicloud-provider.cn", _default.Result),
 * 			CdnType:    pulumi.String("web"),
 * 			Sources: cdn.DomainNewSourceArray{
 * 				&cdn.DomainNewSourceArgs{
 * 					Type:     pulumi.String("ipaddr"),
 * 					Content:  pulumi.String("1.1.1.1"),
 * 					Priority: pulumi.Int(20),
 * 					Port:     pulumi.Int(80),
 * 					Weight:   pulumi.Int(15),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.cdn.DomainNew;
 * import com.pulumi.alicloud.cdn.DomainNewArgs;
 * import com.pulumi.alicloud.cdn.inputs.DomainNewSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultDomainNew = new DomainNew("defaultDomainNew", DomainNewArgs.builder()
 *             .scope("overseas")
 *             .domainName(String.format("mycdndomain-%s.alicloud-provider.cn", default_.result()))
 *             .cdnType("web")
 *             .sources(DomainNewSourceArgs.builder()
 *                 .type("ipaddr")
 *                 .content("1.1.1.1")
 *                 .priority(20)
 *                 .port(80)
 *                 .weight(15)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultDomainNew:
 *     type: alicloud:cdn:DomainNew
 *     name: default
 *     properties:
 *       scope: overseas
 *       domainName: mycdndomain-${default.result}.alicloud-provider.cn
 *       cdnType: web
 *       sources:
 *         - type: ipaddr
 *           content: 1.1.1.1
 *           priority: 20
 *           port: 80
 *           weight: 15
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CDN Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cdn/domainNew:DomainNew example <id>
 * ```
 */
public class DomainNew internal constructor(
    override val javaResource: com.pulumi.alicloud.cdn.DomainNew,
) : KotlinCustomResource(javaResource, DomainNewMapper) {
    /**
     * Cdn type of the accelerated domain. Valid values are `web`, `download`, `video`.
     */
    public val cdnType: Output<String>
        get() = javaResource.cdnType().applyValue({ args0 -> args0 })

    /**
     * Certificate configuration. See `certificate_config` below.
     */
    public val certificateConfig: Output<DomainNewCertificateConfig>
        get() = javaResource.certificateConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                domainNewCertificateConfigToKotlin(args0)
            })
        })

    /**
     * Health test URL.
     */
    public val checkUrl: Output<String>?
        get() = javaResource.checkUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The CNAME domain name corresponding to the accelerated domain name.
     */
    public val cname: Output<String>
        get() = javaResource.cname().applyValue({ args0 -> args0 })

    /**
     * Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>
        get() = javaResource.resourceGroupId().applyValue({ args0 -> args0 })

    /**
     * Scope of the accelerated domain. Valid values are `domestic`, `overseas`, `global`. Default value is `domestic`. This parameter's setting is valid Only for the international users and domestic L3 and above users. Value:
     * - **domestic**: Mainland China only.
     * - **overseas**: Global (excluding Mainland China).
     * - **global**: global.
     * The default value is **domestic**.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * The source address list of the accelerated domain. Defaults to null. See `sources` below.
     */
    public val sources: Output<List<DomainNewSource>>
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    domainNewSourceToKotlin(args0)
                })
            })
        })

    /**
     * The status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The tag of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })
}

public object DomainNewMapper : ResourceMapper<DomainNew> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cdn.DomainNew::class == javaResource::class

    override fun map(javaResource: Resource): DomainNew = DomainNew(
        javaResource as
            com.pulumi.alicloud.cdn.DomainNew,
    )
}

/**
 * @see [DomainNew].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainNew].
 */
public suspend fun domainNew(name: String, block: suspend DomainNewResourceBuilder.() -> Unit): DomainNew {
    val builder = DomainNewResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainNew].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainNew(name: String): DomainNew {
    val builder = DomainNewResourceBuilder()
    builder.name(name)
    return builder.build()
}
