@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin

import com.pulumi.alicloud.cdn.DomainNewArgs.builder
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainNewCertificateConfigArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainNewCertificateConfigArgsBuilder
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainNewSourceArgs
import com.pulumi.alicloud.cdn.kotlin.inputs.DomainNewSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CDN Domain resource. CDN domain name.
 * For information about CDN Domain and how to use it, see [What is Domain](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addcdndomain).
 * > **NOTE:** Available since v1.34.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const defaultDomainNew = new alicloud.cdn.DomainNew("default", {
 *     scope: "overseas",
 *     domainName: `mycdndomain-${_default.result}.alicloud-provider.cn`,
 *     cdnType: "web",
 *     sources: [{
 *         type: "ipaddr",
 *         content: "1.1.1.1",
 *         priority: 20,
 *         port: 80,
 *         weight: 15,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * default_domain_new = alicloud.cdn.DomainNew("default",
 *     scope="overseas",
 *     domain_name=f"mycdndomain-{default['result']}.alicloud-provider.cn",
 *     cdn_type="web",
 *     sources=[{
 *         "type": "ipaddr",
 *         "content": "1.1.1.1",
 *         "priority": 20,
 *         "port": 80,
 *         "weight": 15,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var defaultDomainNew = new AliCloud.Cdn.DomainNew("default", new()
 *     {
 *         Scope = "overseas",
 *         DomainName = $"mycdndomain-{@default.Result}.alicloud-provider.cn",
 *         CdnType = "web",
 *         Sources = new[]
 *         {
 *             new AliCloud.Cdn.Inputs.DomainNewSourceArgs
 *             {
 *                 Type = "ipaddr",
 *                 Content = "1.1.1.1",
 *                 Priority = 20,
 *                 Port = 80,
 *                 Weight = 15,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cdn.NewDomainNew(ctx, "default", &cdn.DomainNewArgs{
 * 			Scope:      pulumi.String("overseas"),
 * 			DomainName: pulumi.Sprintf("mycdndomain-%v.alicloud-provider.cn", _default.Result),
 * 			CdnType:    pulumi.String("web"),
 * 			Sources: cdn.DomainNewSourceArray{
 * 				&cdn.DomainNewSourceArgs{
 * 					Type:     pulumi.String("ipaddr"),
 * 					Content:  pulumi.String("1.1.1.1"),
 * 					Priority: pulumi.Int(20),
 * 					Port:     pulumi.Int(80),
 * 					Weight:   pulumi.Int(15),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.cdn.DomainNew;
 * import com.pulumi.alicloud.cdn.DomainNewArgs;
 * import com.pulumi.alicloud.cdn.inputs.DomainNewSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var defaultDomainNew = new DomainNew("defaultDomainNew", DomainNewArgs.builder()
 *             .scope("overseas")
 *             .domainName(String.format("mycdndomain-%s.alicloud-provider.cn", default_.result()))
 *             .cdnType("web")
 *             .sources(DomainNewSourceArgs.builder()
 *                 .type("ipaddr")
 *                 .content("1.1.1.1")
 *                 .priority(20)
 *                 .port(80)
 *                 .weight(15)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   defaultDomainNew:
 *     type: alicloud:cdn:DomainNew
 *     name: default
 *     properties:
 *       scope: overseas
 *       domainName: mycdndomain-${default.result}.alicloud-provider.cn
 *       cdnType: web
 *       sources:
 *         - type: ipaddr
 *           content: 1.1.1.1
 *           priority: 20
 *           port: 80
 *           weight: 15
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CDN Domain can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cdn/domainNew:DomainNew example <id>
 * ```
 * @property cdnType Cdn type of the accelerated domain. Valid values are `web`, `download`, `video`.
 * @property certificateConfig Certificate configuration. See `certificate_config` below.
 * @property checkUrl Health test URL.
 * @property domainName Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
 * @property resourceGroupId The ID of the resource group.
 * @property scope Scope of the accelerated domain. Valid values are `domestic`, `overseas`, `global`. Default value is `domestic`. This parameter's setting is valid Only for the international users and domestic L3 and above users. Value:
 * - **domestic**: Mainland China only.
 * - **overseas**: Global (excluding Mainland China).
 * - **global**: global.
 * The default value is **domestic**.
 * @property sources The source address list of the accelerated domain. Defaults to null. See `sources` below.
 * @property tags The tag of the resource.
 */
public data class DomainNewArgs(
    public val cdnType: Output<String>? = null,
    public val certificateConfig: Output<DomainNewCertificateConfigArgs>? = null,
    public val checkUrl: Output<String>? = null,
    public val domainName: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val sources: Output<List<DomainNewSourceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.DomainNewArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.DomainNewArgs =
        com.pulumi.alicloud.cdn.DomainNewArgs.builder()
            .cdnType(cdnType?.applyValue({ args0 -> args0 }))
            .certificateConfig(certificateConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .checkUrl(checkUrl?.applyValue({ args0 -> args0 }))
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .scope(scope?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DomainNewArgs].
 */
@PulumiTagMarker
public class DomainNewArgsBuilder internal constructor() {
    private var cdnType: Output<String>? = null

    private var certificateConfig: Output<DomainNewCertificateConfigArgs>? = null

    private var checkUrl: Output<String>? = null

    private var domainName: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var scope: Output<String>? = null

    private var sources: Output<List<DomainNewSourceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Cdn type of the accelerated domain. Valid values are `web`, `download`, `video`.
     */
    @JvmName("vimlmbbcajuuihie")
    public suspend fun cdnType(`value`: Output<String>) {
        this.cdnType = value
    }

    /**
     * @param value Certificate configuration. See `certificate_config` below.
     */
    @JvmName("hwfjtxflbhbobesm")
    public suspend fun certificateConfig(`value`: Output<DomainNewCertificateConfigArgs>) {
        this.certificateConfig = value
    }

    /**
     * @param value Health test URL.
     */
    @JvmName("dbksafyjwwpkhglt")
    public suspend fun checkUrl(`value`: Output<String>) {
        this.checkUrl = value
    }

    /**
     * @param value Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("ynlduvtphyrtclar")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("ydqjekuijkquwygr")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value Scope of the accelerated domain. Valid values are `domestic`, `overseas`, `global`. Default value is `domestic`. This parameter's setting is valid Only for the international users and domestic L3 and above users. Value:
     * - **domestic**: Mainland China only.
     * - **overseas**: Global (excluding Mainland China).
     * - **global**: global.
     * The default value is **domestic**.
     */
    @JvmName("iejyqhwlfgmttbku")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The source address list of the accelerated domain. Defaults to null. See `sources` below.
     */
    @JvmName("ckmkgpbsbdbmnpbf")
    public suspend fun sources(`value`: Output<List<DomainNewSourceArgs>>) {
        this.sources = value
    }

    @JvmName("vxucjesriojsuukd")
    public suspend fun sources(vararg values: Output<DomainNewSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values The source address list of the accelerated domain. Defaults to null. See `sources` below.
     */
    @JvmName("wxinqwppsswpypxl")
    public suspend fun sources(values: List<Output<DomainNewSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("qwvdsafgvjxkcqmo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Cdn type of the accelerated domain. Valid values are `web`, `download`, `video`.
     */
    @JvmName("qqntinulfnxiwpqm")
    public suspend fun cdnType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdnType = mapped
    }

    /**
     * @param value Certificate configuration. See `certificate_config` below.
     */
    @JvmName("dxbqmchohbtxbvnv")
    public suspend fun certificateConfig(`value`: DomainNewCertificateConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateConfig = mapped
    }

    /**
     * @param argument Certificate configuration. See `certificate_config` below.
     */
    @JvmName("bayurhllqteecsvm")
    public suspend fun certificateConfig(argument: suspend DomainNewCertificateConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DomainNewCertificateConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.certificateConfig = mapped
    }

    /**
     * @param value Health test URL.
     */
    @JvmName("welcabsjbdqvsobr")
    public suspend fun checkUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkUrl = mapped
    }

    /**
     * @param value Name of the accelerated domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("baahssqbwymwosvm")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("qnqluunnpjmcuimp")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Scope of the accelerated domain. Valid values are `domestic`, `overseas`, `global`. Default value is `domestic`. This parameter's setting is valid Only for the international users and domestic L3 and above users. Value:
     * - **domestic**: Mainland China only.
     * - **overseas**: Global (excluding Mainland China).
     * - **global**: global.
     * The default value is **domestic**.
     */
    @JvmName("yautxddykpwfigqg")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The source address list of the accelerated domain. Defaults to null. See `sources` below.
     */
    @JvmName("umuumngvfmeseskf")
    public suspend fun sources(`value`: List<DomainNewSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument The source address list of the accelerated domain. Defaults to null. See `sources` below.
     */
    @JvmName("eqtpawudgroukxsu")
    public suspend fun sources(argument: List<suspend DomainNewSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainNewSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The source address list of the accelerated domain. Defaults to null. See `sources` below.
     */
    @JvmName("mnxanubxyhjahwvc")
    public suspend fun sources(vararg argument: suspend DomainNewSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DomainNewSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The source address list of the accelerated domain. Defaults to null. See `sources` below.
     */
    @JvmName("yotvovovngxpofrq")
    public suspend fun sources(argument: suspend DomainNewSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DomainNewSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values The source address list of the accelerated domain. Defaults to null. See `sources` below.
     */
    @JvmName("ogqvcqmsdhtdcsfk")
    public suspend fun sources(vararg values: DomainNewSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value The tag of the resource.
     */
    @JvmName("fkbqumuncyqhfkrs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tag of the resource.
     */
    @JvmName("guprxgmuwmmrixqi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DomainNewArgs = DomainNewArgs(
        cdnType = cdnType,
        certificateConfig = certificateConfig,
        checkUrl = checkUrl,
        domainName = domainName,
        resourceGroupId = resourceGroupId,
        scope = scope,
        sources = sources,
        tags = tags,
    )
}
