@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FcTrigger].
 */
@PulumiTagMarker
public class FcTriggerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FcTriggerArgs = FcTriggerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FcTriggerArgsBuilder.() -> Unit) {
        val builder = FcTriggerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FcTrigger {
        val builtJavaResource = com.pulumi.alicloud.cdn.FcTrigger(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FcTrigger(builtJavaResource)
    }
}

/**
 * Provides a CDN Fc Trigger resource.
 * For information about CDN Fc Trigger and how to use it, see [What is Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger).
 * > **NOTE:** Available in v1.165.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getAccount({});
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const example = new alicloud.cdn.FcTrigger("example", {
 *     eventMetaName: "LogFileCreated",
 *     eventMetaVersion: "1.0.0",
 *     notes: "example_value",
 *     roleArn: _default.then(_default => `acs:ram::${_default.id}:role/aliyuncdneventnotificationrole`),
 *     sourceArn: _default.then(_default => `acs:cdn:*:${_default.id}:domain/example.com`),
 *     triggerArn: Promise.all([defaultGetRegions, _default])&#46;then(([defaultGetRegions, _default]) => `acs:fc:${defaultGetRegions&#46;regions?&#46;[0]?.id}:${_default.id}:services/FCTestService/functions/printEvent/triggers/testtrigger`),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_account()
 * default_get_regions = alicloud.get_regions(current=True)
 * example = alicloud.cdn.FcTrigger("example",
 *     event_meta_name="LogFileCreated",
 *     event_meta_version="1.0.0",
 *     notes="example_value",
 *     role_arn=f"acs:ram::{default.id}:role/aliyuncdneventnotificationrole",
 *     source_arn=f"acs:cdn:*:{default.id}:domain/example.com",
 *     trigger_arn=f"acs:fc:{default_get_regions.regions[0].id}:{default.id}:services/FCTestService/functions/printEvent/triggers/testtrigger")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var example = new AliCloud.Cdn.FcTrigger("example", new()
 *     {
 *         EventMetaName = "LogFileCreated",
 *         EventMetaVersion = "1.0.0",
 *         Notes = "example_value",
 *         RoleArn = @default.Apply(@default => $"acs:ram::{@default.Apply(getAccountResult => getAccountResult.Id)}:role/aliyuncdneventnotificationrole"),
 *         SourceArn = @default.Apply(@default => $"acs:cdn:*:{@default.Apply(getAccountResult => getAccountResult.Id)}:domain/example.com"),
 *         TriggerArn = Output.Tuple(defaultGetRegions, @default).Apply(values =>
 *         {
 *             var defaultGetRegions = values.Item1;
 *             var @default = values.Item2;
 *             return $"acs:fc:{defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:{@default.Apply(getAccountResult => getAccountResult.Id)}:services/FCTestService/functions/printEvent/triggers/testtrigger";
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cdn.NewFcTrigger(ctx, "example", &cdn.FcTriggerArgs{
 * 			EventMetaName:    pulumi.String("LogFileCreated"),
 * 			EventMetaVersion: pulumi.String("1.0.0"),
 * 			Notes:            pulumi.String("example_value"),
 * 			RoleArn:          pulumi.Sprintf("acs:ram::%v:role/aliyuncdneventnotificationrole", _default.Id),
 * 			SourceArn:        pulumi.Sprintf("acs:cdn:*:%v:domain/example.com", _default.Id),
 * 			TriggerArn:       pulumi.Sprintf("acs:fc:%v:%v:services/FCTestService/functions/printEvent/triggers/testtrigger", defaultGetRegions.Regions[0].Id, _default.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.cdn.FcTrigger;
 * import com.pulumi.alicloud.cdn.FcTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getAccount();
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var example = new FcTrigger("example", FcTriggerArgs.builder()
 *             .eventMetaName("LogFileCreated")
 *             .eventMetaVersion("1.0.0")
 *             .notes("example_value")
 *             .roleArn(String.format("acs:ram::%s:role/aliyuncdneventnotificationrole", default_.id()))
 *             .sourceArn(String.format("acs:cdn:*:%s:domain/example.com", default_.id()))
 *             .triggerArn(String.format("acs:fc:%s:%s:services/FCTestService/functions/printEvent/triggers/testtrigger", defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()),default_.id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cdn:FcTrigger
 *     properties:
 *       eventMetaName: LogFileCreated
 *       eventMetaVersion: 1.0.0
 *       notes: example_value
 *       roleArn: acs:ram::${default.id}:role/aliyuncdneventnotificationrole
 *       sourceArn: acs:cdn:*:${default.id}:domain/example.com
 *       triggerArn: acs:fc:${defaultGetRegions.regions[0].id}:${default.id}:services/FCTestService/functions/printEvent/triggers/testtrigger
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CDN Fc Trigger can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cdn/fcTrigger:FcTrigger example <trigger_arn>
 * ```
 */
public class FcTrigger internal constructor(
    override val javaResource: com.pulumi.alicloud.cdn.FcTrigger,
) : KotlinCustomResource(javaResource, FcTriggerMapper) {
    /**
     * The name of the Event.
     */
    public val eventMetaName: Output<String>
        get() = javaResource.eventMetaName().applyValue({ args0 -> args0 })

    /**
     * The version of the Event.
     */
    public val eventMetaVersion: Output<String>
        get() = javaResource.eventMetaVersion().applyValue({ args0 -> args0 })

    /**
     * The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
     */
    public val functionArn: Output<String>?
        get() = javaResource.functionArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Note information.
     */
    public val notes: Output<String>
        get() = javaResource.notes().applyValue({ args0 -> args0 })

    /**
     * The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
     */
    public val sourceArn: Output<String>
        get() = javaResource.sourceArn().applyValue({ args0 -> args0 })

    /**
     * The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
     */
    public val triggerArn: Output<String>
        get() = javaResource.triggerArn().applyValue({ args0 -> args0 })
}

public object FcTriggerMapper : ResourceMapper<FcTrigger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.cdn.FcTrigger::class == javaResource::class

    override fun map(javaResource: Resource): FcTrigger = FcTrigger(
        javaResource as
            com.pulumi.alicloud.cdn.FcTrigger,
    )
}

/**
 * @see [FcTrigger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FcTrigger].
 */
public suspend fun fcTrigger(name: String, block: suspend FcTriggerResourceBuilder.() -> Unit): FcTrigger {
    val builder = FcTriggerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FcTrigger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fcTrigger(name: String): FcTrigger {
    val builder = FcTriggerResourceBuilder()
    builder.name(name)
    return builder.build()
}
