@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin

import com.pulumi.alicloud.cdn.FcTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CDN Fc Trigger resource.
 * For information about CDN Fc Trigger and how to use it, see [What is Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger).
 * > **NOTE:** Available in v1.165.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.getAccount({});
 * const defaultGetRegions = alicloud.getRegions({
 *     current: true,
 * });
 * const example = new alicloud.cdn.FcTrigger("example", {
 *     eventMetaName: "LogFileCreated",
 *     eventMetaVersion: "1.0.0",
 *     notes: "example_value",
 *     roleArn: _default.then(_default => `acs:ram::${_default.id}:role/aliyuncdneventnotificationrole`),
 *     sourceArn: _default.then(_default => `acs:cdn:*:${_default.id}:domain/example.com`),
 *     triggerArn: Promise.all([defaultGetRegions, _default])&#46;then(([defaultGetRegions, _default]) => `acs:fc:${defaultGetRegions&#46;regions?&#46;[0]?.id}:${_default.id}:services/FCTestService/functions/printEvent/triggers/testtrigger`),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.get_account()
 * default_get_regions = alicloud.get_regions(current=True)
 * example = alicloud.cdn.FcTrigger("example",
 *     event_meta_name="LogFileCreated",
 *     event_meta_version="1.0.0",
 *     notes="example_value",
 *     role_arn=f"acs:ram::{default.id}:role/aliyuncdneventnotificationrole",
 *     source_arn=f"acs:cdn:*:{default.id}:domain/example.com",
 *     trigger_arn=f"acs:fc:{default_get_regions.regions[0].id}:{default.id}:services/FCTestService/functions/printEvent/triggers/testtrigger")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.GetAccount.Invoke();
 *     var defaultGetRegions = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var example = new AliCloud.Cdn.FcTrigger("example", new()
 *     {
 *         EventMetaName = "LogFileCreated",
 *         EventMetaVersion = "1.0.0",
 *         Notes = "example_value",
 *         RoleArn = @default.Apply(@default => $"acs:ram::{@default.Apply(getAccountResult => getAccountResult.Id)}:role/aliyuncdneventnotificationrole"),
 *         SourceArn = @default.Apply(@default => $"acs:cdn:*:{@default.Apply(getAccountResult => getAccountResult.Id)}:domain/example.com"),
 *         TriggerArn = Output.Tuple(defaultGetRegions, @default).Apply(values =>
 *         {
 *             var defaultGetRegions = values.Item1;
 *             var @default = values.Item2;
 *             return $"acs:fc:{defaultGetRegions.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)}:{@default.Apply(getAccountResult => getAccountResult.Id)}:services/FCTestService/functions/printEvent/triggers/testtrigger";
 *         }),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := alicloud.GetAccount(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetRegions, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cdn.NewFcTrigger(ctx, "example", &cdn.FcTriggerArgs{
 * 			EventMetaName:    pulumi.String("LogFileCreated"),
 * 			EventMetaVersion: pulumi.String("1.0.0"),
 * 			Notes:            pulumi.String("example_value"),
 * 			RoleArn:          pulumi.Sprintf("acs:ram::%v:role/aliyuncdneventnotificationrole", _default.Id),
 * 			SourceArn:        pulumi.Sprintf("acs:cdn:*:%v:domain/example.com", _default.Id),
 * 			TriggerArn:       pulumi.Sprintf("acs:fc:%v:%v:services/FCTestService/functions/printEvent/triggers/testtrigger", defaultGetRegions.Regions[0].Id, _default.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.cdn.FcTrigger;
 * import com.pulumi.alicloud.cdn.FcTriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = AlicloudFunctions.getAccount();
 *         final var defaultGetRegions = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var example = new FcTrigger("example", FcTriggerArgs.builder()
 *             .eventMetaName("LogFileCreated")
 *             .eventMetaVersion("1.0.0")
 *             .notes("example_value")
 *             .roleArn(String.format("acs:ram::%s:role/aliyuncdneventnotificationrole", default_.id()))
 *             .sourceArn(String.format("acs:cdn:*:%s:domain/example.com", default_.id()))
 *             .triggerArn(String.format("acs:fc:%s:%s:services/FCTestService/functions/printEvent/triggers/testtrigger", defaultGetRegions.applyValue(getRegionsResult -> getRegionsResult.regions()[0].id()),default_.id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: alicloud:cdn:FcTrigger
 *     properties:
 *       eventMetaName: LogFileCreated
 *       eventMetaVersion: 1.0.0
 *       notes: example_value
 *       roleArn: acs:ram::${default.id}:role/aliyuncdneventnotificationrole
 *       sourceArn: acs:cdn:*:${default.id}:domain/example.com
 *       triggerArn: acs:fc:${defaultGetRegions.regions[0].id}:${default.id}:services/FCTestService/functions/printEvent/triggers/testtrigger
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getAccount
 *       Arguments: {}
 *   defaultGetRegions:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CDN Fc Trigger can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cdn/fcTrigger:FcTrigger example <trigger_arn>
 * ```
 * @property eventMetaName The name of the Event.
 * @property eventMetaVersion The version of the Event.
 * @property functionArn The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
 * @property notes The Note information.
 * @property roleArn The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
 * @property sourceArn Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
 * @property triggerArn The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
 */
public data class FcTriggerArgs(
    public val eventMetaName: Output<String>? = null,
    public val eventMetaVersion: Output<String>? = null,
    public val functionArn: Output<String>? = null,
    public val notes: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val sourceArn: Output<String>? = null,
    public val triggerArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.FcTriggerArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.FcTriggerArgs =
        com.pulumi.alicloud.cdn.FcTriggerArgs.builder()
            .eventMetaName(eventMetaName?.applyValue({ args0 -> args0 }))
            .eventMetaVersion(eventMetaVersion?.applyValue({ args0 -> args0 }))
            .functionArn(functionArn?.applyValue({ args0 -> args0 }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .sourceArn(sourceArn?.applyValue({ args0 -> args0 }))
            .triggerArn(triggerArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FcTriggerArgs].
 */
@PulumiTagMarker
public class FcTriggerArgsBuilder internal constructor() {
    private var eventMetaName: Output<String>? = null

    private var eventMetaVersion: Output<String>? = null

    private var functionArn: Output<String>? = null

    private var notes: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var sourceArn: Output<String>? = null

    private var triggerArn: Output<String>? = null

    /**
     * @param value The name of the Event.
     */
    @JvmName("cxkrgmjelofxaklg")
    public suspend fun eventMetaName(`value`: Output<String>) {
        this.eventMetaName = value
    }

    /**
     * @param value The version of the Event.
     */
    @JvmName("eyelpljgixqycsyv")
    public suspend fun eventMetaVersion(`value`: Output<String>) {
        this.eventMetaVersion = value
    }

    /**
     * @param value The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
     */
    @JvmName("dnwrruqlhbiegeea")
    public suspend fun functionArn(`value`: Output<String>) {
        this.functionArn = value
    }

    /**
     * @param value The Note information.
     */
    @JvmName("guavxaiewyvqipqm")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
     */
    @JvmName("odaltmghmjigkcpn")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
     */
    @JvmName("ivjufxungpkehfau")
    public suspend fun sourceArn(`value`: Output<String>) {
        this.sourceArn = value
    }

    /**
     * @param value The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
     */
    @JvmName("tedtwucrsbcwiwwn")
    public suspend fun triggerArn(`value`: Output<String>) {
        this.triggerArn = value
    }

    /**
     * @param value The name of the Event.
     */
    @JvmName("qwrkpblnxvmeswce")
    public suspend fun eventMetaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventMetaName = mapped
    }

    /**
     * @param value The version of the Event.
     */
    @JvmName("eaahvkchoqythknr")
    public suspend fun eventMetaVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventMetaVersion = mapped
    }

    /**
     * @param value The function arn. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`.
     */
    @JvmName("nfvhadirwswgbcfl")
    public suspend fun functionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionArn = mapped
    }

    /**
     * @param value The Note information.
     */
    @JvmName("coaxttwuwiwmvnjq")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value The role authorized by RAM. The value formats as `acs:ram::{AccountID}:role/{RoleName}`.
     */
    @JvmName("vxootswgdnddafei")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Resources and filters for event listening. The value formats as `acs:cdn:{RegionID}:{AccountID}:{Filter}`.
     */
    @JvmName("aeiugruwnfyifjsl")
    public suspend fun sourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceArn = mapped
    }

    /**
     * @param value The trigger corresponding to the function Compute Service. The value formats as `acs:fc:{RegionID}:{AccountID}:{Filter}`. See [Create a CDN Fc Trigger](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-addfctrigger) for more details.
     */
    @JvmName("typciqtaevotodki")
    public suspend fun triggerArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerArn = mapped
    }

    internal fun build(): FcTriggerArgs = FcTriggerArgs(
        eventMetaName = eventMetaName,
        eventMetaVersion = eventMetaVersion,
        functionArn = functionArn,
        notes = notes,
        roleArn = roleArn,
        sourceArn = sourceArn,
        triggerArn = triggerArn,
    )
}
