@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin

import com.pulumi.alicloud.cdn.RealTimeLogDeliveryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a CDN Real Time Log Delivery resource.
 * For information about CDN Real Time Log Delivery and how to use it, see [What is Real Time Log Delivery](https://www.alibabacloud.com/help/en/cdn/developer-reference/api-cdn-2018-05-10-createrealtimelogdelivery).
 * > **NOTE:** Available since v1.134.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const defaultInteger = new random.index.Integer("default", {
 *     max: 99999,
 *     min: 10000,
 * });
 * const defaultDomainNew = new alicloud.cdn.DomainNew("default", {
 *     scope: "overseas",
 *     domainName: `mycdndomain-${defaultInteger.result}.alicloud-provider.cn`,
 *     cdnType: "web",
 *     sources: [{
 *         type: "ipaddr",
 *         content: "1.1.3.1",
 *         priority: 20,
 *         port: 80,
 *         weight: 15,
 *     }],
 * });
 * const defaultProject = new alicloud.log.Project("default", {
 *     projectName: `terraform-example-${defaultInteger.result}`,
 *     description: "terraform-example",
 * });
 * const defaultStore = new alicloud.log.Store("default", {
 *     projectName: defaultProject.name,
 *     logstoreName: "example-store",
 *     shardCount: 3,
 *     autoSplit: true,
 *     maxSplitShardCount: 60,
 *     appendMeta: true,
 * });
 * const default = alicloud.getRegions({
 *     current: true,
 * });
 * const defaultRealTimeLogDelivery = new alicloud.cdn.RealTimeLogDelivery("default", {
 *     domain: defaultDomainNew.domainName,
 *     logstore: defaultStore.logstoreName,
 *     project: defaultProject.projectName,
 *     slsRegion: _default.then(_default => _default.regions?.[0]?.id),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default_integer = random.index.Integer("default",
 *     max=99999,
 *     min=10000)
 * default_domain_new = alicloud.cdn.DomainNew("default",
 *     scope="overseas",
 *     domain_name=f"mycdndomain-{default_integer['result']}.alicloud-provider.cn",
 *     cdn_type="web",
 *     sources=[{
 *         "type": "ipaddr",
 *         "content": "1.1.3.1",
 *         "priority": 20,
 *         "port": 80,
 *         "weight": 15,
 *     }])
 * default_project = alicloud.log.Project("default",
 *     project_name=f"terraform-example-{default_integer['result']}",
 *     description="terraform-example")
 * default_store = alicloud.log.Store("default",
 *     project_name=default_project.name,
 *     logstore_name="example-store",
 *     shard_count=3,
 *     auto_split=True,
 *     max_split_shard_count=60,
 *     append_meta=True)
 * default = alicloud.get_regions(current=True)
 * default_real_time_log_delivery = alicloud.cdn.RealTimeLogDelivery("default",
 *     domain=default_domain_new.domain_name,
 *     logstore=default_store.logstore_name,
 *     project=default_project.project_name,
 *     sls_region=default.regions[0].id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultInteger = new Random.Index.Integer("default", new()
 *     {
 *         Max = 99999,
 *         Min = 10000,
 *     });
 *     var defaultDomainNew = new AliCloud.Cdn.DomainNew("default", new()
 *     {
 *         Scope = "overseas",
 *         DomainName = $"mycdndomain-{defaultInteger.Result}.alicloud-provider.cn",
 *         CdnType = "web",
 *         Sources = new[]
 *         {
 *             new AliCloud.Cdn.Inputs.DomainNewSourceArgs
 *             {
 *                 Type = "ipaddr",
 *                 Content = "1.1.3.1",
 *                 Priority = 20,
 *                 Port = 80,
 *                 Weight = 15,
 *             },
 *         },
 *     });
 *     var defaultProject = new AliCloud.Log.Project("default", new()
 *     {
 *         ProjectName = $"terraform-example-{defaultInteger.Result}",
 *         Description = "terraform-example",
 *     });
 *     var defaultStore = new AliCloud.Log.Store("default", new()
 *     {
 *         ProjectName = defaultProject.Name,
 *         LogstoreName = "example-store",
 *         ShardCount = 3,
 *         AutoSplit = true,
 *         MaxSplitShardCount = 60,
 *         AppendMeta = true,
 *     });
 *     var @default = AliCloud.GetRegions.Invoke(new()
 *     {
 *         Current = true,
 *     });
 *     var defaultRealTimeLogDelivery = new AliCloud.Cdn.RealTimeLogDelivery("default", new()
 *     {
 *         Domain = defaultDomainNew.DomainName,
 *         Logstore = defaultStore.LogstoreName,
 *         Project = defaultProject.ProjectName,
 *         SlsRegion = @default.Apply(@default => @default.Apply(getRegionsResult => getRegionsResult.Regions[0]?.Id)),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cdn"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/log"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		defaultInteger, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Max: 99999,
 * 			Min: 10000,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultDomainNew, err := cdn.NewDomainNew(ctx, "default", &cdn.DomainNewArgs{
 * 			Scope:      pulumi.String("overseas"),
 * 			DomainName: pulumi.Sprintf("mycdndomain-%v.alicloud-provider.cn", defaultInteger.Result),
 * 			CdnType:    pulumi.String("web"),
 * 			Sources: cdn.DomainNewSourceArray{
 * 				&cdn.DomainNewSourceArgs{
 * 					Type:     pulumi.String("ipaddr"),
 * 					Content:  pulumi.String("1.1.3.1"),
 * 					Priority: pulumi.Int(20),
 * 					Port:     pulumi.Int(80),
 * 					Weight:   pulumi.Int(15),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultProject, err := log.NewProject(ctx, "default", &log.ProjectArgs{
 * 			ProjectName: pulumi.Sprintf("terraform-example-%v", defaultInteger.Result),
 * 			Description: pulumi.String("terraform-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultStore, err := log.NewStore(ctx, "default", &log.StoreArgs{
 * 			ProjectName:        defaultProject.Name,
 * 			LogstoreName:       pulumi.String("example-store"),
 * 			ShardCount:         pulumi.Int(3),
 * 			AutoSplit:          pulumi.Bool(true),
 * 			MaxSplitShardCount: pulumi.Int(60),
 * 			AppendMeta:         pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_default, err := alicloud.GetRegions(ctx, &alicloud.GetRegionsArgs{
 * 			Current: pulumi.BoolRef(true),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = cdn.NewRealTimeLogDelivery(ctx, "default", &cdn.RealTimeLogDeliveryArgs{
 * 			Domain:    defaultDomainNew.DomainName,
 * 			Logstore:  defaultStore.LogstoreName,
 * 			Project:   defaultProject.ProjectName,
 * 			SlsRegion: pulumi.String(_default.Regions[0].Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.cdn.DomainNew;
 * import com.pulumi.alicloud.cdn.DomainNewArgs;
 * import com.pulumi.alicloud.cdn.inputs.DomainNewSourceArgs;
 * import com.pulumi.alicloud.log.Project;
 * import com.pulumi.alicloud.log.ProjectArgs;
 * import com.pulumi.alicloud.log.Store;
 * import com.pulumi.alicloud.log.StoreArgs;
 * import com.pulumi.alicloud.AlicloudFunctions;
 * import com.pulumi.alicloud.inputs.GetRegionsArgs;
 * import com.pulumi.alicloud.cdn.RealTimeLogDelivery;
 * import com.pulumi.alicloud.cdn.RealTimeLogDeliveryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultInteger = new Integer("defaultInteger", IntegerArgs.builder()
 *             .max(99999)
 *             .min(10000)
 *             .build());
 *         var defaultDomainNew = new DomainNew("defaultDomainNew", DomainNewArgs.builder()
 *             .scope("overseas")
 *             .domainName(String.format("mycdndomain-%s.alicloud-provider.cn", defaultInteger.result()))
 *             .cdnType("web")
 *             .sources(DomainNewSourceArgs.builder()
 *                 .type("ipaddr")
 *                 .content("1.1.3.1")
 *                 .priority(20)
 *                 .port(80)
 *                 .weight(15)
 *                 .build())
 *             .build());
 *         var defaultProject = new Project("defaultProject", ProjectArgs.builder()
 *             .projectName(String.format("terraform-example-%s", defaultInteger.result()))
 *             .description("terraform-example")
 *             .build());
 *         var defaultStore = new Store("defaultStore", StoreArgs.builder()
 *             .projectName(defaultProject.name())
 *             .logstoreName("example-store")
 *             .shardCount(3)
 *             .autoSplit(true)
 *             .maxSplitShardCount(60)
 *             .appendMeta(true)
 *             .build());
 *         final var default = AlicloudFunctions.getRegions(GetRegionsArgs.builder()
 *             .current(true)
 *             .build());
 *         var defaultRealTimeLogDelivery = new RealTimeLogDelivery("defaultRealTimeLogDelivery", RealTimeLogDeliveryArgs.builder()
 *             .domain(defaultDomainNew.domainName())
 *             .logstore(defaultStore.logstoreName())
 *             .project(defaultProject.projectName())
 *             .slsRegion(default_.regions()[0].id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   defaultInteger:
 *     type: random:integer
 *     name: default
 *     properties:
 *       max: 99999
 *       min: 10000
 *   defaultDomainNew:
 *     type: alicloud:cdn:DomainNew
 *     name: default
 *     properties:
 *       scope: overseas
 *       domainName: mycdndomain-${defaultInteger.result}.alicloud-provider.cn
 *       cdnType: web
 *       sources:
 *         - type: ipaddr
 *           content: 1.1.3.1
 *           priority: 20
 *           port: 80
 *           weight: 15
 *   defaultProject:
 *     type: alicloud:log:Project
 *     name: default
 *     properties:
 *       projectName: terraform-example-${defaultInteger.result}
 *       description: terraform-example
 *   defaultStore:
 *     type: alicloud:log:Store
 *     name: default
 *     properties:
 *       projectName: ${defaultProject.name}
 *       logstoreName: example-store
 *       shardCount: 3
 *       autoSplit: true
 *       maxSplitShardCount: 60
 *       appendMeta: true
 *   defaultRealTimeLogDelivery:
 *     type: alicloud:cdn:RealTimeLogDelivery
 *     name: default
 *     properties:
 *       domain: ${defaultDomainNew.domainName}
 *       logstore: ${defaultStore.logstoreName}
 *       project: ${defaultProject.projectName}
 *       slsRegion: ${default.regions[0].id}
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:getRegions
 *       Arguments:
 *         current: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * CDN Real Time Log Delivery can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:cdn/realTimeLogDelivery:RealTimeLogDelivery example <domain>
 * ```
 * @property domain The accelerated domain name for which you want to configure real-time log delivery. You can specify multiple domain names and separate them with commas (,).
 * @property logstore The name of the Logstore that collects log data from Alibaba Cloud Content Delivery Network (CDN) in real time.
 * @property project The name of the Log Service project that is used for real-time log delivery.
 * @property slsRegion The region where the Log Service project is deployed.
 * > **NOTE:** If your Project and Logstore services already exist, if you continue to create existing content, the created content will overwrite your existing indexes and custom reports. Please be careful to create your existing services to avoid affecting your online services after coverage.
 */
public data class RealTimeLogDeliveryArgs(
    public val domain: Output<String>? = null,
    public val logstore: Output<String>? = null,
    public val project: Output<String>? = null,
    public val slsRegion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.RealTimeLogDeliveryArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.RealTimeLogDeliveryArgs =
        com.pulumi.alicloud.cdn.RealTimeLogDeliveryArgs.builder()
            .domain(domain?.applyValue({ args0 -> args0 }))
            .logstore(logstore?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .slsRegion(slsRegion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RealTimeLogDeliveryArgs].
 */
@PulumiTagMarker
public class RealTimeLogDeliveryArgsBuilder internal constructor() {
    private var domain: Output<String>? = null

    private var logstore: Output<String>? = null

    private var project: Output<String>? = null

    private var slsRegion: Output<String>? = null

    /**
     * @param value The accelerated domain name for which you want to configure real-time log delivery. You can specify multiple domain names and separate them with commas (,).
     */
    @JvmName("lqkpgrmjrwwclifv")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The name of the Logstore that collects log data from Alibaba Cloud Content Delivery Network (CDN) in real time.
     */
    @JvmName("ibfpybruetumbdgk")
    public suspend fun logstore(`value`: Output<String>) {
        this.logstore = value
    }

    /**
     * @param value The name of the Log Service project that is used for real-time log delivery.
     */
    @JvmName("qeliaglbabuwuoit")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value The region where the Log Service project is deployed.
     * > **NOTE:** If your Project and Logstore services already exist, if you continue to create existing content, the created content will overwrite your existing indexes and custom reports. Please be careful to create your existing services to avoid affecting your online services after coverage.
     */
    @JvmName("eeprviekvmroojbw")
    public suspend fun slsRegion(`value`: Output<String>) {
        this.slsRegion = value
    }

    /**
     * @param value The accelerated domain name for which you want to configure real-time log delivery. You can specify multiple domain names and separate them with commas (,).
     */
    @JvmName("qpaeacoyrkjaanik")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The name of the Logstore that collects log data from Alibaba Cloud Content Delivery Network (CDN) in real time.
     */
    @JvmName("stmnrxjrefaqfnwk")
    public suspend fun logstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstore = mapped
    }

    /**
     * @param value The name of the Log Service project that is used for real-time log delivery.
     */
    @JvmName("pdjmpltdeoymabpk")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value The region where the Log Service project is deployed.
     * > **NOTE:** If your Project and Logstore services already exist, if you continue to create existing content, the created content will overwrite your existing indexes and custom reports. Please be careful to create your existing services to avoid affecting your online services after coverage.
     */
    @JvmName("gjrowgscwqcnicoi")
    public suspend fun slsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsRegion = mapped
    }

    internal fun build(): RealTimeLogDeliveryArgs = RealTimeLogDeliveryArgs(
        domain = domain,
        logstore = logstore,
        project = project,
        slsRegion = slsRegion,
    )
}
