@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.DomainAuthConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authType
 * @property masterKey
 * @property slaveKey
 * @property timeout
 */
public data class DomainAuthConfigArgs(
    public val authType: Output<String>? = null,
    public val masterKey: Output<String>? = null,
    public val slaveKey: Output<String>? = null,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.DomainAuthConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.DomainAuthConfigArgs =
        com.pulumi.alicloud.cdn.inputs.DomainAuthConfigArgs.builder()
            .authType(authType?.applyValue({ args0 -> args0 }))
            .masterKey(masterKey?.applyValue({ args0 -> args0 }))
            .slaveKey(slaveKey?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainAuthConfigArgs].
 */
@PulumiTagMarker
public class DomainAuthConfigArgsBuilder internal constructor() {
    private var authType: Output<String>? = null

    private var masterKey: Output<String>? = null

    private var slaveKey: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("jrhdowpqeaguhjje")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value
     */
    @JvmName("wtyrurcuoaxjuahp")
    public suspend fun masterKey(`value`: Output<String>) {
        this.masterKey = value
    }

    /**
     * @param value
     */
    @JvmName("otjrcnybkmaekbyb")
    public suspend fun slaveKey(`value`: Output<String>) {
        this.slaveKey = value
    }

    /**
     * @param value
     */
    @JvmName("dfwofrijcxjjceiw")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value
     */
    @JvmName("noqjdiwkewpahqxd")
    public suspend fun authType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    /**
     * @param value
     */
    @JvmName("bkbkbllsdaxbegsn")
    public suspend fun masterKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterKey = mapped
    }

    /**
     * @param value
     */
    @JvmName("awxdrxpauomsulgp")
    public suspend fun slaveKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slaveKey = mapped
    }

    /**
     * @param value
     */
    @JvmName("vbnkqyxogadcbbqg")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): DomainAuthConfigArgs = DomainAuthConfigArgs(
        authType = authType,
        masterKey = masterKey,
        slaveKey = slaveKey,
        timeout = timeout,
    )
}
