@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.DomainCacheConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cacheContent
 * @property cacheId
 * @property cacheType
 * @property ttl
 * @property weight
 */
public data class DomainCacheConfigArgs(
    public val cacheContent: Output<String>,
    public val cacheId: Output<String>? = null,
    public val cacheType: Output<String>,
    public val ttl: Output<Int>,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.DomainCacheConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.DomainCacheConfigArgs =
        com.pulumi.alicloud.cdn.inputs.DomainCacheConfigArgs.builder()
            .cacheContent(cacheContent.applyValue({ args0 -> args0 }))
            .cacheId(cacheId?.applyValue({ args0 -> args0 }))
            .cacheType(cacheType.applyValue({ args0 -> args0 }))
            .ttl(ttl.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainCacheConfigArgs].
 */
@PulumiTagMarker
public class DomainCacheConfigArgsBuilder internal constructor() {
    private var cacheContent: Output<String>? = null

    private var cacheId: Output<String>? = null

    private var cacheType: Output<String>? = null

    private var ttl: Output<Int>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("cchvcmkqycagvmrv")
    public suspend fun cacheContent(`value`: Output<String>) {
        this.cacheContent = value
    }

    /**
     * @param value
     */
    @JvmName("rhsgtnqxsrfwoomw")
    public suspend fun cacheId(`value`: Output<String>) {
        this.cacheId = value
    }

    /**
     * @param value
     */
    @JvmName("onjvpsyxgjwsjyli")
    public suspend fun cacheType(`value`: Output<String>) {
        this.cacheType = value
    }

    /**
     * @param value
     */
    @JvmName("lrbplpiuvwvdqell")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value
     */
    @JvmName("nheplgqhuvphqyhv")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value
     */
    @JvmName("xlxlwxphkwnoawat")
    public suspend fun cacheContent(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheContent = mapped
    }

    /**
     * @param value
     */
    @JvmName("vrdiokbctjoegxfm")
    public suspend fun cacheId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheId = mapped
    }

    /**
     * @param value
     */
    @JvmName("mlsrthdnrxyheafn")
    public suspend fun cacheType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheType = mapped
    }

    /**
     * @param value
     */
    @JvmName("snygddvgijbcsqbu")
    public suspend fun ttl(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value
     */
    @JvmName("pxmgsqxweevhunig")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): DomainCacheConfigArgs = DomainCacheConfigArgs(
        cacheContent = cacheContent ?: throw PulumiNullFieldException("cacheContent"),
        cacheId = cacheId,
        cacheType = cacheType ?: throw PulumiNullFieldException("cacheType"),
        ttl = ttl ?: throw PulumiNullFieldException("ttl"),
        weight = weight,
    )
}
