@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.DomainCertificateConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateKey
 * @property serverCertificate
 * @property serverCertificateStatus
 */
public data class DomainCertificateConfigArgs(
    public val privateKey: Output<String>? = null,
    public val serverCertificate: Output<String>? = null,
    public val serverCertificateStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.DomainCertificateConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.DomainCertificateConfigArgs =
        com.pulumi.alicloud.cdn.inputs.DomainCertificateConfigArgs.builder()
            .privateKey(privateKey?.applyValue({ args0 -> args0 }))
            .serverCertificate(serverCertificate?.applyValue({ args0 -> args0 }))
            .serverCertificateStatus(serverCertificateStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainCertificateConfigArgs].
 */
@PulumiTagMarker
public class DomainCertificateConfigArgsBuilder internal constructor() {
    private var privateKey: Output<String>? = null

    private var serverCertificate: Output<String>? = null

    private var serverCertificateStatus: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ysfwwyekhnekvesw")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value
     */
    @JvmName("bhtxtprjmphtctim")
    public suspend fun serverCertificate(`value`: Output<String>) {
        this.serverCertificate = value
    }

    /**
     * @param value
     */
    @JvmName("ynslihfykscftxmw")
    public suspend fun serverCertificateStatus(`value`: Output<String>) {
        this.serverCertificateStatus = value
    }

    /**
     * @param value
     */
    @JvmName("vqbholkmklhfxqle")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value
     */
    @JvmName("dfxtlgyvoogimegu")
    public suspend fun serverCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificate = mapped
    }

    /**
     * @param value
     */
    @JvmName("omucmkevenudcvej")
    public suspend fun serverCertificateStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCertificateStatus = mapped
    }

    internal fun build(): DomainCertificateConfigArgs = DomainCertificateConfigArgs(
        privateKey = privateKey,
        serverCertificate = serverCertificate,
        serverCertificateStatus = serverCertificateStatus,
    )
}
