@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cdn.kotlin.inputs

import com.pulumi.alicloud.cdn.inputs.DomainHttpHeaderConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property headerId
 * @property headerKey
 * @property headerValue
 */
public data class DomainHttpHeaderConfigArgs(
    public val headerId: Output<String>? = null,
    public val headerKey: Output<String>,
    public val headerValue: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cdn.inputs.DomainHttpHeaderConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cdn.inputs.DomainHttpHeaderConfigArgs =
        com.pulumi.alicloud.cdn.inputs.DomainHttpHeaderConfigArgs.builder()
            .headerId(headerId?.applyValue({ args0 -> args0 }))
            .headerKey(headerKey.applyValue({ args0 -> args0 }))
            .headerValue(headerValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainHttpHeaderConfigArgs].
 */
@PulumiTagMarker
public class DomainHttpHeaderConfigArgsBuilder internal constructor() {
    private var headerId: Output<String>? = null

    private var headerKey: Output<String>? = null

    private var headerValue: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("xyeevsamvnyjunak")
    public suspend fun headerId(`value`: Output<String>) {
        this.headerId = value
    }

    /**
     * @param value
     */
    @JvmName("nyeptqeseepqikrb")
    public suspend fun headerKey(`value`: Output<String>) {
        this.headerKey = value
    }

    /**
     * @param value
     */
    @JvmName("vyfwoegqrgkrnjue")
    public suspend fun headerValue(`value`: Output<String>) {
        this.headerValue = value
    }

    /**
     * @param value
     */
    @JvmName("qtbyoxhicxoubfaa")
    public suspend fun headerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerId = mapped
    }

    /**
     * @param value
     */
    @JvmName("siebnochbmmnshtu")
    public suspend fun headerKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerKey = mapped
    }

    /**
     * @param value
     */
    @JvmName("sclltetnfpphkjvi")
    public suspend fun headerValue(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerValue = mapped
    }

    internal fun build(): DomainHttpHeaderConfigArgs = DomainHttpHeaderConfigArgs(
        headerId = headerId,
        headerKey = headerKey ?: throw PulumiNullFieldException("headerKey"),
        headerValue = headerValue ?: throw PulumiNullFieldException("headerValue"),
    )
}
